/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.core.module.visengine.rs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.script.ScriptException;
import rs.co.ast.aspen.api.service.SecurityEvent;
import rs.co.ast.aspen.core.module.visengine.actions.Action;
import rs.co.ast.aspen.core.module.visengine.graph.Edge;
import rs.co.ast.aspen.core.module.visengine.graph.Graph;
import rs.co.ast.aspen.core.module.visengine.graph.Node;
import rs.co.ast.aspen.core.module.visengine.graph.Template;
import rs.co.ast.aspen.core.module.visengine.rs.Check;
import rs.co.ast.aspen.core.module.visengine.rs.Rule;
import rs.co.ast.aspen.core.module.visengine.scripting.ExpressionEvaluator;

public class Ruleset {
    private final List<Action> initActions = new ArrayList<Action>();
    private boolean initialized = false;
    private final List<Rule> rules = new ArrayList<Rule>();
    private final Map<String, Template> templates = new HashMap<String, Template>();

    public static Ruleset fromJson(String ruleset) throws ScriptException {
        ExpressionEvaluator e = new ExpressionEvaluator(null);
        Map map = (Map)e.eval(ruleset, null, null);
        return Ruleset.fromMap(map);
    }

    public static Ruleset fromMap(Map<String, Object> map) {
        Map init;
        Ruleset rs = new Ruleset();
        Map tmpls = (Map)map.get("templates");
        if (tmpls != null) {
            for (Object tmpl : tmpls.values()) {
                Map t = (Map)tmpl;
                rs.addTemplate((String)t.get("name"), Template.fromMap((Map)t.get("attributes")));
            }
        }
        if ((init = (Map)map.get("initActions")) != null) {
            for (Object a : init.values()) {
                rs.addInitAction(Action.actionFromMap((Map)a, rs));
            }
        }
        Map rules = (Map)map.get("ruleset");
        for (Object rule : rules.values()) {
            rs.addRule(Rule.fromMap((Map)rule, rs));
        }
        return rs;
    }

    public void addInitAction(Action action) {
        this.initActions.add(action);
    }

    public void addRule(Rule rule) {
        this.rules.add(rule);
    }

    public void addTemplate(String name, Template tmpl) {
        this.templates.put(name, tmpl);
    }

    public Map mergeTemplates(Map params, String templatesKeyName, String attributesKeyName) {
        HashMap<String, String> ret = null;
        if (params != null) {
            Map attributes;
            ret = new HashMap<String, String>();
            Map tmpls = (Map)params.get(templatesKeyName);
            if (tmpls != null) {
                for (String tmpl : tmpls.values()) {
                    Template t = this.templates.get(tmpl);
                    if (t != null) {
                        ret.putAll(t.attributes);
                        continue;
                    }
                    throw new IllegalArgumentException("template " + tmpl + " not defined");
                }
            }
            if ((attributes = (Map)params.get(attributesKeyName)) != null) {
                ret.putAll(attributes);
            }
        }
        return ret;
    }

    public Check.Status process(Graph graph, SecurityEvent event) throws ScriptException {
        if (!this.initialized) {
            this.initialized = true;
            for (Action a : this.initActions) {
                a.execute(graph, null, null);
            }
        }
        Check.Status status = Check.Status.NO_MATCH;
        Iterator<Node> nodes = graph.rootNodes();
        boolean done = false;
        HashSet<String> visitedNodeIds = new HashSet<String>();
        while (status == Check.Status.NO_MATCH && !done) {
            Node node;
            Node node2 = node = nodes.hasNext() ? nodes.next() : null;
            if (!nodes.hasNext()) {
                done = true;
            }
            status = this.checkNode(graph, event, node, visitedNodeIds);
        }
        return status;
    }

    private Check.Status checkNode(Graph graph, SecurityEvent event, Node node, Set<String> visitedNodeIds) throws ScriptException {
        Check.Status status = Check.Status.NO_MATCH;
        Iterator<Rule> it = this.rules.iterator();
        while (it.hasNext() && status == Check.Status.NO_MATCH) {
            Rule rule = it.next();
            status = rule.evaluate(graph, event, node);
        }
        if (status == Check.Status.CONTINUE) {
            Iterator<Edge> edges;
            status = Check.Status.NO_MATCH;
            Iterator<Edge> iterator = edges = node != null ? node.edges() : null;
            while (edges != null && edges.hasNext() && status == Check.Status.NO_MATCH) {
                Node linked = edges.next().other(node);
                if (visitedNodeIds.contains(linked.id)) continue;
                visitedNodeIds.add(linked.id);
                status = this.checkNode(graph, event, linked, visitedNodeIds);
            }
        }
        return status;
    }
}

