/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.core.module.visengine.rs;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.script.ScriptException;
import rs.co.ast.aspen.api.service.SecurityEvent;
import rs.co.ast.aspen.core.module.visengine.graph.Graph;
import rs.co.ast.aspen.core.module.visengine.graph.Node;
import rs.co.ast.aspen.core.module.visengine.rs.Check;
import rs.co.ast.aspen.core.module.visengine.rs.Ruleset;
import rs.co.ast.aspen.core.module.visengine.scripting.ExpressionEvaluator;

public class Rule {
    public final List<Check> checks = new ArrayList<Check>();
    public final String eventsSelector;

    public static Rule fromMap(Map map, Ruleset rs) {
        Rule rule = new Rule((String)map.get("event_selector"));
        Map checks = (Map)map.get("checks");
        for (Object check : checks.values()) {
            rule.addCheck(Check.fromMap((Map)check, rs));
        }
        return rule;
    }

    public Rule(String eventsSelector) {
        this.eventsSelector = eventsSelector;
    }

    public void addCheck(Check check) {
        this.checks.add(check);
    }

    public Check.Status evaluate(Graph graph, SecurityEvent event, Node node) throws ScriptException {
        Check.Status status = Check.Status.NO_MATCH;
        boolean s = (Boolean)new ExpressionEvaluator(graph).eval(this.eventsSelector, event, null);
        if (s) {
            for (Check check : this.checks) {
                status = check.perform(graph, event, node);
                if (status == Check.Status.NO_MATCH) continue;
                return status;
            }
        }
        return status;
    }
}

