/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.core.module.visengine.graph;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import rs.co.ast.aspen.core.module.visengine.graph.Attributed;
import rs.co.ast.aspen.core.module.visengine.graph.EdgeId;
import rs.co.ast.aspen.core.module.visengine.graph.Node;

public class Edge
extends Attributed {
    public final String id;
    public final List<Node> nodes;

    public static List<Node> order(Node node1, Node node2) {
        ArrayList<Node> r = new ArrayList<Node>(2);
        r.add(node1);
        r.add(node2);
        Collections.sort(r, (o1, o2) -> o1.id.compareTo(o2.id));
        return r;
    }

    public Edge(Node node1, Node node2, Map<String, String> attrs) {
        super(attrs);
        this.nodes = Edge.order(node1, node2);
        this.id = new EdgeId(this.nodes, this.keyAttributes).toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Edge other = (Edge)obj;
        return Objects.equals(this.id, other.id);
    }

    public int hashCode() {
        int hash = 7;
        hash = 41 * hash + Objects.hashCode(this.id);
        return hash;
    }

    public Node other(Node node) {
        Node ret = null;
        if (node != null) {
            if (this.nodes.get((int)0).id.equals(node.id)) {
                ret = this.nodes.get(1);
            } else if (this.nodes.get((int)1).id.equals(node.id)) {
                ret = this.nodes.get(0);
            }
        }
        return ret;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry e : this.keyAttributes.entrySet()) {
            sb.append((String)e.getKey()).append(":").append((String)e.getValue()).append("\n");
        }
        return sb.toString();
    }
}

