/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.data;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import net.sf.jasperreports.data.excel.ExcelFormatEnum;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.data.AbstractPoiXlsDataSource;
import net.sf.jasperreports.repo.RepositoryContext;
import net.sf.jasperreports.repo.SimpleRepositoryContext;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelDataSource
extends AbstractPoiXlsDataSource {
    private ExcelFormatEnum format;

    public ExcelDataSource(Workbook workbook) {
        super(workbook);
    }

    public ExcelDataSource(InputStream is) throws JRException, IOException {
        this(is, ExcelFormatEnum.AUTODETECT);
    }

    public ExcelDataSource(InputStream is, ExcelFormatEnum format) throws JRException, IOException {
        super(is);
        this.format = format;
    }

    public ExcelDataSource(File file) throws JRException, IOException {
        this(file, ExcelFormatEnum.AUTODETECT);
    }

    public ExcelDataSource(File file, ExcelFormatEnum format) throws JRException, IOException {
        super(file);
        this.format = format;
    }

    public ExcelDataSource(JasperReportsContext jasperReportsContext, String location) throws JRException, IOException {
        this(SimpleRepositoryContext.of(jasperReportsContext), location);
    }

    public ExcelDataSource(RepositoryContext repositoryContext, String location) throws JRException, IOException {
        this(repositoryContext, location, ExcelFormatEnum.AUTODETECT);
    }

    public ExcelDataSource(JasperReportsContext jasperReportsContext, String location, ExcelFormatEnum format) throws JRException, IOException {
        this(SimpleRepositoryContext.of(jasperReportsContext), location, format);
    }

    public ExcelDataSource(RepositoryContext context, String location, ExcelFormatEnum format) throws JRException, IOException {
        super(context, location);
        this.format = format;
    }

    public ExcelDataSource(String location) throws JRException, IOException {
        this(location, ExcelFormatEnum.AUTODETECT);
    }

    public ExcelDataSource(String location, ExcelFormatEnum format) throws JRException, IOException {
        super(location);
        this.format = format;
    }

    @Override
    protected Workbook loadWorkbook(InputStream inputStream) throws IOException {
        Object workbook = null;
        this.format = this.format == null ? ExcelFormatEnum.AUTODETECT : this.format;
        switch (this.format) {
            case XLS: {
                workbook = new HSSFWorkbook(inputStream);
                break;
            }
            case XLSX: {
                workbook = new XSSFWorkbook(inputStream);
                break;
            }
            default: {
                BufferedInputStream bis = new BufferedInputStream(inputStream);
                bis.mark(4);
                int test1 = bis.read();
                int test2 = bis.read();
                int test3 = bis.read();
                int test4 = bis.read();
                bis.reset();
                workbook = test1 == 80 && test2 == 75 && test3 == 3 && test4 == 4 ? new XSSFWorkbook((InputStream)bis) : new HSSFWorkbook((InputStream)bis);
            }
        }
        return workbook;
    }
}

