/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.datamaps.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import rs.co.ast.aspen.gui.module.datamaps.DataMapKey;
import rs.co.ast.aspen.gui.module.datamaps.DataMapName;

public class DeletedDataMapsModel {
    private Map<String, List<String>> deletedKeys = new HashMap<String, List<String>>();

    public void addDeletedKeys(List<DataMapKey> keys) {
        if (keys != null) {
            for (DataMapKey key : keys) {
                this.addDeletedKey(key);
            }
        }
    }

    public void addDeletedKey(DataMapKey key) {
        if (key != null) {
            String keyName = key.getDmv().getKey();
            String mapName = key.getDmv().getMap();
            List<String> list = this.deletedKeys.get(mapName);
            if (list == null) {
                list = new ArrayList<String>();
                list.add(keyName);
            } else {
                list.add(keyName);
            }
            this.deletedKeys.put(mapName, list);
        }
    }

    public void addDeletedMaps(List<DataMapName> dataMaps) {
        for (DataMapName map : dataMaps) {
            this.addDeletedMap(map);
        }
    }

    public void addDeletedMap(DataMapName dataMap) {
        if (dataMap != null) {
            String mapName = dataMap.getName();
            ArrayList<String> list = new ArrayList<String>();
            list.add("*");
            this.deletedKeys.put(mapName, list);
        }
    }

    public boolean findMap(String mapName) {
        for (String map : this.deletedKeys.keySet()) {
            if (!map.equals(mapName)) continue;
            return true;
        }
        return false;
    }

    public boolean findKey(String mapName, String keyName) {
        List<String> keys = this.deletedKeys.get(mapName);
        if (keys != null) {
            for (String key : keys) {
                if (!key.equals(keyName)) continue;
                return true;
            }
        }
        return false;
    }

    public void reset() {
        this.deletedKeys = new HashMap<String, List<String>>();
    }
}

