/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.datamaps.model;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.table.DefaultTableModel;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import rs.co.ast.aspen.gui.module.datamaps.model.Column;
import rs.co.ast.aspen.gui.module.datamaps.model.DatabaseEvent;
import rs.co.ast.aspen.gui.module.datamaps.model.DatabaseEventListener;
import rs.co.ast.aspen.gui.module.datamaps.model.InMemoryDatabase;

public class DataMapTableModel
extends DefaultTableModel {
    private List<Column> columnModel = new ArrayList<Column>();
    private List<Column> columns = new ArrayList<Column>();
    private List<String> columnNames = new ArrayList<String>();
    private Column newlyAddedColumn;
    private int rowCount = 0;
    private int currentRowIndex = 0;
    private Map<String, String> currentRow;
    private InMemoryDatabase memDB = (InMemoryDatabase)Lookup.getDefault().lookup(InMemoryDatabase.class);

    public DataMapTableModel() {
        this.memDB.addDatabaseEventListener(new DatabaseEventListener(){

            @Override
            public void tableCreated(DatabaseEvent event) {
            }

            @Override
            public void dataInserted(DatabaseEvent event) {
                SwingWorker<Boolean, Void> worker = new SwingWorker<Boolean, Void>(){

                    @Override
                    protected Boolean doInBackground() throws Exception {
                        DataMapTableModel.this.rowCount = 0;
                        DataMapTableModel.this.currentRowIndex = 0;
                        DataMapTableModel.this.currentRow = null;
                        DataMapTableModel.this.columns.clear();
                        DataMapTableModel.this.columnNames.clear();
                        for (String s : DataMapTableModel.this.memDB.getColumns()) {
                            Column c = new Column(s);
                            DataMapTableModel.this.columns.add(c);
                            DataMapTableModel.this.columnNames.add(s);
                        }
                        DataMapTableModel.this.columnModel.addAll(DataMapTableModel.this.columns);
                        DataMapTableModel.this.memDB.setColumns(DataMapTableModel.this.columnNames);
                        DataMapTableModel.this.rowCount = DataMapTableModel.this.memDB.getRowCount();
                        return true;
                    }

                    @Override
                    protected void done() {
                        try {
                            this.get();
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    DataMapTableModel.this.fireTableStructureChanged();
                                    DataMapTableModel.this.fireTableDataChanged();
                                }
                            });
                        }
                        catch (InterruptedException | ExecutionException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                };
                worker.execute();
            }

            @Override
            public void functionQueryExecuted(DatabaseEvent event) {
            }
        });
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public String getColumnName(int column) {
        return this.columnNames != null ? this.columnNames.get(column) : "unknown";
    }

    @Override
    public int getColumnCount() {
        return this.columnNames != null ? this.columnNames.size() : 0;
    }

    @Override
    public Object getValueAt(int row, int column) {
        if (this.currentRowIndex != row || this.currentRow == null) {
            this.currentRow = this.memDB.selectSpecificRow(row);
            if (this.currentRow != null) {
                ++this.currentRowIndex;
            }
        }
        String col = this.columnNames.get(column);
        return this.currentRow.get(col);
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public Column getNewlyAddedColumn() {
        return this.newlyAddedColumn;
    }

    public void setNewlyAddedColumn(Column newlyAddedColumn) {
        this.newlyAddedColumn = newlyAddedColumn;
    }

    public Column getColumn(int column) {
        return !this.columnNames.isEmpty() ? new Column(this.columnNames.get(column)) : null;
    }

    public void resetData() {
        this.columnNames.clear();
        this.fireTableStructureChanged();
        this.fireTableDataChanged();
    }
}

