/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.constraints;

import com.jme3.animation.BoneTrack;
import com.jme3.animation.SpatialTrack;
import com.jme3.math.Quaternion;
import com.jme3.math.Transform;
import com.jme3.math.Vector3f;
import java.util.ArrayList;

class VirtualTrack {
    private String name;
    public int maxFrame;
    public float maxTime;
    public ArrayList<Vector3f> translations;
    public ArrayList<Quaternion> rotations;
    public ArrayList<Vector3f> scales;

    public VirtualTrack(String name, int maxFrame, float maxTime) {
        this.name = name;
        this.maxFrame = maxFrame;
        this.maxTime = maxTime;
    }

    public void setTransform(int frameIndex, Transform transform) {
        if (this.translations == null) {
            this.translations = this.createList(Vector3f.ZERO, frameIndex);
        }
        this.append(this.translations, Vector3f.ZERO, frameIndex - this.translations.size());
        this.translations.add(transform.getTranslation().clone());
        if (this.rotations == null) {
            this.rotations = this.createList(Quaternion.IDENTITY, frameIndex);
        }
        this.append(this.rotations, Quaternion.IDENTITY, frameIndex - this.rotations.size());
        this.rotations.add(transform.getRotation().clone());
        if (this.scales == null) {
            this.scales = this.createList(Vector3f.UNIT_XYZ, frameIndex);
        }
        this.append(this.scales, Vector3f.UNIT_XYZ, frameIndex - this.scales.size());
        this.scales.add(transform.getScale().clone());
    }

    public BoneTrack getAsBoneTrack(int targetBoneIndex) {
        if (this.translations == null && this.rotations == null && this.scales == null) {
            return null;
        }
        return new BoneTrack(targetBoneIndex, this.createTimes(), this.translations.toArray(new Vector3f[this.maxFrame]), this.rotations.toArray(new Quaternion[this.maxFrame]), this.scales.toArray(new Vector3f[this.maxFrame]));
    }

    public SpatialTrack getAsSpatialTrack() {
        if (this.translations == null && this.rotations == null && this.scales == null) {
            return null;
        }
        return new SpatialTrack(this.createTimes(), this.translations.toArray(new Vector3f[this.maxFrame]), this.rotations.toArray(new Quaternion[this.maxFrame]), this.scales.toArray(new Vector3f[this.maxFrame]));
    }

    private float[] createTimes() {
        float[] times = new float[this.maxFrame];
        float dT = this.maxTime / (float)this.maxFrame;
        float t = 0.0f;
        for (int i = 0; i < this.maxFrame; ++i) {
            times[i] = t;
            t += dT;
        }
        return times;
    }

    private <T> ArrayList<T> createList(T element, int count) {
        ArrayList<T> result = new ArrayList<T>(count);
        for (int i = 0; i < count; ++i) {
            result.add(element);
        }
        return result;
    }

    private <T> void append(ArrayList<T> list, T element, int count) {
        for (int i = 0; i < count; ++i) {
            list.add(element);
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder(2048);
        result.append("TRACK: ").append(this.name).append('\n');
        if (this.translations != null && this.translations.size() > 0) {
            result.append("TRANSLATIONS: ").append(this.translations.toString()).append('\n');
        }
        if (this.rotations != null && this.rotations.size() > 0) {
            result.append("ROTATIONS:    ").append(this.rotations.toString()).append('\n');
        }
        if (this.scales != null && this.scales.size() > 0) {
            result.append("SCALES:       ").append(this.scales.toString()).append('\n');
        }
        return result.toString();
    }
}

