/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.animations;

import com.jme3.animation.Bone;
import com.jme3.animation.Skeleton;
import com.jme3.math.Matrix4f;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Spatial;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.animations.BoneEnvelope;
import com.jme3.scene.plugins.blender.constraints.ConstraintHelper;
import com.jme3.scene.plugins.blender.file.BlenderFileException;
import com.jme3.scene.plugins.blender.file.DynamicArray;
import com.jme3.scene.plugins.blender.file.Pointer;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.objects.ObjectHelper;
import java.util.ArrayList;
import java.util.List;

public class BoneContext {
    public static final int SELECTED = 1;
    public static final int CONNECTED_TO_PARENT = 16;
    public static final int DEFORM = 4096;
    public static final int NO_LOCAL_LOCATION = 0x400000;
    public static final int NO_INHERIT_SCALE = 32768;
    public static final int NO_INHERIT_ROTATION = 512;
    public static final Matrix4f BONE_ARMATURE_TRANSFORMATION_MATRIX = new Matrix4f(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f);
    private static final int IKFLAG_LOCK_X = 1;
    private static final int IKFLAG_LOCK_Y = 2;
    private static final int IKFLAG_LOCK_Z = 4;
    private static final int IKFLAG_LIMIT_X = 8;
    private static final int IKFLAG_LIMIT_Y = 16;
    private static final int IKFLAG_LIMIT_Z = 32;
    private BlenderContext blenderContext;
    private Long armatureObjectOMA;
    private Long skeletonOwnerOma;
    private Structure boneStructure;
    private String boneName;
    private int flag;
    private Matrix4f globalBoneMatrix;
    private Matrix4f boneMatrixInModelSpace;
    private BoneContext parent;
    private List<BoneContext> children = new ArrayList<BoneContext>();
    private Bone bone;
    private float length;
    private BoneEnvelope boneEnvelope;
    private float ikStretch;
    private Vector3f limitMin;
    private Vector3f limitMax;
    private Vector3f stiffness;
    private boolean[] limits;
    private boolean[] locks;

    public BoneContext(Long armatureObjectOMA, Structure boneStructure, BlenderContext blenderContext) throws BlenderFileException {
        this(boneStructure, armatureObjectOMA, null, blenderContext);
    }

    private BoneContext(Structure boneStructure, Long armatureObjectOMA, BoneContext parent, BlenderContext blenderContext) throws BlenderFileException {
        Pointer pPose;
        this.parent = parent;
        this.blenderContext = blenderContext;
        this.boneStructure = boneStructure;
        this.armatureObjectOMA = armatureObjectOMA;
        this.boneName = boneStructure.getFieldValue("name").toString();
        this.flag = ((Number)boneStructure.getFieldValue("flag")).intValue();
        this.length = ((Number)boneStructure.getFieldValue("length")).floatValue();
        ObjectHelper objectHelper = (ObjectHelper)blenderContext.getHelper(ObjectHelper.class);
        this.globalBoneMatrix = objectHelper.getMatrix(boneStructure, "arm_mat", blenderContext.getBlenderKey().isFixUpAxis());
        if (blenderContext.getBlenderKey().isFixUpAxis()) {
            this.globalBoneMatrix.multLocal(BONE_ARMATURE_TRANSFORMATION_MATRIX);
        }
        Structure armatureStructure = blenderContext.getFileBlock(armatureObjectOMA).getStructure(blenderContext);
        Spatial armature = (Spatial)objectHelper.toObject(armatureStructure, blenderContext);
        ConstraintHelper constraintHelper = (ConstraintHelper)blenderContext.getHelper(ConstraintHelper.class);
        Matrix4f armatureWorldMatrix = constraintHelper.toMatrix(armature.getWorldTransform(), new Matrix4f());
        this.globalBoneMatrix = armatureWorldMatrix.mult(this.globalBoneMatrix);
        if ((this.flag & 0x1000) == 0) {
            this.boneEnvelope = new BoneEnvelope(boneStructure, armatureWorldMatrix, blenderContext.getBlenderKey().isFixUpAxis());
        }
        if ((pPose = (Pointer)armatureStructure.getFieldValue("pose")) != null && pPose.isNotNull()) {
            List<Structure> poseChannels = ((Structure)pPose.fetchData().get(0).getFieldValue("chanbase")).evaluateListBase();
            for (Structure poseChannel : poseChannels) {
                Long boneOMA = ((Pointer)poseChannel.getFieldValue("bone")).getOldMemoryAddress();
                if (!boneOMA.equals(this.boneStructure.getOldMemoryAddress())) continue;
                this.ikStretch = ((Number)poseChannel.getFieldValue("ikstretch")).floatValue();
                DynamicArray limitMin = (DynamicArray)poseChannel.getFieldValue("limitmin");
                this.limitMin = new Vector3f(((Number)limitMin.get(0)).floatValue(), ((Number)limitMin.get(1)).floatValue(), ((Number)limitMin.get(2)).floatValue());
                DynamicArray limitMax = (DynamicArray)poseChannel.getFieldValue("limitmax");
                this.limitMax = new Vector3f(((Number)limitMax.get(0)).floatValue(), ((Number)limitMax.get(1)).floatValue(), ((Number)limitMax.get(2)).floatValue());
                DynamicArray stiffness = (DynamicArray)poseChannel.getFieldValue("stiffness");
                this.stiffness = new Vector3f(((Number)stiffness.get(0)).floatValue(), ((Number)stiffness.get(1)).floatValue(), ((Number)stiffness.get(2)).floatValue());
                int ikFlag = ((Number)poseChannel.getFieldValue("ikflag")).intValue();
                this.locks = new boolean[]{(ikFlag & 1) != 0, (ikFlag & 2) != 0, (ikFlag & 4) != 0};
                this.limits = new boolean[]{(ikFlag & 8 & 0xFFFFFFFE) != 0, (ikFlag & 0x10 & 0xFFFFFFFD) != 0, (ikFlag & 0x20 & 0xFFFFFFFB) != 0};
                break;
            }
        }
        List<Structure> childbase = ((Structure)boneStructure.getFieldValue("childbase")).evaluateListBase();
        for (Structure child : childbase) {
            this.children.add(new BoneContext(child, armatureObjectOMA, this, blenderContext));
        }
        blenderContext.setBoneContext(boneStructure.getOldMemoryAddress(), this);
    }

    public Bone buildBone(List<Bone> bones, Long skeletonOwnerOma, BlenderContext blenderContext) {
        this.skeletonOwnerOma = skeletonOwnerOma;
        Long boneOMA = this.boneStructure.getOldMemoryAddress();
        this.bone = new Bone(this.boneName);
        bones.add(this.bone);
        blenderContext.addLoadedFeatures(boneOMA, BlenderContext.LoadedDataType.STRUCTURE, this.boneStructure);
        blenderContext.addLoadedFeatures(boneOMA, BlenderContext.LoadedDataType.FEATURE, this.bone);
        ObjectHelper objectHelper = (ObjectHelper)blenderContext.getHelper(ObjectHelper.class);
        Structure skeletonOwnerObjectStructure = (Structure)blenderContext.getLoadedFeature(skeletonOwnerOma, BlenderContext.LoadedDataType.STRUCTURE);
        Matrix4f invertedObjectOwnerGlobalMatrix = objectHelper.getMatrix(skeletonOwnerObjectStructure, "obmat", blenderContext.getBlenderKey().isFixUpAxis()).invertLocal();
        this.boneMatrixInModelSpace = objectHelper.isParent(skeletonOwnerOma, this.armatureObjectOMA) ? this.globalBoneMatrix.mult(invertedObjectOwnerGlobalMatrix) : invertedObjectOwnerGlobalMatrix.mult(this.globalBoneMatrix);
        Matrix4f boneLocalMatrix = this.parent == null ? this.boneMatrixInModelSpace : this.parent.boneMatrixInModelSpace.invert().multLocal(this.boneMatrixInModelSpace);
        Vector3f poseLocation = this.parent == null || !this.is(16) ? boneLocalMatrix.toTranslationVector() : new Vector3f(0.0f, this.parent.length, 0.0f);
        Quaternion rotation = boneLocalMatrix.toRotationQuat().normalizeLocal();
        Vector3f scale = boneLocalMatrix.toScaleVector();
        this.bone.setBindTransforms(poseLocation, rotation, scale);
        for (BoneContext child : this.children) {
            this.bone.addChild(child.buildBone(bones, skeletonOwnerOma, blenderContext));
        }
        return this.bone;
    }

    public Bone getBone() {
        return this.bone;
    }

    public Long getBoneOma() {
        return this.boneStructure.getOldMemoryAddress();
    }

    public float getLength() {
        return this.length;
    }

    public Long getArmatureObjectOMA() {
        return this.armatureObjectOMA;
    }

    public Long getSkeletonOwnerOma() {
        return this.skeletonOwnerOma;
    }

    public Skeleton getSkeleton() {
        return this.blenderContext.getSkeleton(this.armatureObjectOMA);
    }

    public Matrix4f getBoneMatrixInModelSpace() {
        return this.boneMatrixInModelSpace;
    }

    public BoneEnvelope getBoneEnvelope() {
        return this.boneEnvelope;
    }

    public float getIkStretch() {
        return this.ikStretch;
    }

    public boolean isLimitX() {
        return this.limits != null ? this.limits[0] : false;
    }

    public boolean isLimitY() {
        return this.limits != null ? this.limits[1] : false;
    }

    public boolean isLimitZ() {
        return this.limits != null ? this.limits[2] : false;
    }

    public boolean isLockX() {
        return this.locks != null ? this.locks[0] : false;
    }

    public boolean isLockY() {
        return this.locks != null ? this.locks[1] : false;
    }

    public boolean isLockZ() {
        return this.locks != null ? this.locks[2] : false;
    }

    public Vector3f getLimitMin() {
        return this.limitMin;
    }

    public Vector3f getLimitMax() {
        return this.limitMax;
    }

    public Vector3f getStiffness() {
        return this.stiffness;
    }

    public boolean is(int flagMask) {
        return (this.flag & flagMask) != 0;
    }

    public BoneContext getRoot() {
        BoneContext result = this;
        while (result.parent != null) {
            result = result.parent;
        }
        return result;
    }

    public int getDistanceFromRoot() {
        int result = 0;
        BoneContext boneContext = this;
        while (boneContext.parent != null) {
            boneContext = boneContext.parent;
            ++result;
        }
        return result;
    }

    public String toString() {
        return "BoneContext: " + this.boneName;
    }
}

