/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.export.xml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMSerializer {
    private Charset encoding = Charset.forName("utf-8");
    private int indent = 4;
    private String lineSeparator = System.getProperty("line.separator", "\n");

    private void escape(Writer writer, String s) throws IOException {
        if (s == null) {
            return;
        }
        int len = s.length();
        block6: for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    writer.write("&lt;");
                    continue block6;
                }
                case '>': {
                    writer.write("&gt;");
                    continue block6;
                }
                case '&': {
                    writer.write("&amp;");
                    continue block6;
                }
                case '\r': {
                    writer.write("&#xD;");
                    continue block6;
                }
                default: {
                    writer.write(c);
                }
            }
        }
    }

    public void serialize(Document doc, File file) throws IOException {
        this.serialize(doc, new FileOutputStream(file));
    }

    public void serialize(Document doc, OutputStream out) throws IOException {
        OutputStreamWriter writer = new OutputStreamWriter(out, this.encoding);
        this.write(doc, writer, 0);
        ((Writer)writer).flush();
    }

    public void setEncoding(String encoding) {
        this.encoding = Charset.forName(encoding);
    }

    public void setIndent(int indent) {
        this.indent = indent >= 0 ? indent : 0;
    }

    public void setLineSeparator(String lineSeparator) {
        this.lineSeparator = lineSeparator;
    }

    private void write(Node node, Writer writer, int depth) throws IOException {
        switch (node.getNodeType()) {
            case 9: {
                this.writeDocument((Document)node, writer);
                break;
            }
            case 1: {
                this.writeElement((Element)node, writer, depth);
                break;
            }
            case 3: {
                this.escape(writer, node.getNodeValue());
                break;
            }
            case 4: {
                writer.write("<![CDATA[");
                this.escape(writer, node.getNodeValue());
                writer.write("]]>");
                break;
            }
            case 8: {
                for (int i = 0; i < depth; ++i) {
                    writer.append(' ');
                }
                writer.append("<!-- ").append(node.getNodeValue()).append(" -->").append(this.lineSeparator);
                break;
            }
            case 7: {
                String n = node.getNodeName();
                String v = node.getNodeValue();
                for (int i = 0; i < depth; ++i) {
                    writer.append(' ');
                }
                writer.append("<?").append(n).append(' ').append(v).append("?>").append(this.lineSeparator);
                break;
            }
            case 5: {
                writer.append('&').append(node.getNodeName()).append(';');
                break;
            }
            case 10: {
                this.writeDocumentType((DocumentType)node, writer, depth);
            }
        }
    }

    private void writeDocument(Document document, Writer writer) throws IOException {
        String v = document.getXmlVersion();
        writer.append("<?xml ");
        writer.append(" version='").append(v == null ? "1.0" : v).append("'");
        writer.append(" encoding='").append(this.encoding.name()).append("'");
        if (document.getXmlStandalone()) {
            writer.append(" standalone='yes'");
        }
        writer.append("?>").append(this.lineSeparator);
        NodeList nodes = document.getChildNodes();
        int imax = nodes.getLength();
        for (int i = 0; i < imax; ++i) {
            this.write(nodes.item(i), writer, 0);
        }
    }

    private void writeDocumentType(DocumentType docType, Writer writer, int depth) throws IOException {
        String publicId = docType.getPublicId();
        String internalSubset = docType.getInternalSubset();
        for (int i = 0; i < depth; ++i) {
            writer.append(' ');
        }
        writer.append("<!DOCTYPE ").append(docType.getName());
        if (publicId != null) {
            writer.append(" PUBLIC '").append(publicId).append("' ");
        } else {
            writer.write(" SYSTEM ");
        }
        writer.append("'").append(docType.getSystemId()).append("'");
        if (internalSubset != null) {
            writer.append(" [").append(internalSubset).append("]");
        }
        writer.append('>').append(this.lineSeparator);
    }

    private void writeElement(Element element, Writer writer, int depth) throws IOException {
        int i;
        for (int i2 = 0; i2 < depth; ++i2) {
            writer.append(' ');
        }
        writer.append('<').append(element.getTagName());
        NamedNodeMap attrs = element.getAttributes();
        int imax = attrs.getLength();
        for (int i3 = 0; i3 < imax; ++i3) {
            Attr attr = (Attr)attrs.item(i3);
            writer.append(' ').append(attr.getName()).append("='").append(attr.getValue()).append("'");
        }
        NodeList nodes = element.getChildNodes();
        if (nodes.getLength() == 0) {
            writer.append("/>").append(this.lineSeparator);
            return;
        }
        writer.append('>').append(this.lineSeparator);
        int imax2 = nodes.getLength();
        for (i = 0; i < imax2; ++i) {
            Node n = nodes.item(i);
            if (n.getNodeType() == 2) continue;
            this.write(n, writer, depth + this.indent);
        }
        for (i = 0; i < depth; ++i) {
            writer.append(' ');
        }
        writer.append("</").append(element.getTagName()).append('>').append(this.lineSeparator);
    }
}

