/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core2.network.proxy;

import java.net.URI;
import java.util.ArrayDeque;
import java.util.concurrent.ConcurrentHashMap;

public class ProxyLocationCache {
    private static final int DEFAULT_MAX_ELEMENTS = 1000;
    private final ConcurrentHashMap<URI, Object> map;
    private final ArrayDeque<URI> stack = new ArrayDeque();
    private final int maxCacheSize;

    public ProxyLocationCache() {
        this(1000);
    }

    public ProxyLocationCache(int maxCacheSize) {
        this.map = new ConcurrentHashMap();
        this.maxCacheSize = maxCacheSize;
    }

    public Object getProxyStr(URI uri) {
        return this.map.get(uri);
    }

    public synchronized void putProxyStr(URI uri, Object proxyStr) {
        if (this.map.size() >= this.maxCacheSize) {
            this.map.remove(this.stack.poll());
        }
        this.map.put(uri, proxyStr);
        this.stack.add(uri);
    }

    public int cacheSize() {
        return this.map.size();
    }
}

