/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.securityevents;

import java.awt.Color;
import java.awt.Component;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JTable;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableCellRenderer;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.openide.util.NbBundle;
import rs.co.ast.aspen.gui.module.securityevents.SecurityEventDetailsTableModel;

public class SecurityEventDetailsTableRenderer
extends DefaultTableCellRenderer {
    private static DateTimeFormatter isoTimeFormat = ISODateTimeFormat.dateTime();
    private static final String whenTitle = NbBundle.getMessage(SecurityEventDetailsTableRenderer.class, (String)"SecurityEventsDetailsTableModel.when.title");
    private LinkedHashMap<String, List<String>> mapOfRegexpsAndLinks = new LinkedHashMap();

    public SecurityEventDetailsTableRenderer(LinkedHashMap<String, List<String>> mapOfRegexpsAndLinks) {
        this.setOpaque(true);
        this.mapOfRegexpsAndLinks = mapOfRegexpsAndLinks;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object object, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            this.setForeground(table.getSelectionForeground());
            this.setBackground(table.getSelectionBackground());
        } else {
            this.setForeground(table.getForeground());
            if (row % 2 == 0) {
                Color c = new Color(237, 247, 233);
                this.setBackground(c);
            } else {
                this.setBackground(table.getBackground());
            }
        }
        if (hasFocus) {
            this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            if (table.isCellEditable(row, column)) {
                this.setForeground(UIManager.getColor("Table.focusCellForeground"));
                this.setBackground(UIManager.getColor("Table.focusCellBackground"));
            }
            if (column == 0) {
                Component comp = super.getTableCellRendererComponent(table, object, isSelected, hasFocus, row, column);
                comp.setForeground(table.getSelectionForeground());
                comp.setBackground(table.getSelectionBackground());
            }
        } else {
            this.setBorder(new EmptyBorder(1, 1, 1, 1));
        }
        SecurityEventDetailsTableModel.Item item = (SecurityEventDetailsTableModel.Item)object;
        String text = "";
        if (item != null) {
            switch (column) {
                case 0: {
                    if (item.key == null) {
                        text = "<html><b>" + item.category + "</b></html>";
                        break;
                    }
                    text = item.key;
                    break;
                }
                case 1: {
                    if (item.category == null || item.value == null) break;
                    if (item.category.equals(whenTitle)) {
                        try {
                            text = isoTimeFormat.print(Long.valueOf(item.value).longValue());
                        }
                        catch (NumberFormatException ex) {
                            text = item.value;
                        }
                        break;
                    }
                    text = item.value;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid column index");
                }
            }
        }
        for (Map.Entry<String, List<String>> entry : this.mapOfRegexpsAndLinks.entrySet()) {
            Pattern pattern = Pattern.compile(entry.getKey());
            Matcher matcher = pattern.matcher(text);
            if (!matcher.find()) continue;
            text = "<html><i>" + text + "</i></html>";
            break;
        }
        this.setText(text);
        if (!text.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < text.length(); ++i) {
                if (i > 0 && i % 50 == 0) {
                    sb.append("<br>");
                }
                sb.append(text.charAt(i));
            }
            sb.insert(0, "<HTML>").insert(sb.length(), "</HTML>");
            text = sb.toString();
            this.setToolTipText(text);
            ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
        }
        return this;
    }
}

