/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.asset.plugins;

import com.jme3.asset.AssetInfo;
import com.jme3.asset.AssetKey;
import com.jme3.asset.AssetLoadException;
import com.jme3.asset.AssetLocator;
import com.jme3.asset.AssetManager;
import com.jme3.asset.AssetNotFoundException;
import com.jme3.asset.plugins.UrlAssetInfo;
import com.jme3.system.JmeSystem;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;

public class ClasspathLocator
implements AssetLocator {
    private static final Logger logger = Logger.getLogger(ClasspathLocator.class.getName());
    private String root = "";

    @Override
    public void setRootPath(String rootPath) {
        this.root = rootPath;
        if (this.root.equals("/")) {
            this.root = "";
        } else if (this.root.length() > 1) {
            if (this.root.startsWith("/")) {
                this.root = this.root.substring(1);
            }
            if (!this.root.endsWith("/")) {
                this.root = this.root + "/";
            }
        }
    }

    @Override
    public AssetInfo locate(AssetManager manager, AssetKey key) {
        String name = key.getName();
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        name = this.root + name;
        URL url = JmeSystem.isLowPermissions() ? ClasspathLocator.class.getResource("/" + name) : Thread.currentThread().getContextClassLoader().getResource(name);
        if (url == null) {
            ClassLoader classLoader;
            List<ClassLoader> classLoaders = manager.getClassLoaders();
            Iterator<ClassLoader> iterator = classLoaders.iterator();
            while (iterator.hasNext() && (url = (classLoader = iterator.next()).getResource(name)) == null) {
            }
        }
        if (url == null) {
            return null;
        }
        if (url.getProtocol().equals("file")) {
            try {
                String path = new File(url.toURI()).getCanonicalPath();
                if (File.separatorChar == '\\') {
                    path = path.replace('\\', '/');
                }
                if (!path.endsWith(name)) {
                    throw new AssetNotFoundException("Asset name doesn't match requirements.\n\"" + path + "\" doesn't match \"" + name + "\"");
                }
            }
            catch (URISyntaxException ex) {
                throw new AssetLoadException("Error converting URL to URI", ex);
            }
            catch (IOException ex) {
                throw new AssetLoadException("Failed to get canonical path for " + url, ex);
            }
        }
        try {
            return UrlAssetInfo.create(manager, key, url);
        }
        catch (IOException ex) {
            throw new AssetLoadException("Failed to read URL " + url, ex);
        }
    }
}

