/*
 * Decompiled with CFR 0.152.
 */
package org.openide.filesystems;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.net.UnknownServiceException;
import java.security.Permission;
import org.openide.filesystems.ExternalUtil;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.JarFileSystem;
import org.openide.filesystems.NbfsUtil;

class FileURL
extends URLConnection {
    public static final String PROTOCOL = "nbfs";
    InputStream iStream = null;
    OutputStream oStream = null;
    protected FileObject fo;

    protected FileURL(URL u) {
        super(u);
    }

    public static URL encodeFileObject(FileObject fo) {
        return NbfsUtil.getURL(fo);
    }

    public static FileObject decodeURL(URL u) {
        return NbfsUtil.getFileObject(u);
    }

    @Override
    public void connect() throws IOException {
        if (this.fo != null) {
            return;
        }
        this.fo = FileURL.decodeURL(this.url);
        if (this.fo == null) {
            throw new FileNotFoundException("Cannot find: " + this.url);
        }
    }

    @Override
    public InputStream getInputStream() throws IOException, UnknownServiceException {
        this.connect();
        if (this.iStream == null) {
            try {
                this.iStream = this.fo.isFolder() ? new FIS(this.fo) : this.fo.getInputStream();
            }
            catch (FileNotFoundException e) {
                ExternalUtil.exception(e);
                throw e;
            }
        }
        return this.iStream;
    }

    @Override
    public OutputStream getOutputStream() throws IOException, UnknownServiceException {
        this.connect();
        if (this.fo.isFolder()) {
            throw new UnknownServiceException();
        }
        if (this.oStream == null) {
            FileLock flock = this.fo.lock();
            this.oStream = new LockOS(this.fo.getOutputStream(flock), flock);
        }
        return this.oStream;
    }

    @Override
    public int getContentLength() {
        try {
            this.connect();
            return (int)this.fo.getSize();
        }
        catch (IOException ex) {
            return 0;
        }
    }

    @Override
    public String getHeaderField(String name) {
        if (name.equalsIgnoreCase("content-type")) {
            try {
                this.connect();
                if (this.fo.isFolder()) {
                    return "text/html";
                }
                return this.fo.getMIMEType();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return super.getHeaderField(name);
    }

    @Override
    public long getHeaderFieldDate(String name, long Default) {
        if (name.equalsIgnoreCase("last-modified")) {
            try {
                this.connect();
                return this.fo.lastModified().getTime();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        return super.getHeaderFieldDate(name, Default);
    }

    @Override
    public Permission getPermission() throws IOException {
        if (this.fo != null) {
            File f = FileUtil.toFile(this.fo);
            if (f != null) {
                return new FilePermission(f.getAbsolutePath(), "read");
            }
            try {
                FileSystem fs = this.fo.getFileSystem();
                if (fs instanceof JarFileSystem) {
                    return new FilePermission(((JarFileSystem)fs).getJarFile().getAbsolutePath(), "read");
                }
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                // empty catch block
            }
        }
        return new FilePermission("<<ALL FILES>>", "read");
    }

    private static final class FIS
    extends InputStream {
        private StringReader reader;

        public FIS(FileObject folder) throws IOException {
            this.reader = new StringReader(this.createDocument(folder));
        }

        private String createDocument(FileObject folder) throws IOException {
            StringBuffer buff = new StringBuffer(150);
            StringBuffer lit = new StringBuffer(15);
            FileObject[] fobia = folder.getChildren();
            buff.append("<HTML>\n");
            buff.append("<BODY>\n");
            FileObject parent = folder.getParent();
            if (parent != null) {
                buff.append("<P>");
                buff.append("<A HREF=").append("..").append(">").append("..").append("</A>").append("\n");
                buff.append("</P>");
            }
            for (int i = 0; i < fobia.length; ++i) {
                lit.setLength(0);
                lit.append(fobia[i].getNameExt());
                String name = lit.toString();
                if (fobia[i].isFolder()) {
                    lit.append('/');
                }
                buff.append("<P>");
                buff.append("<A HREF=").append((Object)lit).append(">").append(name).append("</A>").append("\n");
                buff.append("</P>");
            }
            buff.append("</BODY>\n");
            buff.append("</HTML>\n");
            return buff.toString();
        }

        @Override
        public int read() throws IOException {
            return this.reader.read();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            char[] ch = new char[len];
            int r = this.reader.read(ch, 0, len);
            for (int i = 0; i < r; ++i) {
                b[off + i] = (byte)ch[i];
            }
            return r;
        }

        @Override
        public long skip(long skip) throws IOException {
            return this.reader.skip(skip);
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }

        @Override
        public void reset() throws IOException {
            this.reader.reset();
        }

        @Override
        public boolean markSupported() {
            return false;
        }
    }

    public static class Handler
    extends URLStreamHandler {
        @Override
        public URLConnection openConnection(URL u) throws IOException {
            return new FileURL(u);
        }

        @Override
        protected synchronized InetAddress getHostAddress(URL u) {
            return null;
        }
    }

    private static class LockOS
    extends BufferedOutputStream {
        private FileLock flock;

        public LockOS(OutputStream os, FileLock lock) throws IOException {
            super(os);
            this.flock = lock;
        }

        @Override
        public void close() throws IOException {
            this.flock.releaseLock();
            super.close();
        }
    }
}

