/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.chart.event;

import java.awt.Component;
import java.awt.event.MouseEvent;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.Range;

public class ASTMouseEvent
extends MouseEvent {
    private double lowerBound;
    private double upperBound;
    private double coefficient;
    private MouseEventType mouseEventType;

    public ASTMouseEvent(Component source, int id, long when, int modifiers, int x, int y, int clickCount, boolean popupTrigger, int button, Plot plot, MouseEventType mouseEventType) {
        super(source, id, when, modifiers, x, y, clickCount, popupTrigger, button);
        Range dataRange = ((XYPlot)plot).getDomainAxis().getRange();
        this.lowerBound = dataRange.getLowerBound();
        this.upperBound = dataRange.getUpperBound();
        this.coefficient = (this.upperBound - this.lowerBound) / 30000.0 / 10.0;
        this.mouseEventType = mouseEventType;
    }

    public ASTMouseEvent(MouseEvent event, Plot plot, MouseEventType mouseEventType) {
        this((Component)event.getSource(), event.getID(), event.getWhen(), event.getModifiers(), event.getX(), event.getY(), event.getClickCount(), event.isPopupTrigger(), event.getButton(), plot, mouseEventType);
    }

    public double getLowerBound() {
        return this.lowerBound;
    }

    public double getUpperBound() {
        return this.upperBound;
    }

    public double getCoefficient() {
        return this.coefficient;
    }

    public MouseEventType getMouseEventType() {
        return this.mouseEventType;
    }

    public static enum MouseEventType {
        MOUSE_PRESSED,
        MOUSE_RELEASED;

    }
}

