/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.CommonReturnValue;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDatasetParameter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRewindableDataSource;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRScriptlet;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRSubreport;
import net.sf.jasperreports.engine.JRSubreportParameter;
import net.sf.jasperreports.engine.JRSubreportReturnValue;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.ReportContext;
import net.sf.jasperreports.engine.VariableReturnValue;
import net.sf.jasperreports.engine.base.JRVirtualPrintPage;
import net.sf.jasperreports.engine.design.JRValidationException;
import net.sf.jasperreports.engine.design.JRValidationFault;
import net.sf.jasperreports.engine.design.JRVerifier;
import net.sf.jasperreports.engine.fill.AbstractVariableReturnValueSourceContext;
import net.sf.jasperreports.engine.fill.BandReportFillerParent;
import net.sf.jasperreports.engine.fill.BaseReportFiller;
import net.sf.jasperreports.engine.fill.DatasetExpressionEvaluator;
import net.sf.jasperreports.engine.fill.FillDatasetPosition;
import net.sf.jasperreports.engine.fill.FillReturnValues;
import net.sf.jasperreports.engine.fill.FillerSubreportParent;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JREvaluator;
import net.sf.jasperreports.engine.fill.JRFillBand;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillCloneable;
import net.sf.jasperreports.engine.fill.JRFillDataset;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.JRFillExpressionEvaluator;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRFillVariable;
import net.sf.jasperreports.engine.fill.JRHorizontalFiller;
import net.sf.jasperreports.engine.fill.JRSubreportRunResult;
import net.sf.jasperreports.engine.fill.JRSubreportRunner;
import net.sf.jasperreports.engine.fill.JRSubreportRunnerFactory;
import net.sf.jasperreports.engine.fill.JRTemplateElement;
import net.sf.jasperreports.engine.fill.JRTemplatePrintRectangle;
import net.sf.jasperreports.engine.fill.JRTemplateRectangle;
import net.sf.jasperreports.engine.fill.JRVerticalFiller;
import net.sf.jasperreports.engine.fill.JasperReportSource;
import net.sf.jasperreports.engine.fill.SimpleJasperReportSource;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.OverflowType;
import net.sf.jasperreports.engine.type.SectionTypeEnum;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRSingletonCache;
import net.sf.jasperreports.repo.RepositoryResourceContext;
import net.sf.jasperreports.repo.RepositoryUtil;
import net.sf.jasperreports.repo.ResourceInfo;
import net.sf.jasperreports.repo.ResourcePathKey;
import net.sf.jasperreports.repo.SimpleRepositoryResourceContext;
import org.apache.commons.javaflow.api.continuable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRFillSubreport
extends JRFillElement
implements JRSubreport {
    private static final Log log = LogFactory.getLog(JRFillSubreport.class);
    public static final String EXCEPTION_MESSAGE_KEY_PROPERTY_NOT_SET = "fill.subreport.property.not.set";
    public static final String EXCEPTION_MESSAGE_KEY_NO_REWINDABLE_DATA_SOURCE = "fill.subreport.no.rewindable.data.source";
    public static final String EXCEPTION_MESSAGE_KEY_UNSUPPORTED_SECTION_TYPE = "fill.subreport.unsupported.section.type";
    public static final String EXCEPTION_MESSAGE_KEY_UNKNOWN_SOURCE_CLASS = "fill.subreport.unknown.source.class";
    public static final String PROPERTY_SUBREPORT_GENERATE_RECTANGLE = "net.sf.jasperreports.subreport.generate.rectangle";
    public static final String SUBREPORT_GENERATE_RECTANGLE_ALWAYS = "always";
    private static final JRSingletonCache<JRSubreportRunnerFactory> runnerFactoryCache = new JRSingletonCache<JRSubreportRunnerFactory>(JRSubreportRunnerFactory.class);
    private Map<String, Object> parameterValues;
    private JRSubreportParameter[] parameters;
    private FillDatasetPosition datasetPosition;
    private boolean cacheIncluded;
    private Connection connection;
    private JRDataSource dataSource;
    private JasperReportSource jasperReportSource;
    private Object source;
    private Map<JasperReport, JREvaluator> loadedEvaluators;
    private FillReturnValues returnValues;
    private FillReturnValues.SourceContext returnValuesContext = new AbstractVariableReturnValueSourceContext(){

        @Override
        public Object getValue(CommonReturnValue returnValue) {
            return JRFillSubreport.this.subreportFiller.getVariableValue(((VariableReturnValue)returnValue).getFromVariable());
        }

        @Override
        public JRFillVariable getToVariable(String name) {
            return JRFillSubreport.this.expressionEvaluator.getFillDataset().getVariable(name);
        }

        @Override
        public JRVariable getFromVariable(String name) {
            return JRFillSubreport.this.subreportFiller.getVariable(name);
        }
    };
    protected JRBaseFiller subreportFiller;
    protected FillerSubreportParent subFillerParent;
    protected JRPrintPage printPage;
    private int printPageContentsWidth;
    private JRSubreportRunner runner;
    private Set<JasperReport> checkedReports;
    private final String defaultGenerateRectangle;
    private final boolean dynamicGenerateRectangle;

    protected JRFillSubreport(JRBaseFiller filler, JRSubreport subreport, JRFillObjectFactory factory) {
        super(filler, subreport, factory);
        this.parameters = subreport.getParameters();
        this.returnValues = new FillReturnValues(subreport.getReturnValues(), factory, (BaseReportFiller)filler);
        this.loadedEvaluators = new HashMap<JasperReport, JREvaluator>();
        this.checkedReports = new HashSet<JasperReport>();
        this.defaultGenerateRectangle = filler.getPropertiesUtil().getProperty(PROPERTY_SUBREPORT_GENERATE_RECTANGLE, subreport, filler.getJasperReport());
        this.dynamicGenerateRectangle = this.hasDynamicProperty(PROPERTY_SUBREPORT_GENERATE_RECTANGLE);
    }

    protected JRFillSubreport(JRFillSubreport subreport, JRFillCloneFactory factory) {
        super(subreport, factory);
        this.parameters = subreport.parameters;
        this.returnValues = new FillReturnValues(subreport.returnValues, factory);
        this.returnValuesContext = subreport.returnValuesContext;
        this.loadedEvaluators = new HashMap<JasperReport, JREvaluator>();
        this.checkedReports = subreport.checkedReports;
        this.defaultGenerateRectangle = subreport.defaultGenerateRectangle;
        this.dynamicGenerateRectangle = subreport.dynamicGenerateRectangle;
    }

    @Override
    protected void setBand(JRFillBand band) {
        super.setBand(band);
        this.returnValues.setBand(band);
    }

    @Override
    public ModeEnum getModeValue() {
        return this.getStyleResolver().getMode(this, ModeEnum.TRANSPARENT);
    }

    public boolean usingCache() {
        Boolean isUsingCache = this.getUsingCache();
        if (isUsingCache == null) {
            return this.source instanceof String;
        }
        return isUsingCache;
    }

    @Override
    public Boolean isRunToBottom() {
        return ((JRSubreport)this.parent).isRunToBottom();
    }

    @Override
    public void setRunToBottom(Boolean runToBottom) {
        throw new UnsupportedOperationException();
    }

    @Override
    public OverflowType getOverflowType() {
        return ((JRSubreport)this.parent).getOverflowType();
    }

    @Override
    public void setOverflowType(OverflowType overflowType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public JRExpression getParametersMapExpression() {
        return ((JRSubreport)this.parent).getParametersMapExpression();
    }

    @Override
    public JRSubreportParameter[] getParameters() {
        return this.parameters;
    }

    @Override
    public JRExpression getConnectionExpression() {
        return ((JRSubreport)this.parent).getConnectionExpression();
    }

    @Override
    public JRExpression getDataSourceExpression() {
        return ((JRSubreport)this.parent).getDataSourceExpression();
    }

    @Override
    public JRExpression getExpression() {
        return ((JRSubreport)this.parent).getExpression();
    }

    protected JRTemplateRectangle getJRTemplateRectangle() {
        return (JRTemplateRectangle)this.getElementTemplate();
    }

    @Override
    protected JRTemplateElement createElementTemplate() {
        return new JRTemplateRectangle(this.getElementOrigin(), this.filler.getJasperPrint().getDefaultStyleProvider(), this);
    }

    protected Collection<JRPrintElement> getPrintElements() {
        List<JRPrintElement> printElements = null;
        if (this.printPage != null) {
            printElements = this.printPage.getElements();
        }
        return printElements;
    }

    protected int getPrintContentsWidth() {
        return this.printPageContentsWidth;
    }

    public void subreportPageFilled() {
        if (this.printPage != null) {
            if (this.subreportFiller.delayedActions.hasMasterDelayedActions(this.printPage)) {
                this.evictReportEvaluator();
            }
            this.subreportFiller.subreportPageFilled(this.printPage);
        }
    }

    @Override
    protected void evaluate(byte evaluation) throws JRException {
        this.reset();
        this.evaluatePrintWhenExpression(evaluation);
        if (this.isPrintWhenExpressionNull() || this.isPrintWhenTrue()) {
            this.evaluateSubreport(evaluation);
        }
    }

    protected JasperReportSource evaluateReportSource(byte evaluation) throws JRException {
        JasperReportSource report = null;
        JRExpression expression = this.getExpression();
        this.source = this.evaluateExpression(expression, evaluation);
        if (this.source != null) {
            Boolean isUsingCache = this.getUsingCache();
            if (isUsingCache == null) {
                isUsingCache = this.source instanceof String;
            }
            Object cacheKey = this.source;
            if (this.source instanceof String) {
                cacheKey = ResourcePathKey.inContext(this.filler.getRepositoryContext(), (String)this.source);
            }
            if (isUsingCache.booleanValue() && this.filler.fillContext.hasLoadedSubreport(cacheKey)) {
                report = this.filler.fillContext.getLoadedSubreport(cacheKey);
            } else {
                if (this.source instanceof String) {
                    RepositoryUtil repository = RepositoryUtil.getInstance(this.filler.getRepositoryContext());
                    ResourceInfo resourceInfo = repository.getResourceInfo((String)this.source);
                    if (resourceInfo == null) {
                        report = this.loadReportSource(this.source, null);
                    } else {
                        String reportLocation = resourceInfo.getRepositoryResourceLocation();
                        String contextLocation = resourceInfo.getRepositoryContextLocation();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("subreport source " + this.source + " resolved to " + reportLocation + ", context " + contextLocation));
                        }
                        ResourcePathKey absolutePathKey = ResourcePathKey.absolute(reportLocation);
                        if (isUsingCache.booleanValue() && this.filler.fillContext.hasLoadedSubreport(absolutePathKey)) {
                            report = this.filler.fillContext.getLoadedSubreport(absolutePathKey);
                        } else {
                            report = this.loadReportSource(reportLocation, contextLocation);
                            if (isUsingCache.booleanValue()) {
                                this.filler.fillContext.registerLoadedSubreport(absolutePathKey, report);
                            }
                        }
                    }
                } else {
                    report = this.loadReportSource(this.source, null);
                }
                if (isUsingCache.booleanValue()) {
                    this.filler.fillContext.registerLoadedSubreport(cacheKey, report);
                }
            }
        }
        if (report == null) {
            return null;
        }
        return report;
    }

    protected JasperReportSource loadReportSource(Object reportSource, String contextLocation) throws JRException {
        JasperReport jasperReport = JRFillSubreport.loadReport(reportSource, this.filler);
        SimpleJasperReportSource report = null;
        if (jasperReport != null) {
            RepositoryResourceContext currentContext = this.filler.getRepositoryContext().getResourceContext();
            SimpleRepositoryResourceContext reportContext = SimpleRepositoryResourceContext.of(contextLocation, currentContext == null ? null : currentContext.getDerivedContextFallback());
            report = SimpleJasperReportSource.from(jasperReport, reportSource instanceof String ? (String)reportSource : null, reportContext);
        }
        return report;
    }

    public static JasperReport loadReport(Object source, BaseReportFiller filler) throws JRException {
        JasperReport report;
        if (source instanceof JasperReport) {
            report = (JasperReport)source;
        } else if (source instanceof InputStream) {
            report = (JasperReport)JRLoader.loadObject((InputStream)source);
        } else if (source instanceof URL) {
            report = (JasperReport)JRLoader.loadObject((URL)source);
        } else if (source instanceof File) {
            report = (JasperReport)JRLoader.loadObject((File)source);
        } else if (source instanceof String) {
            report = RepositoryUtil.getInstance(filler.getRepositoryContext()).getReport(filler.getFillContext().getReportContext(), (String)source);
        } else {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_UNSUPPORTED_SECTION_TYPE, new Object[]{source.getClass().getName()});
        }
        return report;
    }

    protected void evaluateSubreport(byte evaluation) throws JRException {
        this.evaluateProperties(evaluation);
        this.evaluateStyle(evaluation);
        this.jasperReportSource = this.evaluateReportSource(evaluation);
        if (this.jasperReportSource != null) {
            JRFillDataset parentDataset = this.expressionEvaluator.getFillDataset();
            this.datasetPosition = new FillDatasetPosition(parentDataset.fillPosition);
            this.datasetPosition.addAttribute("subreportUUID", this.getUUID());
            parentDataset.setCacheRecordIndex(this.datasetPosition, evaluation);
            this.connection = (Connection)this.evaluateExpression(this.getConnectionExpression(), evaluation);
            String cacheIncludedProp = JRPropertiesUtil.getOwnProperty(this, "net.sf.jasperreports.data.cache.included");
            this.cacheIncluded = JRPropertiesUtil.asBoolean(cacheIncludedProp, true);
            this.dataSource = this.filler.fillContext.hasDataSnapshot() && this.cacheIncluded ? null : (JRDataSource)this.evaluateExpression(this.getDataSourceExpression(), evaluation);
            this.parameterValues = this.evaluateParameterValues(evaluation);
            if (this.subreportFiller != null) {
                this.filler.unregisterSubfiller(this.subreportFiller);
            }
            DatasetExpressionEvaluator evaluator = this.loadReportEvaluator();
            this.initSubreportFiller(evaluator);
            this.validateReport();
            this.returnValues.saveReturnVariables();
        }
    }

    protected JasperReport getReport() {
        return this.jasperReportSource == null ? null : this.jasperReportSource.getReport();
    }

    protected Map<String, Object> evaluateParameterValues(byte evaluation) throws JRException {
        JasperReport jasperReport = this.getReport();
        return JRFillSubreport.getParameterValues(this.filler, this.expressionEvaluator, this.getParametersMapExpression(), this.getParameters(), evaluation, false, jasperReport.getResourceBundle() != null, jasperReport.getFormatFactoryClass() != null);
    }

    protected DatasetExpressionEvaluator loadReportEvaluator() throws JRException {
        JasperReport jasperReport = this.getReport();
        DatasetExpressionEvaluator evaluator = null;
        boolean usingCache = this.usingCache();
        if (usingCache) {
            evaluator = this.loadedEvaluators.get(jasperReport);
        }
        if (evaluator == null) {
            evaluator = this.createEvaluator();
            if (usingCache) {
                this.loadedEvaluators.put(jasperReport, (JREvaluator)evaluator);
            }
        }
        return evaluator;
    }

    protected void evictReportEvaluator() {
        this.loadedEvaluators.remove(this.getReport());
    }

    protected DatasetExpressionEvaluator createEvaluator() throws JRException {
        return JasperCompileManager.getInstance(this.filler.getJasperReportsContext()).getEvaluator(this.getReport());
    }

    protected boolean isReorderBandElements() {
        return false;
    }

    protected void initSubreportFiller(DatasetExpressionEvaluator evaluator) throws JRException {
        SectionTypeEnum subreportSectionType;
        JasperReport jasperReport = this.getReport();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Fill " + this.filler.fillerId + ": creating subreport filler for " + jasperReport.getName()));
        }
        if ((subreportSectionType = jasperReport.getSectionType()) != null && subreportSectionType != SectionTypeEnum.BAND) {
            throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_UNSUPPORTED_SECTION_TYPE, new Object[]{subreportSectionType});
        }
        this.subFillerParent = this.createFillerParent(evaluator);
        switch (jasperReport.getPrintOrderValue()) {
            case HORIZONTAL: {
                this.subreportFiller = new JRHorizontalFiller(this.filler.getJasperReportsContext(), this.jasperReportSource, (BandReportFillerParent)this.subFillerParent);
                break;
            }
            default: {
                this.subreportFiller = new JRVerticalFiller(this.filler.getJasperReportsContext(), this.jasperReportSource, (BandReportFillerParent)this.subFillerParent);
            }
        }
        this.subreportFiller.setReorderBandElements(this.isReorderBandElements());
        this.runner = this.getRunnerFactory().createSubreportRunner(this, this.subreportFiller);
        this.subFillerParent.setSubreportRunner(this.runner);
        this.subreportFiller.mainDataset.setFillPosition(this.datasetPosition);
        this.subreportFiller.mainDataset.setCacheSkipped(!this.cacheIncluded);
    }

    protected FillerSubreportParent createFillerParent(DatasetExpressionEvaluator evaluator) throws JRException {
        return new FillerSubreportParent(this, evaluator);
    }

    public static Map<String, Object> getParameterValues(BaseReportFiller filler, JRExpression parametersMapExpression, JRDatasetParameter[] subreportParameters, byte evaluation, boolean ignoreNullExpressions, boolean removeResourceBundle, boolean removeFormatFactory) throws JRException {
        return JRFillSubreport.getParameterValues(filler, filler.getExpressionEvaluator(), parametersMapExpression, subreportParameters, evaluation, ignoreNullExpressions, removeResourceBundle, removeFormatFactory);
    }

    public static Map<String, Object> getParameterValues(BaseReportFiller filler, JRFillExpressionEvaluator expressionEvaluator, JRExpression parametersMapExpression, JRDatasetParameter[] subreportParameters, byte evaluation, boolean ignoreNullExpressions, boolean removeResourceBundle, boolean removeFormatFactory) throws JRException {
        ReportContext context;
        int i;
        HashMap<String, Object> parameterValues = null;
        if (parametersMapExpression != null) {
            parameterValues = (HashMap<String, Object>)expressionEvaluator.evaluate(parametersMapExpression, evaluation);
        }
        if (parameterValues != null) {
            if (parameterValues == filler.getParameterValuesMap()) {
                parameterValues = new HashMap(parameterValues);
            }
            if (removeResourceBundle) {
                parameterValues.remove("REPORT_RESOURCE_BUNDLE");
            }
            if (removeFormatFactory) {
                parameterValues.remove("REPORT_FORMAT_FACTORY");
            }
            parameterValues.remove("JASPER_REPORTS_CONTEXT");
            parameterValues.remove("JASPER_REPORT");
            parameterValues.remove("REPORT_CONNECTION");
            parameterValues.remove("REPORT_MAX_COUNT");
            parameterValues.remove("REPORT_DATA_SOURCE");
            parameterValues.remove("REPORT_SCRIPTLET");
            JRScriptlet[] scriptlets = filler.getJasperReport().getScriptlets();
            if (scriptlets != null) {
                for (i = 0; i < scriptlets.length; ++i) {
                    parameterValues.remove(scriptlets[i].getName() + "_SCRIPTLET");
                }
            }
            parameterValues.remove("REPORT_VIRTUALIZER");
            parameterValues.remove("IS_IGNORE_PAGINATION");
            parameterValues.remove("SORT_FIELDS");
            parameterValues.remove("FILTER");
            parameterValues.remove("REPORT_PARAMETERS_MAP");
        }
        if (parameterValues == null) {
            parameterValues = new HashMap<String, Object>();
        }
        if (subreportParameters != null && subreportParameters.length > 0) {
            Object parameterValue = null;
            for (i = 0; i < subreportParameters.length; ++i) {
                JRExpression expression = subreportParameters[i].getExpression();
                if (expression == null && ignoreNullExpressions) continue;
                parameterValue = expressionEvaluator.evaluate(expression, evaluation);
                if (parameterValue == null) {
                    parameterValues.remove(subreportParameters[i].getName());
                    continue;
                }
                parameterValues.put(subreportParameters[i].getName(), parameterValue);
            }
        }
        if (!parameterValues.containsKey("REPORT_LOCALE")) {
            parameterValues.put("REPORT_LOCALE", filler.getLocale());
        }
        if (!parameterValues.containsKey("REPORT_TIME_ZONE")) {
            parameterValues.put("REPORT_TIME_ZONE", filler.getTimeZone());
        }
        if (!parameterValues.containsKey("REPORT_FORMAT_FACTORY") && !removeFormatFactory) {
            parameterValues.put("REPORT_FORMAT_FACTORY", filler.getFormatFactory());
        }
        if (!parameterValues.containsKey("REPORT_CONTEXT") && (context = (ReportContext)filler.getMainDataset().getParameterValue("REPORT_CONTEXT", true)) != null) {
            parameterValues.put("REPORT_CONTEXT", context);
        }
        return parameterValues;
    }

    @continuable
    protected void fillSubreport() throws JRException {
        if (this.getConnectionExpression() != null) {
            this.subreportFiller.fill(this.parameterValues, this.connection);
        } else if (this.getDataSourceExpression() != null) {
            this.subreportFiller.fill(this.parameterValues, this.dataSource);
        } else {
            this.subreportFiller.fill(this.parameterValues);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean prepare(int availableHeight, boolean isOverflow) throws JRException {
        OverflowType overflowType;
        boolean reprinted;
        boolean willOverflow = false;
        super.prepare(availableHeight, isOverflow);
        if (this.subreportFiller == null) {
            this.setToPrint(false);
        }
        if (!this.isToPrint()) {
            return willOverflow;
        }
        int elementHeight = this.getHeight();
        if (availableHeight < this.getRelativeY() + elementHeight) {
            this.setToPrint(false);
            return true;
        }
        boolean filling = this.runner.isFilling();
        boolean toPrint = !isOverflow || this.isPrintWhenDetailOverflows() || !this.isAlreadyPrinted();
        boolean bl = reprinted = isOverflow && this.isPrintWhenDetailOverflows();
        if (elementHeight == 0 && availableHeight == this.getRelativeY() && !filling && toPrint && this.fillContainerContext != null && this.fillContainerContext.isCurrentOverflow() && this.fillContainerContext.isCurrentOverflowAllowed()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"zero height subreport at the bottom, not starting");
            }
            this.setToPrint(false);
            return true;
        }
        if (!filling && toPrint && reprinted) {
            this.rewind();
        }
        if (this.printPage instanceof JRVirtualPrintPage) {
            ((JRVirtualPrintPage)this.printPage).dispose();
        }
        int pageHeight = (overflowType = this.getOverflowType()) == OverflowType.NO_STRETCH && !this.filler.isIgnorePagination() ? elementHeight : availableHeight - this.getRelativeY();
        this.subreportFiller.setPageHeight(pageHeight);
        JRBaseFiller jRBaseFiller = this.subreportFiller;
        synchronized (jRBaseFiller) {
            JRSubreportRunResult result;
            if (filling) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Fill " + this.filler.fillerId + ": resuming " + this.subreportFiller.fillerId));
                }
                result = this.runner.resume();
            } else if (toPrint) {
                this.setReprinted(reprinted);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Fill " + this.filler.fillerId + ": starting " + this.subreportFiller.fillerId));
                }
                result = this.runner.start();
            } else {
                this.printPage = null;
                this.printPageContentsWidth = 0;
                this.setPrepareHeight(this.getHeight());
                this.setToPrint(false);
                return willOverflow;
            }
            if (result.getException() != null) {
                Throwable error = result.getException();
                if (log.isErrorEnabled()) {
                    log.error((Object)("Fill " + this.filler.fillerId + ": exception"), error);
                }
                if (error instanceof RuntimeException) {
                    throw (RuntimeException)error;
                }
                throw new JRRuntimeException(error);
            }
            if (result.hasFinished()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Fill " + this.filler.fillerId + ": subreport " + this.subreportFiller.fillerId + " finished"));
                }
                this.returnValues.copyValues(this.returnValuesContext);
            } else if (log.isDebugEnabled()) {
                log.debug((Object)("Fill " + this.filler.fillerId + ": subreport " + this.subreportFiller.fillerId + " to continue"));
            }
            this.printPage = this.subreportFiller.getCurrentPage();
            this.printPageContentsWidth = this.subreportFiller.getCurrentPageContentsWidth();
            this.setPrepareHeight(result.hasFinished() ? this.subFillerParent.getCurrentPageStretchHeight() : pageHeight);
            boolean bl2 = willOverflow = !result.hasFinished();
            if (!willOverflow) {
                this.runner.reset();
            }
        }
        Collection<JRPrintElement> printElements = this.getPrintElements();
        if ((printElements == null || printElements.size() == 0) && this.isRemoveLineWhenBlank()) {
            this.setToPrint(false);
        }
        return willOverflow;
    }

    @Override
    public void rewind() throws JRException {
        if (this.subreportFiller == null) {
            return;
        }
        this.cancelSubreportFill();
        this.initSubreportFiller(null);
        if (this.getConnectionExpression() == null && this.dataSource != null) {
            if (this.dataSource instanceof JRRewindableDataSource) {
                ((JRRewindableDataSource)this.dataSource).moveFirst();
            } else {
                throw new JRException(EXCEPTION_MESSAGE_KEY_NO_REWINDABLE_DATA_SOURCE, (Object[])null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cancelSubreportFill() throws JRException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Fill " + this.filler.fillerId + ": cancelling " + this.subreportFiller.fillerId));
        }
        this.subreportFiller.setInterrupted(true);
        JRBaseFiller jRBaseFiller = this.subreportFiller;
        synchronized (jRBaseFiller) {
            this.runner.cancel();
            this.runner.reset();
        }
        this.filler.unregisterSubfiller(this.subreportFiller);
    }

    @Override
    protected JRPrintElement fill() {
        JRTemplatePrintRectangle printRectangle = new JRTemplatePrintRectangle(this.getJRTemplateRectangle(), this.printElementOriginator);
        if (printRectangle.getModeValue() == ModeEnum.TRANSPARENT && !printRectangle.hasProperties()) {
            String generateRectangle = this.generateRectangleOption();
            if (log.isDebugEnabled()) {
                log.debug((Object)("empty rectangle, generate option: " + generateRectangle));
            }
            if (generateRectangle == null || !generateRectangle.equals(SUBREPORT_GENERATE_RECTANGLE_ALWAYS)) {
                return null;
            }
        }
        printRectangle.setUUID(this.getUUID());
        printRectangle.setX(this.getX());
        printRectangle.setY(this.getRelativeY());
        printRectangle.setWidth(this.getWidth());
        printRectangle.setHeight(this.getStretchHeight());
        return printRectangle;
    }

    protected String generateRectangleOption() {
        String generateRectangleProp;
        String generateRectangle = this.defaultGenerateRectangle;
        if (this.dynamicGenerateRectangle && (generateRectangleProp = this.getDynamicProperties().getProperty(PROPERTY_SUBREPORT_GENERATE_RECTANGLE)) != null) {
            generateRectangle = generateRectangleProp;
        }
        return generateRectangle;
    }

    @Override
    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    @Override
    public void visit(JRVisitor visitor) {
        visitor.visitSubreport(this);
    }

    @Override
    public JRSubreportReturnValue[] getReturnValues() {
        return ((JRSubreport)this.parent).getReturnValues();
    }

    protected void validateReport() throws JRException {
        JasperReport jasperReport = this.getReport();
        if (!this.checkedReports.contains(jasperReport)) {
            this.verifyBandHeights();
            this.returnValues.checkReturnValues(this.returnValuesContext);
            if (this.usingCache()) {
                this.checkedReports.add(jasperReport);
            }
        }
    }

    protected void verifyBandHeights() throws JRException {
        if (!this.filler.isIgnorePagination()) {
            int pageHeight;
            JasperReport jasperReport = this.getReport();
            int topMargin = jasperReport.getTopMargin();
            int bottomMargin = jasperReport.getBottomMargin();
            JRBaseFiller parentFiller = this.filler;
            do {
                pageHeight = parentFiller.jasperReport.getPageHeight();
                topMargin += parentFiller.jasperReport.getTopMargin();
                bottomMargin += parentFiller.jasperReport.getBottomMargin();
            } while ((parentFiller = parentFiller.parent != null && parentFiller.parent.getFiller() instanceof JRBaseFiller ? (JRBaseFiller)parentFiller.parent.getFiller() : null) != null);
            ArrayList<JRValidationFault> brokenRules = new ArrayList<JRValidationFault>();
            JRVerifier.verifyBandHeights(brokenRules, jasperReport, pageHeight, topMargin, bottomMargin);
            if (!brokenRules.isEmpty()) {
                throw new JRValidationException("Band height validation for subreport \"" + jasperReport.getName() + "\" failed in the current page context (height = " + pageHeight + ", top margin = " + topMargin + ", bottom margin = " + bottomMargin + ") : ", brokenRules);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Band height validation for subreport \"" + jasperReport.getName() + "\" succeeded in the current page context (height = " + pageHeight + ", top margin = " + topMargin + ", bottom margin = " + bottomMargin + ")"));
            }
        }
    }

    @Override
    protected void resolveElement(JRPrintElement element, byte evaluation) {
    }

    @Override
    public Boolean getUsingCache() {
        return ((JRSubreport)this.parent).getUsingCache();
    }

    @Override
    public void setUsingCache(Boolean isUsingCache) {
    }

    @Override
    public JRFillCloneable createClone(JRFillCloneFactory factory) {
        return new JRFillSubreport(this, factory);
    }

    protected JRSubreportRunnerFactory getRunnerFactory() throws JRException {
        String factoryClassName = this.filler.getPropertiesUtil().getProperty("net.sf.jasperreports.subreport.runner.factory");
        if (factoryClassName == null) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_PROPERTY_NOT_SET, new Object[]{"net.sf.jasperreports.subreport.runner.factory"});
        }
        return runnerFactoryCache.getCachedInstance(factoryClassName);
    }

    protected int getContentsStretchHeight() {
        return this.subFillerParent.getCurrentPageStretchHeight();
    }

    protected String getReportLocation() {
        return this.jasperReportSource == null ? null : this.jasperReportSource.getReportLocation();
    }

    protected void registerReportStyles(List<JRStyle> styles) {
    }

    protected String getReportName() {
        return this.getReport().getName();
    }

    protected boolean isSplitTypePreventInhibited(boolean isTopLevelCall) {
        return this.fillContainerContext.isSplitTypePreventInhibited(isTopLevelCall);
    }
}

