/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.vis.threed.gfx;

import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.shape.Box;
import com.jme3.scene.shape.Cylinder;
import com.jme3.scene.shape.Sphere;
import java.util.ArrayList;
import java.util.List;
import jme3tools.optimize.GeometryBatchFactory;

class HumanMesh {
    private final Mesh mesh;
    private final float radius;
    private final int samples;

    public HumanMesh(int samples, float radius) {
        this.samples = samples;
        this.radius = radius;
        this.mesh = new Mesh();
        List<Geometry> geoms = this.makeGeometry();
        GeometryBatchFactory.mergeGeometries(geoms, (Mesh)this.mesh);
    }

    private List<Geometry> makeGeometry() {
        ArrayList<Geometry> geoms = new ArrayList<Geometry>();
        float HEAD = this.radius / 8.0f;
        Geometry head = new Geometry("head", (Mesh)new Sphere(this.samples, this.samples, HEAD / 1.75f));
        head.setLocalTranslation(0.0f, 0.0f, 3.5f * HEAD);
        geoms.add(head);
        Geometry body = new Geometry("body", (Mesh)new Box(HEAD, HEAD / 2.0f, 1.5f * HEAD));
        body.setLocalTranslation(0.0f, 0.0f, 1.5f * HEAD);
        geoms.add(body);
        Geometry lleg = new Geometry("left_leg", (Mesh)new Cylinder(this.samples, this.samples, HEAD / 3.0f, 4.0f * HEAD, true));
        lleg.setLocalTranslation(-HEAD / 2.0f, 0.0f, -2.0f * HEAD);
        geoms.add(lleg);
        Geometry rleg = new Geometry("right_leg", (Mesh)new Cylinder(this.samples, this.samples, HEAD / 3.0f, 4.0f * HEAD, true));
        rleg.setLocalTranslation(HEAD / 2.0f, 0.0f, -2.0f * HEAD);
        geoms.add(rleg);
        Geometry larm = new Geometry("left_arm", (Mesh)new Cylinder(this.samples, this.samples, HEAD / 4.0f, 3.0f * HEAD, true));
        larm.setLocalTranslation(-1.5f * HEAD, 0.0f, 1.5f * HEAD);
        geoms.add(larm);
        Geometry rarm = new Geometry("right_arm", (Mesh)new Cylinder(this.samples, this.samples, HEAD / 4.0f, 3.0f * HEAD, true));
        rarm.setLocalTranslation(1.5f * HEAD, 0.0f, 1.5f * HEAD);
        geoms.add(rarm);
        return geoms;
    }

    Mesh get() {
        return this.mesh;
    }
}

