/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.api.service;

import java.io.IOException;
import java.net.URL;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.frontend.ClientProxy;
import org.apache.cxf.interceptor.FIStaxInInterceptor;
import org.apache.cxf.interceptor.FIStaxOutInterceptor;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.cxf.transport.common.gzip.GZIPInInterceptor;
import org.apache.cxf.transport.common.gzip.GZIPOutInterceptor;
import org.apache.cxf.transport.http.HTTPConduit;
import org.openide.util.Exceptions;
import rs.co.ast.aspen.api.service.AggregationSearchResults;
import rs.co.ast.aspen.api.service.ApiAccount;
import rs.co.ast.aspen.api.service.ApiKeyResponse;
import rs.co.ast.aspen.api.service.ApiResponse;
import rs.co.ast.aspen.api.service.ApiService;
import rs.co.ast.aspen.api.service.ApiServiceException_Exception;
import rs.co.ast.aspen.api.service.AspenApiService;
import rs.co.ast.aspen.api.service.ClientScriptsUpdateReport;
import rs.co.ast.aspen.api.service.ComplexityViolation;
import rs.co.ast.aspen.api.service.ConsoleUser;
import rs.co.ast.aspen.api.service.CreateScriptDTO;
import rs.co.ast.aspen.api.service.DataMapValue;
import rs.co.ast.aspen.api.service.DeleteAllSavedScriptsResponse;
import rs.co.ast.aspen.api.service.DeliveryPoint;
import rs.co.ast.aspen.api.service.Destination;
import rs.co.ast.aspen.api.service.HostStatsCsvReport;
import rs.co.ast.aspen.api.service.HostStatsGuiReport;
import rs.co.ast.aspen.api.service.IndexDateRange;
import rs.co.ast.aspen.api.service.ListAccountsResponse;
import rs.co.ast.aspen.api.service.ListSavedScriptsResponse;
import rs.co.ast.aspen.api.service.ListScriptsResponse;
import rs.co.ast.aspen.api.service.LogFile;
import rs.co.ast.aspen.api.service.MappingObjectDTO;
import rs.co.ast.aspen.api.service.MethodExecutor;
import rs.co.ast.aspen.api.service.MethodImpl;
import rs.co.ast.aspen.api.service.ParsingDebugInfo;
import rs.co.ast.aspen.api.service.ParsingRuleDTO;
import rs.co.ast.aspen.api.service.ParsingRuleSetDTO;
import rs.co.ast.aspen.api.service.ParsingRulesGroupDTO;
import rs.co.ast.aspen.api.service.ParsingUpdateObjectDTO;
import rs.co.ast.aspen.api.service.PasswordPolicySettings;
import rs.co.ast.aspen.api.service.PusReports;
import rs.co.ast.aspen.api.service.RawLog;
import rs.co.ast.aspen.api.service.RawLogsCountContainer;
import rs.co.ast.aspen.api.service.RawLogsSearchResults;
import rs.co.ast.aspen.api.service.RegressionTestResult;
import rs.co.ast.aspen.api.service.RuleSetBackupContainerDTO;
import rs.co.ast.aspen.api.service.SavedQueryData;
import rs.co.ast.aspen.api.service.ScheduledTask;
import rs.co.ast.aspen.api.service.Script;
import rs.co.ast.aspen.api.service.ScriptType;
import rs.co.ast.aspen.api.service.ScriptsUpdateReport;
import rs.co.ast.aspen.api.service.SearchState;
import rs.co.ast.aspen.api.service.SecurityEvent;
import rs.co.ast.aspen.api.service.SecurityEventsCountContainer;
import rs.co.ast.aspen.api.service.SecurityEventsSearchResults;
import rs.co.ast.aspen.api.service.TermTimeHistogram;
import rs.co.ast.aspen.api.service.UpdateAccountResponse;

public class AspenApiServiceWsImpl
implements ApiService {
    private static final Logger LOGGER = Logger.getLogger(AspenApiServiceWsImpl.class.getName());
    private static final int MIN_GZIP_RESP_SIZE = 2048;
    private static final long cacheDuration = 18000000L;
    private AspenApiService aspenApiService;
    private String sid;
    private MethodExecutor exec;
    private Map<String, List<String>> mappingsCache;
    private long mappingsTimestamp;

    private AspenApiService getApiService(String serviceUrl) throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        if (this.aspenApiService == null) {
            URL url = new URL(serviceUrl);
            String protocol = url.getProtocol() != null ? url.getProtocol() : "http";
            String hostname = url.getHost();
            int port = url.getPort();
            if (port == -1) {
                port = protocol.equalsIgnoreCase("https") ? 8443 : 8080;
            }
            JaxWsProxyFactoryBean f = new JaxWsProxyFactoryBean();
            f.setServiceClass(AspenApiService.class);
            f.setAddress(String.format("%s://%s:%d/aspen-api-service/services/ApiService", protocol, hostname, port));
            f.getInInterceptors().add(new FIStaxInInterceptor());
            f.getOutInterceptors().add(new FIStaxOutInterceptor());
            f.getInInterceptors().add(new GZIPInInterceptor());
            f.getOutInterceptors().add(new GZIPOutInterceptor(2048));
            this.aspenApiService = (AspenApiService)f.create();
            KeyStore ks = KeyStore.getInstance("JKS");
            char[] password = "keystorepassword".toCharArray();
            ks.load(this.getClass().getClassLoader().getResourceAsStream("keystore"), password);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(ks, password);
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(ks);
            Client client = ClientProxy.getClient((Object)this.aspenApiService);
            HTTPConduit http = (HTTPConduit)client.getConduit();
            TLSClientParameters tls = new TLSClientParameters();
            tls.setKeyManagers(kmf.getKeyManagers());
            tls.setTrustManagers(tmf.getTrustManagers());
            tls.setDisableCNCheck(true);
            http.setTlsClientParameters(tls);
        }
        return this.aspenApiService;
    }

    @Override
    public List<Byte> ping(final int numberOfBytes) throws ApiServiceException_Exception {
        return this.exec.execute(new MethodImpl<List<Byte>>(){

            @Override
            public List<Byte> execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                return AspenApiServiceWsImpl.this.aspenApiService.ping(sessionId, numberOfBytes);
            }
        });
    }

    @Override
    public void login(String host, String username, String password) throws ApiServiceException_Exception {
        try {
            this.sid = this.getApiService(host).login(username, password);
            this.exec = new MethodExecutor(this.sid, this.aspenApiService);
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException ex) {
            LOGGER.log(Level.SEVERE, "Login error", ex);
            throw new RuntimeException(ex);
        }
    }

    @Override
    public void logoff() throws ApiServiceException_Exception {
        this.aspenApiService = null;
    }

    @Override
    public SecurityEventsSearchResults searchSecurityEvents(final String search, final SearchState state, final int pageLength, final long timeStart, final long timeFinish) throws ApiServiceException_Exception {
        return this.exec.execute(new MethodImpl<SecurityEventsSearchResults>(){

            @Override
            public SecurityEventsSearchResults execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                return AspenApiServiceWsImpl.this.aspenApiService.searchSecurityEvents(AspenApiServiceWsImpl.this.sid, search, state, pageLength, timeStart, timeFinish);
            }
        });
    }

    @Override
    public SecurityEventsSearchResults searchSecurityEventsAsc(final String search, final SearchState state, final int pageLength, final long timeStart, final long timeFinish) throws ApiServiceException_Exception {
        return this.exec.execute(new MethodImpl<SecurityEventsSearchResults>(){

            @Override
            public SecurityEventsSearchResults execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                return AspenApiServiceWsImpl.this.aspenApiService.searchSecurityEventsAsc(AspenApiServiceWsImpl.this.sid, search, state, pageLength, timeStart, timeFinish);
            }
        });
    }

    @Override
    public SecurityEventsSearchResults fetchSecurityEventsWithOffset(final String search, final SearchState state, final int pageLength, final long timeStart, final long timeFinish) throws ApiServiceException_Exception {
        return this.exec.execute(new MethodImpl<SecurityEventsSearchResults>(){

            @Override
            public SecurityEventsSearchResults execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                return AspenApiServiceWsImpl.this.aspenApiService.fetchSecurityEventsWithOffset(AspenApiServiceWsImpl.this.sid, search, state, pageLength, timeStart, timeFinish);
            }
        });
    }

    @Override
    public SecurityEventsSearchResults fetchSecurityEventsAscWithOffset(final String search, final SearchState state, final int pageLength, final long timeStart, final long timeFinish) throws ApiServiceException_Exception {
        return this.exec.execute(new MethodImpl<SecurityEventsSearchResults>(){

            @Override
            public SecurityEventsSearchResults execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                return AspenApiServiceWsImpl.this.aspenApiService.fetchSecurityEventsAscWithOffset(AspenApiServiceWsImpl.this.sid, search, state, pageLength, timeStart, timeFinish);
            }
        });
    }

    @Override
    public SecurityEventsCountContainer securityEventsCountSearch(String search, SearchState state, long timeStart, long timeFinish) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> this.aspenApiService.securityEventsCountSearch(sessionId, search, state, timeStart, timeFinish));
    }

    @Override
    public SecurityEventsSearchResults fetchSecurityEvents(String search, SearchState state, int pageLength, long timeStart, long timeFinish) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> this.aspenApiService.fetchSecurityEvents(sessionId, search, state, pageLength, timeStart, timeFinish));
    }

    @Override
    public SecurityEventsSearchResults fetchSecurityEventsAsc(String search, SearchState state, int pageLength, long timeStart, long timeFinish) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> this.aspenApiService.fetchSecurityEventsAsc(sessionId, search, state, pageLength, timeStart, timeFinish));
    }

    @Override
    public SecurityEvent getSecurityEvent(final String securityEventId, final long timeStart, final long timeFinish) throws ApiServiceException_Exception {
        return this.exec.execute(new MethodImpl<SecurityEvent>(){

            @Override
            public SecurityEvent execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                return AspenApiServiceWsImpl.this.aspenApiService.getSecurityEvent(AspenApiServiceWsImpl.this.sid, securityEventId, timeStart, timeFinish);
            }
        });
    }

    @Override
    public RawLogsCountContainer rawLogsCountSearch(String search, SearchState state, long timeStart, long timeFinish) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> this.aspenApiService.rawLogsCountSearch(sessionId, search, state, timeStart, timeFinish));
    }

    @Override
    public RawLogsSearchResults fetchRawLogsWithOffset(final String search, final SearchState state, final int pageLength, final long timeStart, final long timeFinish) throws ApiServiceException_Exception {
        return this.exec.execute(new MethodImpl<RawLogsSearchResults>(){

            @Override
            public RawLogsSearchResults execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                return AspenApiServiceWsImpl.this.aspenApiService.fetchRawLogsWithOffset(AspenApiServiceWsImpl.this.sid, search, state, pageLength, timeStart, timeFinish);
            }
        });
    }

    @Override
    public RawLogsSearchResults fetchRawLogsAscWithOffset(final String search, final SearchState state, final int pageLength, final long timeStart, final long timeFinish) throws ApiServiceException_Exception {
        return this.exec.execute(new MethodImpl<RawLogsSearchResults>(){

            @Override
            public RawLogsSearchResults execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                return AspenApiServiceWsImpl.this.aspenApiService.fetchRawLogsAscWithOffset(AspenApiServiceWsImpl.this.sid, search, state, pageLength, timeStart, timeFinish);
            }
        });
    }

    @Override
    public RawLogsSearchResults searchRawLogs(final String search, final SearchState state, final int pageLength, final long timeStart, final long timeFinish) throws ApiServiceException_Exception {
        return this.exec.execute(new MethodImpl<RawLogsSearchResults>(){

            @Override
            public RawLogsSearchResults execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                return AspenApiServiceWsImpl.this.aspenApiService.searchRawLogs(AspenApiServiceWsImpl.this.sid, search, state, pageLength, timeStart, timeFinish);
            }
        });
    }

    @Override
    public RawLogsSearchResults searchRawLogsAsc(final String search, final SearchState state, final int pageLength, final long timeStart, final long timeFinish) throws ApiServiceException_Exception {
        return this.exec.execute(new MethodImpl<RawLogsSearchResults>(){

            @Override
            public RawLogsSearchResults execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                return AspenApiServiceWsImpl.this.aspenApiService.searchRawLogsAsc(AspenApiServiceWsImpl.this.sid, search, state, pageLength, timeStart, timeFinish);
            }
        });
    }

    @Override
    public RawLog getRawLog(final String RawLogId, final long timeStart, final long timeFinish) throws ApiServiceException_Exception {
        return this.exec.execute(new MethodImpl<RawLog>(){

            @Override
            public RawLog execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                return AspenApiServiceWsImpl.this.aspenApiService.getRawLog(AspenApiServiceWsImpl.this.sid, RawLogId, timeStart, timeFinish);
            }
        });
    }

    @Override
    public List<String> getDataMapNames() throws ApiServiceException_Exception {
        return this.exec.execute(new MethodImpl<List<String>>(){

            @Override
            public List<String> execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                return apiService.getDataMapNames(sessionId);
            }
        });
    }

    @Override
    public List<String> getKeysForDataMap(final String mapName) throws ApiServiceException_Exception {
        return this.exec.execute(new MethodImpl<List<String>>(){

            @Override
            public List<String> execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                return apiService.getKeysForDataMap(sessionId, mapName);
            }
        });
    }

    @Override
    public List<DataMapValue> getDataMapKeysWithLastUpdatedForDataMap(final String mapName) throws ApiServiceException_Exception {
        return this.exec.execute(new MethodImpl<List<DataMapValue>>(){

            @Override
            public List<DataMapValue> execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                return apiService.getDataMapKeysWithLastUpdatedForDataMap(sessionId, mapName);
            }
        });
    }

    @Override
    public DataMapValue getValueForDataMapKey(final String mapName, final String key) throws ApiServiceException_Exception {
        return this.exec.execute(new MethodImpl<DataMapValue>(){

            @Override
            public DataMapValue execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                return apiService.getValueForDataMapKey(sessionId, mapName, key);
            }
        });
    }

    @Override
    public void setValueForDataMapKey(final String mapName, final String key, final String value) throws ApiServiceException_Exception {
        this.exec.execute(new MethodImpl<Void>(){

            @Override
            public Void execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                apiService.setValueForDataMapKey(sessionId, mapName, key, value);
                return null;
            }
        });
    }

    @Override
    public void deleteDataMapKey(final String mapName, final String key) throws ApiServiceException_Exception {
        this.exec.execute(new MethodImpl<Void>(){

            @Override
            public Void execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                apiService.deleteDataMapKey(sessionId, mapName, key);
                return null;
            }
        });
    }

    @Override
    public void renameDataMapKey(final String mapName, final String oldKey, final String newKey) throws ApiServiceException_Exception {
        this.exec.execute(new MethodImpl<Void>(){

            @Override
            public Void execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                apiService.renameDataMapKey(sessionId, mapName, oldKey, newKey);
                return null;
            }
        });
    }

    @Override
    public void deleteDataMap(final String mapName) throws ApiServiceException_Exception {
        this.exec.execute(new MethodImpl<Void>(){

            @Override
            public Void execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                apiService.deleteDataMap(sessionId, mapName);
                return null;
            }
        });
    }

    @Override
    public Script createScript(final String scriptName, final String scriptLang, final String scriptDesc, final ScriptType scriptType) throws ApiServiceException_Exception {
        return this.exec.execute(new MethodImpl<Script>(){

            @Override
            public Script execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                return apiService.createScript(sessionId, scriptName, scriptLang, scriptDesc, scriptType);
            }
        });
    }

    @Override
    public void createScriptWithText(final String scriptName, final String scriptText, final String scriptLang, final String scriptDesc, final ScriptType scriptType) throws ApiServiceException_Exception {
        this.exec.execute(new MethodImpl<Void>(){

            @Override
            public Void execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                apiService.createScriptWithText(sessionId, scriptName, scriptText, scriptLang, scriptDesc, scriptType);
                return null;
            }
        });
    }

    @Override
    public Script renameScript(final Script script) throws ApiServiceException_Exception {
        return this.exec.execute(new MethodImpl<Script>(){

            @Override
            public Script execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                return apiService.renameScript(sessionId, script);
            }
        });
    }

    @Override
    public void deleteScript(final String scriptId) throws ApiServiceException_Exception {
        this.exec.execute(new MethodImpl<Void>(){

            @Override
            public Void execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                apiService.deleteScript(sessionId, scriptId);
                return null;
            }
        });
    }

    @Override
    public void deleteScripts(List<Script> scripts) throws ApiServiceException_Exception {
        this.exec.execute((sessionId, apiService) -> {
            apiService.deleteScripts(sessionId, scripts);
            return null;
        });
    }

    @Override
    public void updateScript(final Script script) throws ApiServiceException_Exception {
        this.exec.execute(new MethodImpl<Void>(){

            @Override
            public Void execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                apiService.updateScript(sessionId, script);
                return null;
            }
        });
    }

    @Override
    public void updateScripts(final List<Script> scripts) throws ApiServiceException_Exception {
        this.exec.execute(new MethodImpl<Void>(){

            @Override
            public Void execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                apiService.updateScripts(sessionId, scripts);
                return null;
            }
        });
    }

    @Override
    public void enableScript(final Script script, final boolean enable) throws ApiServiceException_Exception {
        this.exec.execute(new MethodImpl<Void>(){

            @Override
            public Void execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                apiService.enableScript(sessionId, script, enable);
                return null;
            }
        });
    }

    @Override
    public void enableScripts(final List<Script> scripts, final boolean enable) throws ApiServiceException_Exception {
        this.exec.execute(new MethodImpl<Void>(){

            @Override
            public Void execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                apiService.enableScripts(sessionId, scripts, enable);
                return null;
            }
        });
    }

    @Override
    public Collection<Script> getAllScripts() throws ApiServiceException_Exception {
        return this.exec.execute(new MethodImpl<Collection<Script>>(){

            @Override
            public Collection<Script> execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                return apiService.getAllScripts(sessionId);
            }
        });
    }

    @Override
    public Script getVisualizationRuleSetByName(final String scriptName) throws ApiServiceException_Exception {
        return this.exec.execute(new MethodImpl<Script>(){

            @Override
            public Script execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                return apiService.getVisualizationRuleSetByName(sessionId, scriptName);
            }
        });
    }

    @Override
    public List<Script> getScriptsByType(final ScriptType scriptType) throws ApiServiceException_Exception {
        return this.exec.execute(new MethodImpl<List<Script>>(){

            @Override
            public List<Script> execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                return apiService.getScriptsByType(sessionId, scriptType);
            }
        });
    }

    @Override
    public List<ConsoleUser> getConsoleUsers() throws ApiServiceException_Exception {
        return this.exec.execute(new MethodImpl<List<ConsoleUser>>(){

            @Override
            public List<ConsoleUser> execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                return AspenApiServiceWsImpl.this.aspenApiService.getConsoleUsers(sessionId);
            }
        });
    }

    @Override
    public ConsoleUser createConsoleUser(final String username) throws ApiServiceException_Exception {
        return this.exec.execute(new MethodImpl<ConsoleUser>(){

            @Override
            public ConsoleUser execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                return AspenApiServiceWsImpl.this.aspenApiService.createConsoleUser(sessionId, username);
            }
        });
    }

    @Override
    public void deleteConsoleUser(final String username) throws ApiServiceException_Exception {
        this.exec.execute(new MethodImpl<Void>(){

            @Override
            public Void execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                AspenApiServiceWsImpl.this.aspenApiService.deleteConsoleUser(sessionId, username);
                return null;
            }
        });
    }

    @Override
    public void setConsoleUserPassword(final String username, final String password) throws ApiServiceException_Exception {
        this.exec.execute(new MethodImpl<Void>(){

            @Override
            public Void execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                AspenApiServiceWsImpl.this.aspenApiService.setConsoleUserPassword(sessionId, username, password);
                return null;
            }
        });
    }

    @Override
    public void updateConsoleUser(final ConsoleUser user) throws ApiServiceException_Exception {
        this.exec.execute(new MethodImpl<Void>(){

            @Override
            public Void execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                AspenApiServiceWsImpl.this.aspenApiService.updateConsoleUser(sessionId, user);
                return null;
            }
        });
    }

    @Override
    public PusReports getPUSReports() throws ApiServiceException_Exception {
        return this.exec.execute(new MethodImpl<PusReports>(){

            @Override
            public PusReports execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                return apiService.getPUSReports(sessionId);
            }
        });
    }

    @Override
    public List<Destination> getDestinations() throws ApiServiceException_Exception {
        return this.exec.execute(new MethodImpl<List<Destination>>(){

            @Override
            public List<Destination> execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                return apiService.getDestinations(sessionId);
            }
        });
    }

    @Override
    public List<DeliveryPoint> getDeliveryPoints(final String destinationName) throws ApiServiceException_Exception {
        return this.exec.execute(new MethodImpl<List<DeliveryPoint>>(){

            @Override
            public List<DeliveryPoint> execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                return apiService.getDeliveryPoints(sessionId, destinationName);
            }
        });
    }

    @Override
    public boolean addNewDestination(final String destinationName) throws ApiServiceException_Exception {
        return this.exec.execute(new MethodImpl<Boolean>(){

            @Override
            public Boolean execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                return apiService.addNewDestination(sessionId, destinationName);
            }
        });
    }

    @Override
    public boolean deleteDestination(final String destinationName) throws ApiServiceException_Exception {
        return this.exec.execute(new MethodImpl<Boolean>(){

            @Override
            public Boolean execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                return apiService.deleteDestination(sessionId, destinationName);
            }
        });
    }

    @Override
    public boolean updateDestination(final Destination destination) throws ApiServiceException_Exception {
        return this.exec.execute(new MethodImpl<Boolean>(){

            @Override
            public Boolean execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                return apiService.updateDestination(sessionId, destination);
            }
        });
    }

    @Override
    public List<ScheduledTask> getAllTasks() throws ApiServiceException_Exception {
        return this.exec.execute(new MethodImpl<List<ScheduledTask>>(){

            @Override
            public List<ScheduledTask> execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                return apiService.getAllTasks(sessionId);
            }
        });
    }

    @Override
    public void updateTask(final String id, final String scriptName, final String cronSpec, final boolean enabled) throws ApiServiceException_Exception {
        this.exec.execute(new MethodImpl<Void>(){

            @Override
            public Void execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                apiService.updateTask(sessionId, id, scriptName, cronSpec, enabled);
                return null;
            }
        });
    }

    @Override
    public void deleteTask(final String id) throws ApiServiceException_Exception {
        this.exec.execute(new MethodImpl<Void>(){

            @Override
            public Void execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                apiService.deleteTask(sessionId, id);
                return null;
            }
        });
    }

    @Override
    public void deleteTasks(final List<ScheduledTask> tasks) throws ApiServiceException_Exception {
        this.exec.execute(new MethodImpl<Void>(){

            @Override
            public Void execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                apiService.deleteTasks(sessionId, tasks);
                return null;
            }
        });
    }

    @Override
    public boolean addTask(final String scriptName, final String cronSpec, final boolean enabled) throws ApiServiceException_Exception {
        return this.exec.execute(new MethodImpl<Boolean>(){

            @Override
            public Boolean execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                return apiService.addTask(sessionId, scriptName, cronSpec, enabled);
            }
        });
    }

    @Override
    public List<ParsingRuleSetDTO> getParsingRuleSets() throws ApiServiceException_Exception {
        return this.exec.execute(new MethodImpl<List<ParsingRuleSetDTO>>(){

            @Override
            public List<ParsingRuleSetDTO> execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                return apiService.getParsingRuleSets(sessionId);
            }
        });
    }

    @Override
    public void importRuleSets(final RuleSetBackupContainerDTO rsbc) throws ApiServiceException_Exception {
        this.exec.execute(new MethodImpl<Void>(){

            @Override
            public Void execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                apiService.importRuleSets(sessionId, rsbc);
                return null;
            }
        });
    }

    @Override
    public List<ParsingRulesGroupDTO> getParsingRulesGroups(final String parentId) throws ApiServiceException_Exception {
        return this.exec.execute(new MethodImpl<List<ParsingRulesGroupDTO>>(){

            @Override
            public List<ParsingRulesGroupDTO> execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                return apiService.getParsingRulesGroups(sessionId, parentId);
            }
        });
    }

    @Override
    public List<ParsingRuleDTO> getParsingRules(final String parsingRulesGroupId) throws ApiServiceException_Exception {
        return this.exec.execute(new MethodImpl<List<ParsingRuleDTO>>(){

            @Override
            public List<ParsingRuleDTO> execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                return apiService.getParsingRules(sessionId, parsingRulesGroupId);
            }
        });
    }

    @Override
    public void saveChanges(final ParsingUpdateObjectDTO puo) throws ApiServiceException_Exception {
        this.exec.execute(new MethodImpl<Void>(){

            @Override
            public Void execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                apiService.saveChanges(sessionId, puo);
                return null;
            }
        });
    }

    @Override
    public ParsingDebugInfo simulateParsing(final String rawlogId, final long timeStart, final long timeFinish) throws ApiServiceException_Exception {
        return this.exec.execute(new MethodImpl<ParsingDebugInfo>(){

            @Override
            public ParsingDebugInfo execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                return apiService.simulateParsing(sessionId, rawlogId, timeStart, timeFinish);
            }
        });
    }

    @Override
    public List<RegressionTestResult> regressionTest() throws ApiServiceException_Exception {
        return this.exec.execute(new MethodImpl<List<RegressionTestResult>>(){

            @Override
            public List<RegressionTestResult> execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                return apiService.regressionTest(sessionId);
            }
        });
    }

    @Override
    public List<ParsingRulesGroupDTO> getAllParsingRulesGroups() throws ApiServiceException_Exception {
        return this.exec.execute(new MethodImpl<List<ParsingRulesGroupDTO>>(){

            @Override
            public List<ParsingRulesGroupDTO> execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                return apiService.getAllParsingRulesGroups(sessionId);
            }
        });
    }

    @Override
    public List<ParsingRuleDTO> getAllParsingRules() throws ApiServiceException_Exception {
        return this.exec.execute(new MethodImpl<List<ParsingRuleDTO>>(){

            @Override
            public List<ParsingRuleDTO> execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                return apiService.getAllParsingRules(sessionId);
            }
        });
    }

    @Override
    public Map<String, List<String>> getMappings() throws ApiServiceException_Exception {
        return this.exec.execute(new MethodImpl<Map<String, List<String>>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Map<String, List<String>> execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                if (System.currentTimeMillis() - AspenApiServiceWsImpl.this.mappingsTimestamp > 18000000L) {
                    HashMap<String, List<String>> map = new HashMap<String, List<String>>();
                    try {
                        List<MappingObjectDTO> mappings = apiService.getMappings(sessionId);
                        for (MappingObjectDTO mo : mappings) {
                            List<String> list;
                            if (!map.containsKey(mo.getCategory())) {
                                list = new ArrayList();
                                if (mo.getKey() != null) {
                                    list.add(mo.getKey());
                                }
                                map.put(mo.getCategory(), list);
                                continue;
                            }
                            list = (List)map.get(mo.getCategory());
                            list.add(mo.getKey());
                            map.put(mo.getCategory(), list);
                        }
                    }
                    catch (ApiServiceException_Exception ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    finally {
                        AspenApiServiceWsImpl.this.mappingsTimestamp = System.currentTimeMillis();
                        AspenApiServiceWsImpl.this.mappingsCache = map;
                        return map;
                    }
                }
                return AspenApiServiceWsImpl.this.mappingsCache;
            }
        });
    }

    @Override
    public List<String> getMappingsForCategory(final String category) throws ApiServiceException_Exception {
        return this.exec.execute(new MethodImpl<List<String>>(){

            @Override
            public List<String> execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                return AspenApiServiceWsImpl.this.getMappings().get(category);
            }
        });
    }

    @Override
    public List<SavedQueryData> getSecurityEventQueries() throws ApiServiceException_Exception {
        return this.exec.execute(new MethodImpl<List<SavedQueryData>>(){

            @Override
            public List<SavedQueryData> execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                return apiService.getSecurityEventQueries(sessionId);
            }
        });
    }

    @Override
    public List<SavedQueryData> getRawLogQueries() throws ApiServiceException_Exception {
        return this.exec.execute(new MethodImpl<List<SavedQueryData>>(){

            @Override
            public List<SavedQueryData> execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                return apiService.getRawLogQueries(sessionId);
            }
        });
    }

    @Override
    public String getSavedQueryName(final String query) throws ApiServiceException_Exception {
        return this.exec.execute(new MethodImpl<String>(){

            @Override
            public String execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                return apiService.getSavedQueryName(sessionId, query);
            }
        });
    }

    @Override
    public void deleteSavedQuery(final String queryId) throws ApiServiceException_Exception {
        this.exec.execute(new MethodImpl<Void>(){

            @Override
            public Void execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                apiService.deleteSavedQuery(sessionId, queryId);
                return null;
            }
        });
    }

    @Override
    public void saveSavedQuery(final SavedQueryData query) throws ApiServiceException_Exception {
        this.exec.execute(new MethodImpl<Void>(){

            @Override
            public Void execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                apiService.saveSavedQuery(sessionId, query);
                return null;
            }
        });
    }

    @Override
    public void resendEvent(final RawLog rawLog) throws ApiServiceException_Exception {
        this.exec.execute(new MethodImpl<Void>(){

            @Override
            public Void execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                apiService.resendEvent(sessionId, rawLog);
                return null;
            }
        });
    }

    @Override
    public List<TermTimeHistogram> getRLTermTimeHistogram(final String query, final String field, final long timeStart, final long timeFinish, final int noOfTerms, final String interval, final boolean sortAsc) throws ApiServiceException_Exception {
        return this.exec.execute(new MethodImpl<List<TermTimeHistogram>>(){

            @Override
            public List<TermTimeHistogram> execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                return AspenApiServiceWsImpl.this.aspenApiService.getRLTermTimeHistogram(sessionId, query, field, timeStart, timeFinish, noOfTerms, interval, sortAsc);
            }
        });
    }

    @Override
    public List<TermTimeHistogram> getSETermTimeHistogram(final String query, final String field, final long timeStart, final long timeFinish, final int noOfTerms, final String interval, final boolean sortAsc) throws ApiServiceException_Exception {
        return this.exec.execute(new MethodImpl<List<TermTimeHistogram>>(){

            @Override
            public List<TermTimeHistogram> execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                return AspenApiServiceWsImpl.this.aspenApiService.getSETermTimeHistogram(sessionId, query, field, timeStart, timeFinish, noOfTerms, interval, sortAsc);
            }
        });
    }

    @Override
    public AggregationSearchResults getAggregationCount(final SearchState searchState, final String query, final String field, final int topN, Integer timeout, final long timeStart, final long timeFinish, final boolean sortAsc) throws ApiServiceException_Exception {
        return this.exec.execute(new MethodImpl<AggregationSearchResults>(){

            @Override
            public AggregationSearchResults execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                return AspenApiServiceWsImpl.this.aspenApiService.getAggregationCount(sessionId, query, field, searchState, topN, timeStart, timeFinish, sortAsc);
            }
        });
    }

    @Override
    public LogFile getServerLog(final int lastNLines) throws ApiServiceException_Exception {
        return this.exec.execute(new MethodImpl<LogFile>(){

            @Override
            public LogFile execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                return AspenApiServiceWsImpl.this.aspenApiService.getServerLog(sessionId, lastNLines);
            }
        });
    }

    @Override
    public LogFile getTomcatLog(final int lastNLines) throws ApiServiceException_Exception {
        return this.exec.execute(new MethodImpl<LogFile>(){

            @Override
            public LogFile execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                return AspenApiServiceWsImpl.this.aspenApiService.getTomcatLog(sessionId, lastNLines);
            }
        });
    }

    @Override
    public LogFile getScriptsLog(final int lastNLines) throws ApiServiceException_Exception {
        return this.exec.execute(new MethodImpl<LogFile>(){

            @Override
            public LogFile execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                return AspenApiServiceWsImpl.this.aspenApiService.getScriptsLog(sessionId, lastNLines);
            }
        });
    }

    @Override
    public List<IndexDateRange> getSecurityEventDateRangeByIndex(final long timeStart, final long timeFinish, final boolean sortAsc) throws ApiServiceException_Exception {
        return this.exec.execute(new MethodImpl<List<IndexDateRange>>(){

            @Override
            public List<IndexDateRange> execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                return apiService.getSecurityEventDateRangeByIndex(sessionId, timeStart, timeFinish, sortAsc);
            }
        });
    }

    @Override
    public List<IndexDateRange> getRawLogDateRangeByIndex(final long timeStart, final long timeFinish, final boolean sortAsc) throws ApiServiceException_Exception {
        return this.exec.execute(new MethodImpl<List<IndexDateRange>>(){

            @Override
            public List<IndexDateRange> execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                return apiService.getRawLogDateRangeByIndex(sessionId, timeStart, timeFinish, sortAsc);
            }
        });
    }

    @Override
    public List<IndexDateRange> getCustomSecurityEventDateRangeByIndex(long timeStart, long timeFinish, long split, boolean sortAsc) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> apiService.getCustomSecurityEventDateRangeByIndex(sessionId, timeStart, timeFinish, split, sortAsc));
    }

    @Override
    public List<IndexDateRange> getCustomRawLogDateRangeByIndex(long timeStart, long timeFinish, long split, boolean sortAsc) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> apiService.getCustomRawLogDateRangeByIndex(sessionId, timeStart, timeFinish, split, sortAsc));
    }

    @Override
    public List<ComplexityViolation> checkPasswordComplexity(String password) throws ApiServiceException_Exception {
        return this.exec.execute((sesionId, apiService) -> this.aspenApiService.checkPasswordComplexity(sesionId, password));
    }

    @Override
    public void disableConsoleUser(String username) throws ApiServiceException_Exception {
        this.exec.execute((sessionId, apiService) -> {
            apiService.disableConsoleUser(sessionId, username);
            return null;
        });
    }

    @Override
    public void enableConsoleUser(String username) throws ApiServiceException_Exception {
        this.exec.execute((sessionId, apiService) -> {
            apiService.enableConsoleUser(sessionId, username);
            return null;
        });
    }

    @Override
    public void unlockConsoleUser(String username) throws ApiServiceException_Exception {
        this.exec.execute((sessionId, apiService) -> {
            apiService.unlockConsoleUser(sessionId, username);
            return null;
        });
    }

    @Override
    public void setConsoleUserPasswordForSelf(String username, String oldPassword, String newPassword) throws ApiServiceException_Exception {
        this.exec.execute((sessionId, apiService) -> {
            this.aspenApiService.setConsoleUserPasswordForSelf(sessionId, oldPassword, newPassword);
            return null;
        });
    }

    @Override
    public PasswordPolicySettings getPasswordPolicySettings() throws ApiServiceException_Exception {
        return this.exec.execute((sesionId, apiSerivce) -> apiSerivce.getPasswordPolicySettings(sesionId));
    }

    @Override
    public void setPasswordPolicySettings(PasswordPolicySettings passwordPolicySettings) throws ApiServiceException_Exception {
        this.exec.execute((sesionId, apiService) -> {
            apiService.setPasswordPolicySettings(sesionId, passwordPolicySettings);
            return null;
        });
    }

    @Override
    public boolean heartbeat() throws ApiServiceException_Exception {
        return this.exec.execute(new MethodImpl<Boolean>(){

            @Override
            public Boolean execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                return apiService.heartbeat(sessionId);
            }
        });
    }

    @Override
    public ScriptsUpdateReport checkScriptsForUpdate(final ClientScriptsUpdateReport clientScriptUpdateReport) throws ApiServiceException_Exception {
        return this.exec.execute(new MethodImpl<ScriptsUpdateReport>(){

            @Override
            public ScriptsUpdateReport execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                return apiService.checkScriptsForUpdate(sessionId, clientScriptUpdateReport);
            }
        });
    }

    @Override
    public ListScriptsResponse apiGetAllScripts() throws ApiServiceException_Exception {
        return this.exec.execute(new MethodImpl<ListScriptsResponse>(){

            @Override
            public ListScriptsResponse execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                return apiService.apiGetAllScripts(sessionId);
            }
        });
    }

    @Override
    public ApiResponse apiCreateScript(final CreateScriptDTO dto) throws ApiServiceException_Exception {
        return this.exec.execute(new MethodImpl<ApiResponse>(){

            @Override
            public ApiResponse execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                return apiService.apiCreateScript(sessionId, dto);
            }
        });
    }

    @Override
    public ApiResponse apiDeleteScript(final String id) throws ApiServiceException_Exception {
        return this.exec.execute(new MethodImpl<ApiResponse>(){

            @Override
            public ApiResponse execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                return apiService.apiDeleteScript(sessionId, id);
            }
        });
    }

    @Override
    public ApiResponse apiUpdateScriptText(final String id, final String scriptText) throws ApiServiceException_Exception {
        return this.exec.execute(new MethodImpl<ApiResponse>(){

            @Override
            public ApiResponse execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                return apiService.apiUpdateScriptText(sessionId, id, scriptText);
            }
        });
    }

    @Override
    public ApiResponse apiUpdateScript(final Script script) throws ApiServiceException_Exception {
        return this.exec.execute(new MethodImpl<ApiResponse>(){

            @Override
            public ApiResponse execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                return apiService.apiUpdateScript(sessionId, script);
            }
        });
    }

    @Override
    public ApiResponse apiRenameScript(final String id, final String scriptName) throws ApiServiceException_Exception {
        return this.exec.execute(new MethodImpl<ApiResponse>(){

            @Override
            public ApiResponse execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                return apiService.apiRenameScript(sessionId, id, scriptName);
            }
        });
    }

    @Override
    public ListAccountsResponse apiGetAllAccounts() throws ApiServiceException_Exception {
        return this.exec.execute(new MethodImpl<ListAccountsResponse>(){

            @Override
            public ListAccountsResponse execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                return apiService.apiGetAllAccounts(sessionId);
            }
        });
    }

    @Override
    public ApiKeyResponse apiCreateAccount(final ApiAccount account) throws ApiServiceException_Exception {
        return this.exec.execute(new MethodImpl<ApiKeyResponse>(){

            @Override
            public ApiKeyResponse execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                return apiService.apiCreateAccount(sessionId, account);
            }
        });
    }

    @Override
    public ApiResponse apiDeleteAccount(final String id) throws ApiServiceException_Exception {
        return this.exec.execute(new MethodImpl<ApiResponse>(){

            @Override
            public ApiResponse execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                return apiService.apiDeleteAccount(sessionId, id);
            }
        });
    }

    @Override
    public UpdateAccountResponse apiUpdateAccount(final String id, final ApiAccount account) throws ApiServiceException_Exception {
        return this.exec.execute(new MethodImpl<UpdateAccountResponse>(){

            @Override
            public UpdateAccountResponse execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                return apiService.apiUpdateAccount(sessionId, id, account);
            }
        });
    }

    @Override
    public ApiResponse apiRenameAccount(final String id, final String accountName) throws ApiServiceException_Exception {
        return this.exec.execute(new MethodImpl<ApiResponse>(){

            @Override
            public ApiResponse execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                return apiService.apiRenameAccount(sessionId, id, accountName);
            }
        });
    }

    @Override
    public ApiKeyResponse apiGenerateNewApiKeyForAccount(final String id) throws ApiServiceException_Exception {
        return this.exec.execute(new MethodImpl<ApiKeyResponse>(){

            @Override
            public ApiKeyResponse execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                return apiService.apiGenerateNewApiKeyForAccount(sessionId, id);
            }
        });
    }

    @Override
    public ListSavedScriptsResponse apiGetAllSavedScripts() throws ApiServiceException_Exception {
        return this.exec.execute(new MethodImpl<ListSavedScriptsResponse>(){

            @Override
            public ListSavedScriptsResponse execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                return apiService.apiGetAllSavedScripts(sessionId);
            }
        });
    }

    @Override
    public ApiResponse apiDeleteSavedScript(final String id) throws ApiServiceException_Exception {
        return this.exec.execute(new MethodImpl<ApiResponse>(){

            @Override
            public ApiResponse execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                return apiService.apiDeleteSavedScript(sessionId, id);
            }
        });
    }

    @Override
    public DeleteAllSavedScriptsResponse apiDeleteAllSavedScripts() throws ApiServiceException_Exception {
        return this.exec.execute(new MethodImpl<DeleteAllSavedScriptsResponse>(){

            @Override
            public DeleteAllSavedScriptsResponse execute(String sessionId, AspenApiService apiService) throws ApiServiceException_Exception {
                return apiService.apiDeleteAllSavedScripts(sessionId);
            }
        });
    }

    @Override
    public HostStatsCsvReport hostCsvReport(String fqdbRegex, long start, long finish, String delimeter) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> apiService.hostCsvReport(sessionId, fqdbRegex, start, finish, delimeter));
    }

    @Override
    public HostStatsGuiReport hostGuiReport(String fqdbRegex, long start, long finish) throws ApiServiceException_Exception {
        return this.exec.execute((sessionId, apiService) -> apiService.hostGuiReport(sessionId, fqdbRegex, start, finish));
    }
}

