/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.visualization.properties;

import com.jme3.math.ColorRGBA;
import com.jme3.math.Vector2f;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.openide.windows.WindowManager;
import rs.co.ast.aspen.core.module.visengine.graph.Node;
import rs.co.ast.aspen.gui.module.vis.threed.gfx.ColorString;
import rs.co.ast.aspen.gui.module.vis.threed.gfx.Renderer;
import rs.co.ast.aspen.gui.module.vis.threed.gfx.SelectedListener;
import rs.co.ast.aspen.gui.module.vis.threed.phys.PhysicsBody;
import rs.co.ast.aspen.gui.module.visualization.Config;
import rs.co.ast.aspen.gui.module.visualization.properties.VisualizationPropertiesTopComponent;

public class SelectedListenerImpl
implements SelectedListener {
    private VisualizationPropertiesTopComponent visPropTC = (VisualizationPropertiesTopComponent)WindowManager.getDefault().findTopComponent("VisualizationPropertiesTopComponent");
    private Node prevHoverNode = null;
    private List<Node> glowNodes = new ArrayList<Node>();
    private List<String> glowColors = new ArrayList<String>();
    private Renderer app;
    private Config config;

    public SelectedListenerImpl(Renderer app, Config config) {
        this.app = app;
        this.config = config;
    }

    public void selected(Object obj, float dist, String mb, Vector2f pos) {
        if (obj instanceof PhysicsBody) {
            Node node = ((PhysicsBody)obj).node;
            if ("RMB".equals(mb)) {
                this.visPropTC.updateNodeInfo(node);
            } else if ("LMB".equals(mb)) {
                this.app.cameraFlyTo(node.id, 1.0f, 0.0f, 0.0f, 0.0f, 500.0f);
            } else if (!"MMB".equals(mb) && "NMB".equals(mb)) {
                if (this.prevHoverNode == null || !this.prevHoverNode.id.equals(node.id)) {
                    List allNodesList = this.config.getVisEngine().allNodesList();
                    this.glowNodes = new ArrayList<Node>();
                    this.glowColors = new ArrayList<String>();
                    for (int i = 0; i < 9; ++i) {
                        String l = "%level" + i;
                        String link = node.get(l + "_links");
                        if (link == null) continue;
                        String[] split = link.split(",");
                        List<String> links = Arrays.asList(split);
                        String glowColor = node.get(l + "_glow_color", node.get("%color"));
                        for (Node n : allNodesList) {
                            if (!links.contains(n.get("id"))) continue;
                            this.glowNodes.add(n);
                            this.glowColors.add(glowColor);
                        }
                    }
                    this.prevHoverNode = node;
                }
                for (int i = 0; i < this.glowNodes.size(); ++i) {
                    Node n = this.glowNodes.get(i);
                    String color = this.glowColors.get(i);
                    ColorRGBA[] colors = new ColorRGBA[]{new ColorString(color).color()};
                    this.app.objectGlow(n.id, 0.0f, 1.0f, colors);
                }
            }
        }
    }
}

