/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.fbx.objects;

import com.jme3.asset.AssetManager;
import com.jme3.asset.TextureKey;
import com.jme3.asset.plugins.FileLocator;
import com.jme3.scene.plugins.fbx.ContentTextureKey;
import com.jme3.scene.plugins.fbx.ContentTextureLocator;
import com.jme3.scene.plugins.fbx.SceneLoader;
import com.jme3.scene.plugins.fbx.file.FbxElement;
import com.jme3.scene.plugins.fbx.objects.FbxObject;
import com.jme3.texture.Image;
import com.jme3.texture.Texture;
import com.jme3.texture.image.ColorSpace;
import com.jme3.util.BufferUtils;
import java.io.File;

public class FbxImage
extends FbxObject {
    String filename;
    String relativeFilename;
    byte[] content;
    String imageType;
    public Image image;

    public FbxImage(SceneLoader scene, FbxElement element) {
        super(scene, element);
        if (this.type.equals("Clip")) {
            for (FbxElement e : element.children) {
                switch (e.id) {
                    case "Type": {
                        this.imageType = (String)e.properties.get(0);
                        break;
                    }
                    case "Filename": 
                    case "FileName": {
                        this.filename = (String)e.properties.get(0);
                        break;
                    }
                    case "RelativeFilename": {
                        this.relativeFilename = (String)e.properties.get(0);
                        break;
                    }
                    case "Content": {
                        if (e.properties.size() <= 0) break;
                        this.content = (byte[])e.properties.get(0);
                    }
                }
            }
            this.image = this.createImage();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Image createImage() {
        Texture tex;
        String locatorPath;
        File file;
        AssetManager assetManager = this.scene.assetManager;
        Image image = null;
        if (this.filename != null && (file = new File(this.filename)).exists() && file.isFile()) {
            File dir = new File(file.getParent());
            String locatorPath2 = dir.getAbsolutePath();
            Texture tex2 = null;
            try {
                assetManager.registerLocator(locatorPath2, FileLocator.class);
                tex2 = assetManager.loadTexture(file.getName());
            }
            catch (Exception exception) {
            }
            finally {
                assetManager.unregisterLocator(locatorPath2, FileLocator.class);
            }
            if (tex2 != null) {
                image = tex2.getImage();
            }
        }
        if (image == null && this.relativeFilename != null) {
            File dir = new File(this.scene.sceneFolderName);
            locatorPath = dir.getAbsolutePath();
            tex = null;
            try {
                assetManager.registerLocator(locatorPath, FileLocator.class);
                tex = assetManager.loadTexture(this.relativeFilename);
            }
            catch (Exception exception) {
            }
            finally {
                assetManager.unregisterLocator(locatorPath, FileLocator.class);
            }
            if (tex != null) {
                image = tex.getImage();
            }
        }
        if (image == null && this.content != null) {
            String filename = null;
            if (this.filename != null) {
                filename = new File(this.filename).getName();
            }
            if (filename != null && this.relativeFilename != null) {
                filename = this.relativeFilename;
            }
            if (filename != null) {
                locatorPath = this.scene.sceneFilename;
                filename = this.scene.sceneFilename + File.separatorChar + filename;
                tex = null;
                try {
                    assetManager.registerLocator(locatorPath, ContentTextureLocator.class);
                    tex = assetManager.loadTexture((TextureKey)new ContentTextureKey(filename, this.content));
                }
                catch (Exception exception) {
                }
                finally {
                    assetManager.unregisterLocator(locatorPath, ContentTextureLocator.class);
                }
                if (tex != null) {
                    image = tex.getImage();
                }
            }
        }
        if (image == null && this.relativeFilename != null) {
            String[] split = this.relativeFilename.split("[\\\\/]");
            String filename = split[split.length - 1];
            tex = null;
            try {
                tex = assetManager.loadTexture((TextureKey)new ContentTextureKey(this.scene.currentAssetInfo.getKey().getFolder() + filename, this.content));
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (tex != null) {
                image = tex.getImage();
            }
        }
        if (image == null) {
            return new Image(Image.Format.RGB8, 1, 1, BufferUtils.createByteBuffer((int)((int)(1L * (long)Image.Format.RGB8.getBitsPerPixel() / 8L))), ColorSpace.Linear);
        }
        return image;
    }
}

