/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.centralized.api.manager.script;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import org.openide.util.NbBundle;
import rs.co.ast.aspen.api.service.Script;
import rs.co.ast.aspen.api.service.ScriptType;
import rs.co.ast.aspen.gui.module.centralized.api.manager.script.ScriptComparatorByName;
import rs.co.ast.aspen.gui.module.centralized.api.manager.script.ScriptComparatorByOrder;

public class ScriptEditorTableModel
extends AbstractTableModel {
    private List<Script> scripts;
    private final Map<ScriptType, List<Script>> scriptsOfType = new HashMap<ScriptType, List<Script>>();
    private Map<String, Script> changedScripts = new HashMap<String, Script>();

    public List<Script> sortScriptsByOrder(ScriptType type) {
        List<Script> s = this.getScriptsByType(type);
        if (s != null) {
            ArrayList<Script> list = new ArrayList<Script>();
            list.addAll(s);
            this.scripts = list;
            Collections.sort(this.scripts, new ScriptComparatorByOrder());
            this.fireTableDataChanged();
            return list;
        }
        return new ArrayList<Script>();
    }

    public List<Script> sortScriptsByName(ScriptType type) {
        List<Script> s = this.getScriptsByType(type);
        if (s != null) {
            ArrayList<Script> list = new ArrayList<Script>();
            list.addAll(s);
            this.scripts = list;
            Collections.sort(this.scripts, new ScriptComparatorByName());
            this.fireTableDataChanged();
            return list;
        }
        return new ArrayList<Script>();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return Script.class;
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public String getColumnName(int column) {
        return NbBundle.getMessage(ScriptEditorTableModel.class, (String)"ScriptEditorTopComponent.tScripts.col0.title");
    }

    public void setData(Collection<Script> scripts) {
        this.scripts = (List)scripts;
        this.sortByType();
        this.getScriptsByType(ScriptType.ROUTING);
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.scripts != null ? this.scripts.size() : 0;
    }

    public Map<ScriptType, List<Script>> getScriptsOfType() {
        return this.scriptsOfType;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex >= 0 && rowIndex < this.scripts.size()) {
            return this.scripts.get(rowIndex);
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public List<Script> moveDown(int row) {
        ArrayList<Script> list = new ArrayList<Script>();
        if (row < this.scripts.size() - 1) {
            Script script = this.scripts.get(row);
            Script pscript = this.scripts.get(row + 1);
            long order = script.getOrder();
            script.setOrder(pscript.getOrder());
            pscript.setOrder(order);
            this.scripts.set(row, pscript);
            this.scripts.set(row + 1, script);
            list.add(script);
            list.add(pscript);
            this.fireTableDataChanged();
        }
        return list;
    }

    public List<Script> moveUp(int row) {
        ArrayList<Script> list = new ArrayList<Script>();
        if (row > 0) {
            Script script = this.scripts.get(row);
            Script pscript = this.scripts.get(row - 1);
            long order = script.getOrder();
            script.setOrder(pscript.getOrder());
            pscript.setOrder(order);
            this.scripts.set(row, pscript);
            this.scripts.set(row - 1, script);
            list.add(script);
            list.add(pscript);
            this.fireTableDataChanged();
        }
        return list;
    }

    public boolean scriptAlreadyExist(String name, ScriptType type) {
        List<Script> scriptNames = this.scriptsOfType.get(type);
        return scriptNames.stream().anyMatch(script -> script.getName().equals(name));
    }

    private List<Script> getScriptsByType(ScriptType type) {
        this.scripts = this.scriptsOfType.get(type);
        this.fireTableDataChanged();
        return this.scripts;
    }

    private void sortByType() {
        for (ScriptType t : ScriptType.values()) {
            ArrayList<Script> list = new ArrayList<Script>();
            for (Script s : this.scripts) {
                if (!s.getType().equals((Object)t)) continue;
                list.add(s);
            }
            this.scriptsOfType.put(t, list);
        }
    }

    public Map<String, Script> getChangedScripts() {
        return this.changedScripts;
    }

    public void setChangedScripts(Map<String, Script> changedScripts) {
        this.changedScripts = changedScripts;
    }

    public Script getScriptByRow(int row) {
        Script retScript = null;
        if (row >= 0 && row < this.scripts.size()) {
            retScript = this.scripts.get(row);
        }
        return retScript;
    }

    public int getRowByScriptName(String scriptName) {
        int ret = -1;
        for (int i = 0; i < this.scripts.size(); ++i) {
            if (!this.scripts.get(i).getName().equalsIgnoreCase(scriptName)) continue;
            ret = i;
        }
        return ret;
    }

    public List<Script> getAllScripts() {
        return this.scripts;
    }
}

