/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.login;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class LoginPanel
extends JPanel {
    private JButton bResetSettings;
    private JComboBox cbServer;
    private JCheckBox cbSsl;
    private JLabel lPassword;
    private JLabel lServer;
    private JLabel lUsername;
    private JPasswordField pfPassword;
    private JTextField tfUsername;

    public LoginPanel() {
        this.initComponents();
        Preferences p = NbPreferences.forModule(LoginPanel.class);
        this.cbServer.setSelectedItem(p.get("lastUsedServer", (String)this.cbServer.getSelectedItem()));
        this.cbSsl.setSelected(p.getBoolean("use_ssl", true));
    }

    private void initComponents() {
        this.lUsername = new JLabel();
        this.lPassword = new JLabel();
        this.tfUsername = new JTextField();
        this.pfPassword = new JPasswordField();
        this.lServer = new JLabel();
        this.cbServer = new JComboBox();
        this.cbSsl = new JCheckBox();
        this.bResetSettings = new JButton();
        this.setMaximumSize(new Dimension(600, 300));
        this.setMinimumSize(new Dimension(600, 300));
        this.lUsername.setFont(new Font("Dialog", 0, 12));
        this.lUsername.setForeground(new Color(255, 255, 255));
        this.lUsername.setText(NbBundle.getMessage(LoginPanel.class, (String)"LoginPanel.lUsername.text"));
        this.lPassword.setFont(new Font("Dialog", 0, 12));
        this.lPassword.setForeground(new Color(255, 255, 255));
        this.lPassword.setText(NbBundle.getMessage(LoginPanel.class, (String)"LoginPanel.lPassword.text"));
        this.tfUsername.setText(NbBundle.getMessage(LoginPanel.class, (String)"LoginPanel.tfUsername.text"));
        this.pfPassword.setText(NbBundle.getMessage(LoginPanel.class, (String)"LoginPanel.pfPassword.text"));
        this.lServer.setFont(new Font("Dialog", 0, 12));
        this.lServer.setForeground(new Color(255, 255, 255));
        this.lServer.setText(NbBundle.getMessage(LoginPanel.class, (String)"LoginPanel.lServer.text"));
        this.cbServer.setEditable(true);
        this.cbServer.setFont(new Font("Dialog", 0, 12));
        this.cbServer.setModel(this.getServers());
        this.cbSsl.setFont(new Font("Dialog", 0, 12));
        this.cbSsl.setForeground(new Color(255, 255, 255));
        this.cbSsl.setSelected(true);
        this.cbSsl.setText(NbBundle.getMessage(LoginPanel.class, (String)"LoginPanel.cbSsl.text"));
        this.cbSsl.setToolTipText(NbBundle.getMessage(LoginPanel.class, (String)"LoginPanel.cbSsl.toolTipText"));
        this.cbSsl.setOpaque(false);
        this.bResetSettings.setFont(new Font("Dialog", 0, 12));
        this.bResetSettings.setText(NbBundle.getMessage(LoginPanel.class, (String)"LoginPanel.bResetSettings.text"));
        this.bResetSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LoginPanel.this.bResetSettingsActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(112, 112, 112).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.lServer).addComponent(this.lPassword).addComponent(this.lUsername).addComponent(this.tfUsername).addComponent(this.pfPassword).addComponent(this.cbServer, 0, -1, Short.MAX_VALUE).addComponent(this.cbSsl, -2, 230, -2).addComponent(this.bResetSettings)).addContainerGap(258, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(60, 60, 60).addComponent(this.lUsername).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfUsername, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lPassword).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pfPassword, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lServer).addGap(5, 5, 5).addComponent(this.cbServer, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cbSsl).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.bResetSettings).addContainerGap(40, Short.MAX_VALUE)));
    }

    private void bResetSettingsActionPerformed(ActionEvent evt) {
        String user_dir = System.getProperty("netbeans.user");
        this.resetSettings(new File(user_dir));
    }

    private void resetSettings(File dir) {
        if (dir.exists()) {
            for (File f : dir.listFiles()) {
                if (f.isFile()) {
                    f.delete();
                    continue;
                }
                this.resetSettings(f);
            }
            dir.delete();
        }
    }

    private ComboBoxModel getServers() {
        try {
            Preferences p = NbPreferences.forModule(LoginPanel.class);
            ArrayList<String> data = new ArrayList<String>();
            for (String k : p.keys()) {
                if (!k.startsWith("server_")) continue;
                data.add(p.get(k, ""));
            }
            return new DefaultComboBoxModel<Object>(data.toArray());
        }
        catch (BackingStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return new DefaultComboBoxModel();
        }
    }

    public String getUsername() {
        return this.tfUsername.getText();
    }

    public String getPassword() {
        return new String(this.pfPassword.getPassword());
    }

    public String getServer() {
        String item = "";
        if (this.cbServer.getSelectedItem() != null) {
            return (String)this.cbServer.getSelectedItem();
        }
        return item;
    }

    public boolean getSsl() {
        return this.cbSsl.isSelected();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Image img = new ImageIcon(this.getClass().getResource("/background.jpg")).getImage();
        g.drawImage(img, 0, 0, null);
    }
}

