/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.rawlogs;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableModel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import rs.co.ast.aspen.api.service.ApiService;
import rs.co.ast.aspen.api.service.ApiServiceException_Exception;
import rs.co.ast.aspen.api.service.RawLog;
import rs.co.ast.aspen.gui.rawlogs.MetaDataTableModel;

public class ResendEventDialog
extends JDialog {
    private RawLog rawLog;
    private MetaDataTableModel tableModel = new MetaDataTableModel();
    private ApiService apiService = (ApiService)Lookup.getDefault().lookup(ApiService.class);
    private int count = 0;
    private JButton bAddEntry;
    private JButton bClose;
    private JButton bDeleteEntry;
    private JButton bResend;
    private JCheckBox cbWordWrap;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel6;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator2;
    private JLabel lSuccessMessage;
    private JTable tMetadata;
    private JTextArea taText;
    private JTextField tfId;
    private JTextField tfSource;

    public ResendEventDialog(RawLog event) {
        this.initComponents();
        this.setTitle(NbBundle.getMessage(ResendEventDialog.class, (String)"ResendEventDialog.title"));
        this.rawLog = this.deepCopy(event);
        this.tfId.setEditable(false);
        this.tfSource.setText(this.rawLog.getSource());
        this.tfSource.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.setSource();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.setSource();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.setSource();
            }

            private void setSource() {
                ResendEventDialog.this.rawLog.setSource(ResendEventDialog.this.tfSource.getText());
            }
        });
        this.cbWordWrap.setSelected(true);
        this.cbWordWrap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResendEventDialog.this.taText.setLineWrap(ResendEventDialog.this.cbWordWrap.isSelected());
                ResendEventDialog.this.taText.setWrapStyleWord(ResendEventDialog.this.cbWordWrap.isSelected());
            }
        });
        this.taText.setText(this.rawLog.getText());
        this.taText.setLineWrap(this.cbWordWrap.isSelected());
        this.taText.setWrapStyleWord(this.cbWordWrap.isSelected());
        this.taText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.setText();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.setText();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.setText();
            }

            private void setText() {
                ResendEventDialog.this.rawLog.setText(ResendEventDialog.this.taText.getText());
            }
        });
        this.tMetadata.setSelectionMode(0);
        if (this.rawLog.getMetaData() != null) {
            this.tableModel.setData(this.rawLog.getMetaData().getEntry());
            this.tMetadata.setModel(this.tableModel);
        }
    }

    private void setNewId() {
        String id = UUID.randomUUID().toString();
        this.rawLog.setId(id);
        this.tfId.setText(id);
    }

    private RawLog deepCopy(RawLog event) {
        RawLog log = new RawLog();
        log.setSource(event.getSource());
        log.setText(event.getText());
        log.setTimestamp(event.getTimestamp());
        RawLog.MetaData meta = new RawLog.MetaData();
        List entries = event.getMetaData().getEntry();
        ArrayList<RawLog.MetaData.Entry> newEntries = new ArrayList<RawLog.MetaData.Entry>();
        for (RawLog.MetaData.Entry entry : entries) {
            RawLog.MetaData.Entry e = new RawLog.MetaData.Entry();
            e.setKey(entry.getKey());
            e.setValue(entry.getValue());
            newEntries.add(e);
        }
        RawLog.MetaData.Entry e = new RawLog.MetaData.Entry();
        e.setKey("origin");
        e.setValue("synthetic");
        newEntries.add(e);
        meta.getEntry().addAll(newEntries);
        log.setMetaData(meta);
        return log;
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jSeparator2 = new JSeparator();
        this.jScrollPane2 = new JScrollPane();
        this.tMetadata = new JTable();
        this.jLabel3 = new JLabel();
        this.tfId = new JTextField();
        this.bResend = new JButton();
        this.jLabel1 = new JLabel();
        this.tfSource = new JTextField();
        this.jLabel4 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.taText = new JTextArea();
        this.bClose = new JButton();
        this.bAddEntry = new JButton();
        this.bDeleteEntry = new JButton();
        this.cbWordWrap = new JCheckBox();
        this.lSuccessMessage = new JLabel();
        this.setDefaultCloseOperation(2);
        this.jLabel2.setFont(new Font("Dialog", 1, 14));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(ResendEventDialog.class, (String)"ResendEventDialog.jLabel2.text"));
        this.jLabel6.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(ResendEventDialog.class, (String)"ResendEventDialog.jLabel6.text"));
        this.tMetadata.setModel(new DefaultTableModel(new Object[][]{new Object[0], new Object[0], new Object[0], new Object[0]}, new String[0]));
        this.jScrollPane2.setViewportView(this.tMetadata);
        this.jLabel3.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(ResendEventDialog.class, (String)"ResendEventDialog.jLabel3.text"));
        this.tfId.setText(NbBundle.getMessage(ResendEventDialog.class, (String)"ResendEventDialog.tfId.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.bResend, (String)NbBundle.getMessage(ResendEventDialog.class, (String)"ResendEventDialog.bResend.text"));
        this.bResend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ResendEventDialog.this.bResendActionPerformed(evt);
            }
        });
        this.jLabel1.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(ResendEventDialog.class, (String)"ResendEventDialog.jLabel1.text"));
        this.tfSource.setText(NbBundle.getMessage(ResendEventDialog.class, (String)"ResendEventDialog.tfSource.text"));
        this.jLabel4.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(ResendEventDialog.class, (String)"ResendEventDialog.jLabel4.text"));
        this.taText.setColumns(20);
        this.taText.setRows(5);
        this.jScrollPane1.setViewportView(this.taText);
        Mnemonics.setLocalizedText((AbstractButton)this.bClose, (String)NbBundle.getMessage(ResendEventDialog.class, (String)"ResendEventDialog.bClose.text"));
        this.bClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ResendEventDialog.this.bCloseActionPerformed(evt);
            }
        });
        this.bAddEntry.setFont(new Font("Dialog", 0, 12));
        this.bAddEntry.setIcon(new ImageIcon(this.getClass().getResource("/add.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.bAddEntry, (String)NbBundle.getMessage(ResendEventDialog.class, (String)"ResendEventDialog.bAddEntry.text"));
        this.bAddEntry.setContentAreaFilled(false);
        this.bAddEntry.setMaximumSize(new Dimension(18, 18));
        this.bAddEntry.setMinimumSize(new Dimension(18, 18));
        this.bAddEntry.setPreferredSize(new Dimension(18, 18));
        this.bAddEntry.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ResendEventDialog.this.bAddEntryActionPerformed(evt);
            }
        });
        this.bDeleteEntry.setFont(new Font("Dialog", 0, 12));
        this.bDeleteEntry.setIcon(new ImageIcon(this.getClass().getResource("/delete.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.bDeleteEntry, (String)NbBundle.getMessage(ResendEventDialog.class, (String)"ResendEventDialog.bDeleteEntry.text"));
        this.bDeleteEntry.setContentAreaFilled(false);
        this.bDeleteEntry.setMaximumSize(new Dimension(18, 18));
        this.bDeleteEntry.setMinimumSize(new Dimension(18, 18));
        this.bDeleteEntry.setPreferredSize(new Dimension(18, 18));
        this.bDeleteEntry.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ResendEventDialog.this.bDeleteEntryActionPerformed(evt);
            }
        });
        this.cbWordWrap.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((AbstractButton)this.cbWordWrap, (String)NbBundle.getMessage(ResendEventDialog.class, (String)"ResendEventDialog.cbWordWrap.text"));
        this.lSuccessMessage.setFont(new Font("Dialog", 0, 12));
        this.lSuccessMessage.setForeground(new Color(0, 153, 51));
        Mnemonics.setLocalizedText((JLabel)this.lSuccessMessage, (String)NbBundle.getMessage(ResendEventDialog.class, (String)"ResendEventDialog.lSuccessMessage.text"));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator2).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE).addGap(154, 154, 154)).addComponent(this.jScrollPane1).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfId).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfSource, -2, 149, -2)).addComponent(this.jScrollPane2, -1, 576, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.cbWordWrap)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.lSuccessMessage, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.bResend).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bClose)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.bAddEntry, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bDeleteEntry, -2, -1, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator2, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.tfId, -2, -1, -2).addComponent(this.jLabel1).addComponent(this.tfSource, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.cbWordWrap)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 90, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel6).addComponent(this.bAddEntry, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 120, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.lSuccessMessage, GroupLayout.Alignment.TRAILING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.bResend).addComponent(this.bClose))).addGap(19, 19, 19)).addGroup(layout.createSequentialGroup().addComponent(this.bDeleteEntry, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)))));
        this.pack();
    }

    private void bCloseActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.dispose();
    }

    private void bAddEntryActionPerformed(ActionEvent evt) {
        this.tableModel.addEntry();
    }

    private void bResendActionPerformed(ActionEvent evt) {
        try {
            this.lSuccessMessage.setText(" ");
            this.setNewId();
            this.rawLog.setTimestamp(Long.valueOf(System.currentTimeMillis()));
            this.apiService.resendEvent(this.rawLog);
            ++this.count;
            this.lSuccessMessage.setText(String.format("%d %s", this.count, NbBundle.getMessage(ResendEventDialog.class, (String)"ResendEventDialog.resend.success")));
        }
        catch (ApiServiceException_Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void bDeleteEntryActionPerformed(ActionEvent evt) {
        int selectedRow = this.tMetadata.getSelectedRow();
        if (selectedRow >= 0) {
            this.tableModel.deleteEntry(selectedRow);
        } else {
            NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)NbBundle.getMessage(ResendEventDialog.class, (String)"ResendEventDialog.table.noselection"), 1);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
        }
    }
}

