/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.prseditor.actions;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.JFileChooser;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;
import rs.co.ast.aspen.api.service.ApiServiceException_Exception;
import rs.co.ast.aspen.api.service.RuleSetBackupContainerDTO;
import rs.co.ast.aspen.core.module.prsmodel.RuleSetModel;
import rs.co.ast.aspen.gui.module.prseditor.JSONFileFilter;
import rs.co.ast.aspen.gui.module.prseditor.ParsingRulesetEditorTopComponent;
import rs.co.ast.aspen.gui.module.prseditor.nodes.RootNode;

public final class ImportRuleSets
implements ActionListener {
    private final ObjectMapper mapper = new ObjectMapper();
    private RuleSetModel model = (RuleSetModel)Lookup.getDefault().lookup(RuleSetModel.class);
    private final RootNode node;

    public ImportRuleSets(RootNode node) {
        this.node = node;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        NotifyDescriptor.Confirmation d = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(ParsingRulesetEditorTopComponent.class, (String)"ImportRuleSetsConfirmation.message"), NbBundle.getMessage(ParsingRulesetEditorTopComponent.class, (String)"ImportRuleSetsConfirmation.title"), 0);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)d) == NotifyDescriptor.YES_OPTION) {
            this.mapper.getDeserializationConfig().without(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
            JFileChooser openFileDialog = new JFileChooser();
            openFileDialog.setFileFilter(new JSONFileFilter());
            openFileDialog.setAcceptAllFileFilterUsed(false);
            int result = openFileDialog.showOpenDialog(WindowManager.getDefault().getMainWindow());
            if (result == 0) {
                try (FileInputStream is = new FileInputStream(openFileDialog.getSelectedFile());){
                    RuleSetBackupContainerDTO rsbc = (RuleSetBackupContainerDTO)this.mapper.readValue((InputStream)is, RuleSetBackupContainerDTO.class);
                    this.model.importRuleSets(rsbc);
                }
                catch (IOException | ApiServiceException_Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            this.model.clearAllMaps();
            this.node.updateChildren();
        }
    }
}

