/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uihandler;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeSupport;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.netbeans.modules.uihandler.AfterRestartExceptions;
import org.netbeans.modules.uihandler.Installer;
import org.netbeans.modules.uihandler.SlownessData;
import org.netbeans.modules.uihandler.SlownessReporter;
import org.netbeans.modules.uihandler.TimeToFailure;
import org.netbeans.modules.uihandler.api.Controller;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;

public class UIHandler
extends Handler
implements ActionListener,
Runnable,
Callable<JButton> {
    private final boolean exceptionOnly;
    private volatile boolean exiting;
    public static final PropertyChangeSupport SUPPORT = new PropertyChangeSupport(Controller.getDefault());
    static final int MAX_LOGS = 1000;
    static final long MAX_LOGS_SIZE = 0x1400000L;
    private static Task lastRecord = Task.EMPTY;
    private static RequestProcessor FLUSH = new RequestProcessor("Flush UI Logs");
    private static boolean flushOnRecord;
    private static final AtomicInteger recordsToWriteOut;
    private static final int MAX_RECORDS_TO_WRITE_OUT = 1111;
    private final SlownessReporter reporter;
    private final AtomicBoolean someRecordsScheduled = new AtomicBoolean(false);
    private static boolean exceptionHandler;
    private JButton button;

    public static void registerExceptionHandler(boolean enable) {
        exceptionHandler = enable;
    }

    public UIHandler(boolean exceptionOnly) {
        this.setLevel(Level.FINEST);
        this.exceptionOnly = exceptionOnly;
        if (exceptionOnly) {
            this.reporter = null;
            AfterRestartExceptions.report();
        } else {
            this.reporter = new SlownessReporter();
        }
    }

    @Override
    public void publish(LogRecord record) {
        if (record.getLevel().equals(Level.CONFIG) && record.getMessage().startsWith("NotifyExcPanel: ")) {
            Installer.setSelectedExcParams(record.getParameters());
            return;
        }
        if ("KILL_PENDING_TASKS".equals(record.getMessage())) {
            this.exiting = true;
        }
        if (!this.exiting) {
            if ("SCAN_CANCELLED".equals(record.getMessage())) {
                if (this.shouldReportScanCancel()) {
                    class WriteOut
                    implements Runnable {
                        public LogRecord r;

                        WriteOut() {
                        }

                        @Override
                        public void run() {
                            Installer.writeOut(this.r);
                            SUPPORT.firePropertyChange(null, null, null);
                            byte[] profData = (byte[])this.r.getParameters()[2];
                            SlownessData sdata = null;
                            if (profData != null) {
                                sdata = new SlownessData((Long)this.r.getParameters()[1], profData, "background_scan", (String)this.r.getParameters()[3]);
                            }
                            this.r = null;
                            TimeToFailure.logAction();
                            Installer.displaySummary("ERROR_URL", true, false, true, sdata);
                        }
                    }
                    WriteOut wo = new WriteOut();
                    wo.r = record;
                    lastRecord = FLUSH.post((Runnable)wo);
                }
                return;
            }
            if ("SCAN_CANCELLED_EARLY".equals(record.getMessage())) {
                NotifyDescriptor nd = new NotifyDescriptor((Object)NbBundle.getMessage(UIHandler.class, (String)"MSG_SCAN_CANCELLED_EARLY"), NbBundle.getMessage(UIHandler.class, (String)"TITLE_SCAN_CANCELLED_EARLY"), -1, 1, new Object[]{DialogDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION);
                DialogDisplayer.getDefault().notify(nd);
                return;
            }
        }
        if (this.exceptionOnly) {
            if (record.getThrown() == null) {
                return;
            }
            if (!exceptionHandler) {
                return;
            }
            if (AfterRestartExceptions.willSchedule(record)) {
                this.someRecordsScheduled.set(true);
                boolean scheduled = AfterRestartExceptions.schedule(record);
                if (!scheduled) {
                    this.someRecordsScheduled.set(false);
                }
            } else {
                this.someRecordsScheduled.set(false);
            }
        } else if (record.getLevel().equals(Level.CONFIG) && record.getMessage().equals("Slowness detected")) {
            String slownessType;
            Object[] params = record.getParameters();
            byte[] nps = (byte[])params[0];
            long time = (Long)params[1];
            String string = slownessType = params.length > 2 ? params[2].toString() : null;
            assert (nps != null) : "nps param should be not null";
            assert (nps.length > 0) : "nps param should not be empty";
            this.reporter.notifySlowness(nps, time, record.getMillis(), slownessType);
            return;
        }
        if (Installer.isImmediateWriteOut(record)) {
            return;
        }
        class WriteOut
        implements Runnable {
            public LogRecord r;

            WriteOut() {
            }

            @Override
            public void run() {
                recordsToWriteOut.decrementAndGet();
                Installer.writeOut(this.r);
                SUPPORT.firePropertyChange(null, null, null);
                this.r = null;
                TimeToFailure.logAction();
            }
        }
        WriteOut wo = new WriteOut();
        wo.r = record;
        recordsToWriteOut.incrementAndGet();
        lastRecord = FLUSH.post((Runnable)wo);
        if (flushOnRecord || recordsToWriteOut.get() > 1111) {
            UIHandler.waitFlushed(true);
        }
    }

    @Override
    public void flush() {
        UIHandler.waitFlushed();
    }

    static void flushImmediatelly() {
        flushOnRecord = true;
    }

    static void waitFlushed() {
        UIHandler.waitFlushed(false);
    }

    private static void waitFlushed(boolean forced) {
        if (!forced) assert (!SwingUtilities.isEventDispatchThread()) : "Must not wait in AWT here";
        try {
            lastRecord.waitFinished(0L);
        }
        catch (InterruptedException ex) {
            Installer.LOG.log(Level.FINE, null, ex);
        }
    }

    boolean isExceptionOnly() {
        return this.exceptionOnly;
    }

    @Override
    public void close() throws SecurityException {
    }

    @Override
    public void run() {
        Installer.displaySummary("ERROR_URL", true, false, true);
        Installer.setSelectedExcParams(null);
    }

    @Override
    public JButton call() throws Exception {
        if (this.someRecordsScheduled.getAndSet(false)) {
            return null;
        }
        if (this.button == null) {
            this.button = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)this.button, (String)NbBundle.getMessage(UIHandler.class, (String)"MSG_SubmitButton"));
            this.button.addActionListener(this);
        }
        return this.button;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        JComponent c = (JComponent)ev.getSource();
        Window w = SwingUtilities.windowForComponent(c);
        if (w != null) {
            w.dispose();
        }
        Installer.RP.post((Runnable)this);
    }

    private boolean shouldReportScanCancel() {
        JButton sendOption = new JButton(NbBundle.getMessage(UIHandler.class, (String)"LBL_SendReport"));
        JButton sendAndProfileOption = new JButton(NbBundle.getMessage(UIHandler.class, (String)"LBL_SendReportAndProfile"));
        NotifyDescriptor nd = System.getProperty("org.netbeans.modules.parsing.impl.indexing.RepositoryUpdater.indexerSampling") == null ? new NotifyDescriptor((Object)NbBundle.getMessage(UIHandler.class, (String)"MSG_SCAN_CANCELLED2"), NbBundle.getMessage(UIHandler.class, (String)"TITLE_SCAN_CANCELLED"), 1, 3, new Object[]{sendOption, sendAndProfileOption, DialogDescriptor.CANCEL_OPTION}, (Object)sendOption) : new NotifyDescriptor((Object)NbBundle.getMessage(UIHandler.class, (String)"MSG_SCAN_CANCELLED"), NbBundle.getMessage(UIHandler.class, (String)"TITLE_SCAN_CANCELLED"), 1, 3, new Object[]{sendOption, DialogDescriptor.CANCEL_OPTION}, (Object)sendOption);
        Object opt = DialogDisplayer.getDefault().notify(nd);
        if (opt == sendAndProfileOption) {
            System.setProperty("org.netbeans.modules.parsing.impl.indexing.RepositoryUpdater.indexerSampling", "true");
        }
        return opt == sendAndProfileOption || opt == sendOption;
    }

    void publishEarlyRecords(List<LogRecord> earlyRecords) {
        for (LogRecord r : earlyRecords) {
            this.publish(r);
        }
    }

    static {
        recordsToWriteOut = new AtomicInteger(0);
    }
}

