/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.securityevents;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingWorker;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableRowSorter;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jdesktop.swingx.JXBusyLabel;
import org.jdesktop.swingx.JXCollapsiblePane;
import org.jfree.chart.ChartMouseEvent;
import org.jfree.chart.ChartMouseListener;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.entity.ChartEntity;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.data.time.SimpleTimePeriod;
import org.jfree.data.time.TimePeriod;
import org.jfree.data.time.TimeTableXYDataset;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;
import rs.co.ast.aspen.api.service.ApiService;
import rs.co.ast.aspen.api.service.ApiServiceException_Exception;
import rs.co.ast.aspen.api.service.DateRange;
import rs.co.ast.aspen.api.service.SavedQueryData;
import rs.co.ast.aspen.api.service.SavedQueryDataType;
import rs.co.ast.aspen.api.service.ScriptType;
import rs.co.ast.aspen.api.service.SearchState;
import rs.co.ast.aspen.gui.module.securityevents.AutoCompleteDecorator;
import rs.co.ast.aspen.gui.module.securityevents.DisplayOptions;
import rs.co.ast.aspen.gui.module.securityevents.DisplayOptionsDisplayer;
import rs.co.ast.aspen.gui.module.securityevents.QuerySetNamePanel;
import rs.co.ast.aspen.gui.module.securityevents.SavedQueryDataDialog;
import rs.co.ast.aspen.gui.module.securityevents.SecurityEventDetailsTopComponent;
import rs.co.ast.aspen.gui.module.securityevents.SecurityEventsTopComponent;
import rs.co.ast.aspen.gui.module.securityevents.SimpleHistoricalCorrelationPanel;
import rs.co.ast.aspen.gui.module.securityevents.analysis.FieldsExtractor;
import rs.co.ast.aspen.gui.module.securityevents.analysis.FieldsTableModel;
import rs.co.ast.aspen.gui.module.securityevents.analysis.InMemoryDatabase;
import rs.co.ast.aspen.gui.module.securityevents.analysis.ResultTableModel;
import rs.co.ast.aspen.gui.module.securityevents.analysis.TableColumnResizer;
import rs.co.ast.aspen.gui.module.securityevents.analysis.TableTransferHandler;
import rs.co.ast.aspen.gui.module.securityevents.query.QueryManager;
import rs.co.ast.aspen.gui.module.securityevents.query.TopComponentTitleShortener;
import rs.co.ast.aspen.gui.module.securityevents.search.SearchExecutor;
import rs.co.ast.aspen.gui.module.securityevents.search.SkippedTaskInfo;
import rs.co.ast.aspen.gui.module.securityevents.search.TaskMonitor;
import rs.co.ast.chart.FrontCountBarChart;
import rs.co.ast.chart.MyStackedXYBarRenderer;

@TopComponent.Description(preferredID="AnalysisTopComponent", iconBase="chart_bar.png", persistenceType=1)
public final class AnalysisTopComponent
extends TopComponent
implements PropertyChangeListener {
    private final ApiService apiService = (ApiService)Lookup.getDefault().lookup(ApiService.class);
    private static final Logger LOGGER = Logger.getLogger(AnalysisTopComponent.class.getName());
    private DisplayOptions displayOptions = new DisplayOptions();
    private final Timer autoRefreshTimer;
    private SearchExecutor searchExecutor;
    private SavedQueryData queryData;
    private AutoCompleteDecorator autoCompleteDecorator = new AutoCompleteDecorator();
    private DateTimeFormatter isoTimeFormat = ISODateTimeFormat.dateTime().withZone(DateTimeZone.getDefault());
    private String undoQuery = "";
    private InMemoryDatabase memDB = (InMemoryDatabase)Lookup.getDefault().lookup(InMemoryDatabase.class);
    private FieldsTableModel fieldsTableModel = (FieldsTableModel)Lookup.getDefault().lookup(FieldsTableModel.class);
    private final TableRowSorter sorter = new TableRowSorter<FieldsTableModel>(this.fieldsTableModel);
    private ResultTableModel resultTableModel = (ResultTableModel)Lookup.getDefault().lookup(ResultTableModel.class);
    private final Collection<? extends Action> sqlFunctionActions = Lookups.forPath((String)"SQLFunctionsPopupMenu/SQLFunctions").lookupAll(Action.class);
    private Dialog dialog;
    private FrontCountBarChart countChart;
    private ChartMouseListener chartMouseListener;
    private String previousQuery = "previousQuery";
    private JButton bDisplayOptions;
    private JButton bExport;
    private JButton bQueryBookmarks;
    private JButton bSearch;
    private JButton bShowSimpleHistoricalCorrelation;
    private JToggleButton btQueryBookmarked;
    private JXCollapsiblePane cpChart;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JXBusyLabel lLoading;
    private JLabel lQueryTime;
    private JLabel lSearchStatus;
    private JPanel pChart;
    private JPopupMenu pmColumns;
    private JPopupMenu pmSQLFunctions;
    private JSplitPane spWrapper;
    private JTable tFields;
    private JTable tResults;
    private JTextField tfFilter;
    private JTextField tfSearch;

    public AnalysisTopComponent() {
        this.displayOptions.load();
        this.displayOptions.setIsDescToggleButtonVisible(false);
        this.initComponents();
        this.setName(NbBundle.getMessage(AnalysisTopComponent.class, (String)"CTL_AnalysisTopComponent"));
        this.setToolTipText(NbBundle.getMessage(AnalysisTopComponent.class, (String)"HINT_AnalysisTopComponent"));
        this.bSearch.setForeground(Color.red);
        this.spWrapper.setDividerLocation(0.5);
        this.tfSearch.setColumns(1);
        this.lQueryTime.setCursor(new Cursor(12));
        this.lQueryTime.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                String query = QueryManager.makeQueryTimeQuery(AnalysisTopComponent.this.displayOptions.getTimeStart(), AnalysisTopComponent.this.displayOptions.getTimeFinish(), AnalysisTopComponent.this.isoTimeFormat);
                AnalysisTopComponent.this.tfSearch.setText(query);
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.tfSearch.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 && !AnalysisTopComponent.this.autoCompleteDecorator.isGuessing()) {
                    AnalysisTopComponent.this.startSearch();
                } else {
                    AnalysisTopComponent.this.btQueryBookmarked.setSelected(false);
                }
            }
        });
        ActionListener undoListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnalysisTopComponent.this.tfSearch.setText(AnalysisTopComponent.this.undoQuery);
            }
        };
        KeyStroke strokeUndo = KeyStroke.getKeyStroke(90, 2, false);
        this.tfSearch.registerKeyboardAction(undoListener, "Undo", strokeUndo, 0);
        KeyListener undoKeyListener = new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
                switch (e.getKeyChar()) {
                    case ' ': 
                    case '\"': 
                    case '(': 
                    case ')': 
                    case '+': 
                    case '-': 
                    case ':': 
                    case '[': 
                    case ']': {
                        AnalysisTopComponent.this.updateUndoQuery();
                    }
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        };
        this.tfSearch.addKeyListener(undoKeyListener);
        this.displayOptions.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                AnalysisTopComponent.this.displayOptions.save();
                if (AnalysisTopComponent.this.displayOptions.getAutoRefresh() == 0) {
                    AnalysisTopComponent.this.stopAutoRefreshTimer();
                } else {
                    AnalysisTopComponent.this.startAutoRefreshTimer();
                }
                AnalysisTopComponent.this.startSearch();
            }
        });
        this.autoRefreshTimer = new Timer(this.displayOptions.getAutoRefresh(), new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AnalysisTopComponent.this.startSearch();
            }
        });
        for (Action action : this.sqlFunctionActions) {
            this.pmSQLFunctions.add(action);
        }
        this.tFields.setAutoResizeMode(0);
        this.tFields.setSelectionMode(1);
        this.tFields.setCellSelectionEnabled(true);
        this.tFields.setModel(this.fieldsTableModel);
        this.tFields.setRowSorter(this.sorter);
        this.tFields.setTransferHandler(new TableTransferHandler());
        this.tFields.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 3) {
                    int row = AnalysisTopComponent.this.tFields.rowAtPoint(e.getPoint());
                    int column = AnalysisTopComponent.this.tFields.columnAtPoint(e.getPoint());
                    if (row > -1 && column > -1) {
                        AnalysisTopComponent.this.tFields.setRowSelectionInterval(row, row);
                        AnalysisTopComponent.this.tFields.setColumnSelectionInterval(column, column);
                    }
                    AnalysisTopComponent.this.tFields.changeSelection(row, column, false, false);
                    AnalysisTopComponent.this.pmSQLFunctions.show(e.getComponent(), e.getX(), e.getY());
                    AnalysisTopComponent.this.fieldsTableModel.setNewlyAddedColumn(AnalysisTopComponent.this.fieldsTableModel.getColumn(column));
                } else {
                    int selectedRow = AnalysisTopComponent.this.tFields.getSelectedRow();
                    int selectedColumn = AnalysisTopComponent.this.tFields.getSelectedColumn();
                    if (selectedRow > -1 && selectedColumn > -1) {
                        AnalysisTopComponent.this.fieldsTableModel.setNewlyAddedColumn(AnalysisTopComponent.this.fieldsTableModel.getColumn(selectedColumn));
                    }
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.tFields.getTableHeader().addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getButton() == 3) {
                    AnalysisTopComponent.this.pmColumns.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.tfFilter.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.filter();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.filter();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.filter();
            }

            private void filter() {
                AnalysisTopComponent.this.memDB.filter(AnalysisTopComponent.this.tfFilter.getText());
            }
        });
        this.tResults.setAutoResizeMode(0);
        this.tResults.setSelectionMode(1);
        this.tResults.setCellSelectionEnabled(true);
        this.tResults.setAutoCreateRowSorter(true);
        this.tResults.setModel(this.resultTableModel);
        this.tResults.setTransferHandler(new TableTransferHandler());
        this.tResults.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                if (AnalysisTopComponent.this.resultTableModel.getColumnCount() > 0) {
                    TableRowSorter rowSorter = (TableRowSorter)AnalysisTopComponent.this.tResults.getRowSorter();
                    ArrayList<RowSorter.SortKey> keys = new ArrayList<RowSorter.SortKey>();
                    RowSorter.SortKey sortKey = new RowSorter.SortKey(0, SortOrder.DESCENDING);
                    keys.add(sortKey);
                    rowSorter.setSortKeys(keys);
                    rowSorter.sort();
                    TableColumnResizer.adjustColumnPreferredWidths(AnalysisTopComponent.this.tResults);
                }
            }
        });
        this.cpChart.setLayout((LayoutManager)new BorderLayout());
        this.cpChart.add((Component)this.pChart, (Object)"Center");
        this.chartMouseListener = new ChartMouseListener(){

            public void chartMouseClicked(ChartMouseEvent event) {
                ChartEntity entity = event.getEntity();
                if (entity instanceof XYItemEntity) {
                    AnalysisTopComponent.this.pmColumns.removeAll();
                    AnalysisTopComponent.this.memDB.dispose();
                    AnalysisTopComponent.this.fieldsTableModel.resetData();
                    XYItemEntity item = (XYItemEntity)event.getEntity();
                    AnalysisTopComponent.this.countChart.getMyBarRenderer().resetSelectedItems();
                    AnalysisTopComponent.this.countChart.getMyBarRenderer().addSelectedItem(item.getItem());
                    List<DateRange> ranges = AnalysisTopComponent.this.searchExecutor.getSearchContext().getDateRanges();
                    DateRange dateRange = ranges.get(item.getItem());
                    AnalysisTopComponent.this.searchExecutor.setSelectedDateRange(dateRange);
                    AnalysisTopComponent.this.searchExecutor.getSearchContext().getSearchResults().getEvents().clear();
                    AnalysisTopComponent.this.fetch(dateRange);
                }
            }

            public void chartMouseMoved(ChartMouseEvent event) {
            }
        };
        this.tfSearch.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changeButtonColor();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changeButtonColor();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.changeButtonColor();
            }

            private void changeButtonColor() {
                if (AnalysisTopComponent.this.previousQuery.equals(AnalysisTopComponent.this.tfSearch.getText())) {
                    AnalysisTopComponent.this.bSearch.setForeground(Color.black);
                } else {
                    AnalysisTopComponent.this.bSearch.setForeground(Color.red);
                }
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        switch (evt.getPropertyName()) {
            case "PROP_TOTAL_HITS": {
                this.updateCountSearchStatus();
                break;
            }
            case "PROP_EVENTS": {
                if (!this.searchExecutor.getSearchContext().getTaskMonitor().isAllTasksCompleted()) break;
                List<String> columns = this.initColumnPopupMenu();
                this.memDB.initDB(this.searchExecutor.getSearchContext().getSearchResults().getEvents(), columns);
                this.resultTableModel.resetDataKeepColumns();
                List<String> columnNames = this.resultTableModel.getColumnNames();
                if (columnNames.isEmpty()) break;
                boolean containsAll = columns.containsAll(columnNames.subList(1, columnNames.size() - 1));
                if (containsAll) {
                    List<Map<String, String>> results = this.memDB.executeCountQuery(columnNames);
                    this.resultTableModel.setData(results);
                    break;
                }
                this.resultTableModel.resetData();
                break;
            }
            case "PROP_COUNT_TASK_FINISHED": {
                this.updateCountSearchStatus();
                this.pChart.removeAll();
                if (this.searchExecutor.getSearchContext().getIndexDateIntervals().size() > 1) {
                    this.pChart.add((Component)this.createChart(this.createDataset()));
                    if (this.cpChart.isCollapsed()) {
                        this.cpChart.setCollapsed(false);
                    }
                } else {
                    List<DateRange> ranges = this.searchExecutor.getSearchContext().getDateRanges();
                    this.searchExecutor.setSelectedDateRange(ranges.get(0));
                }
                this.fetch((DateRange)evt.getNewValue());
                break;
            }
            case "PROP_FETCH_TASK_FINISHED": {
                this.updateCountSearchStatus();
                try {
                    this.searchExecutor.count();
                }
                catch (ApiServiceException_Exception ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                break;
            }
            case "PROP_COUNT_TASK_FINISHED_SUCCESS": {
                if (!this.searchExecutor.getSearchContext().getTaskMonitor().isAllCountTasksCompleted() || this.countChart == null) break;
                List<DateRange> dateRanges = this.searchExecutor.getSearchContext().getDateRanges();
                DateRange dt = (DateRange)evt.getNewValue();
                this.countChart.getMyBarRenderer().removeFailedItem(dateRanges.indexOf(dt));
                break;
            }
            case "PROP_COUNT_TASK_SKIPPED": {
                SkippedTaskInfo sti = (SkippedTaskInfo)evt.getNewValue();
                LOGGER.info(String.format("Date Range skipped: s: %s, f: %s", new DateTime(sti.getStartTimeStamp()), new DateTime(sti.getFinishTimeStamp())));
                if (this.searchExecutor.getSearchContext().getTaskMonitor().isAllCountTasksCompleted()) {
                    this.searchExecutor.submitSkippedTaskWithBackoff(TaskMonitor.BaseTaskName.COUNT.getBaseTaskName(), sti);
                } else {
                    this.searchExecutor.addTaskToSkippedTask(sti);
                }
                if (this.countChart == null) break;
                List<DateRange> dateRanges = this.searchExecutor.getSearchContext().getDateRanges();
                DateRange dt = sti.getDateRange();
                this.countChart.getMyBarRenderer().addFailedItem(dateRanges.indexOf(dt));
                break;
            }
            case "PROP_ALL_COUNT_TASKS_FINISHED": {
                LOGGER.info("PROP_ALL_COUNT_TASKS_FINISHED");
                List<SkippedTaskInfo> tasks = this.searchExecutor.getSearchContext().getSkippedTasks();
                for (SkippedTaskInfo ski : tasks) {
                    this.searchExecutor.submitSkippedTaskWithBackoff(TaskMonitor.BaseTaskName.COUNT.getBaseTaskName(), ski);
                }
                this.searchExecutor.getSearchContext().getSkippedTasks().clear();
                break;
            }
            case "PROP_ALL_SKIPPED_COUNT_TASKS_FINISHED": {
                LOGGER.info("PROP_ALL_SKIPPED_COUNT_TASKS_FINISHED");
            }
            case "PROP_ALL_FETCH_TASKS_FINISHED": {
                LOGGER.info("PROP_ALL_FETCH_TASKS_FINISHED");
                break;
            }
            case "PROP_ALL_TASKS_FINISHED": {
                this.updateCountSearchStatus();
                if (this.countChart != null) {
                    this.countChart.getChartPanel().addChartMouseListener(this.chartMouseListener);
                }
                List<String> columns = this.initColumnPopupMenu();
                this.memDB.initDB(this.searchExecutor.getSearchContext().getSearchResults().getEvents(), columns);
                this.resultTableModel.resetData();
                this.lLoading.setBusy(false);
                LOGGER.info("ALL TASKS ARE COMPLETED");
                this.searchExecutor.getSearchContext().getSearchResults().setAccumulateTotalDuration(false);
                break;
            }
            case "PROP_FETCH_TASK_FAILED": 
            case "PROP_COUNT_TASK_FAILED": {
                this.updateCountSearchStatus();
                List errors = (List)evt.getNewValue();
                LOGGER.info(String.format("TASK FAILED: %s", errors));
                this.lLoading.setBusy(false);
                this.searchExecutor.shutdown();
                break;
            }
            case "PROP_FETCH_TASK_FINISHED_SUCCESS": {
                if (this.countChart == null || this.searchExecutor.getSearchContext().getTaskMonitor().isAllTasksCompleted()) break;
                DateRange dateRange = (DateRange)evt.getNewValue();
                List<DateRange> ranges = this.searchExecutor.getSearchContext().getDateRanges();
                int index = ranges.indexOf(dateRange);
                this.searchExecutor.setSelectedDateRange(ranges.get(index));
                this.countChart.getMyBarRenderer().addSelectedItem(index);
                this.countChart.updateChart(this.createDataset());
                this.countChart.getChartPanel().repaint();
                this.pChart.invalidate();
                this.pChart.repaint();
            }
        }
    }

    private List<String> initColumnPopupMenu() {
        List<String> columns = FieldsExtractor.getColumns(this.searchExecutor.getSearchContext().getSearchResults().getEvents());
        for (String col : columns) {
            JCheckBoxMenuItem cbmi = new JCheckBoxMenuItem(col, true);
            cbmi.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JCheckBoxMenuItem cmi = (JCheckBoxMenuItem)e.getSource();
                    if (cmi.getState()) {
                        AnalysisTopComponent.this.fieldsTableModel.addColumn(cmi.getText());
                    } else {
                        AnalysisTopComponent.this.fieldsTableModel.removeColumn(cmi.getText());
                    }
                }
            });
            this.pmColumns.add(cbmi);
        }
        return columns;
    }

    private void startAutoRefreshTimer() {
        if (this.displayOptions.getAutoRefresh() > 0) {
            this.autoRefreshTimer.setInitialDelay(this.displayOptions.getAutoRefresh() * 1000 * 60);
            this.autoRefreshTimer.setDelay(this.displayOptions.getAutoRefresh() * 1000 * 60);
            this.autoRefreshTimer.setRepeats(true);
            this.autoRefreshTimer.start();
        }
    }

    private void stopAutoRefreshTimer() {
        this.autoRefreshTimer.stop();
    }

    private void updateUndoQuery() {
        this.undoQuery = this.tfSearch.getText();
    }

    private void initComponents() {
        this.pmSQLFunctions = new JPopupMenu();
        this.pmColumns = new JPopupMenu();
        this.pChart = new JPanel();
        this.tfSearch = new JTextField();
        this.bSearch = new JButton();
        this.bDisplayOptions = new JButton();
        this.bQueryBookmarks = new JButton();
        this.btQueryBookmarked = new JToggleButton();
        this.lQueryTime = new JLabel();
        this.lSearchStatus = new JLabel();
        this.spWrapper = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.tfFilter = new JTextField();
        this.bExport = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.tFields = new JTable();
        this.jPanel2 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.tResults = new JTable();
        this.bShowSimpleHistoricalCorrelation = new JButton();
        this.lLoading = new JXBusyLabel();
        this.cpChart = new JXCollapsiblePane();
        this.pChart.setMaximumSize(new Dimension(Integer.MAX_VALUE, 100));
        this.pChart.setMinimumSize(new Dimension(0, 100));
        this.pChart.setPreferredSize(new Dimension(0, 100));
        this.pChart.setLayout(new BorderLayout());
        this.tfSearch.setText(NbBundle.getMessage(AnalysisTopComponent.class, (String)"AnalysisTopComponent.tfSearch.text", (Object[])new Object[0]));
        this.bSearch.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((AbstractButton)this.bSearch, (String)NbBundle.getMessage(AnalysisTopComponent.class, (String)"AnalysisTopComponent.bSearch.text"));
        this.bSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnalysisTopComponent.this.bSearchActionPerformed(evt);
            }
        });
        this.bDisplayOptions.setIcon(new ImageIcon(this.getClass().getResource("/wrench_orange.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.bDisplayOptions, (String)NbBundle.getMessage(AnalysisTopComponent.class, (String)"AnalysisTopComponent.bDisplayOptions.text"));
        this.bDisplayOptions.setToolTipText(NbBundle.getMessage(AnalysisTopComponent.class, (String)"AnalysisTopComponent.bDisplayOptions.toolTipText"));
        this.bDisplayOptions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnalysisTopComponent.this.bDisplayOptionsActionPerformed(evt);
            }
        });
        this.bQueryBookmarks.setIcon(new ImageIcon(this.getClass().getResource("/folder_star.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.bQueryBookmarks, (String)NbBundle.getMessage(AnalysisTopComponent.class, (String)"AnalysisTopComponent.bQueryBookmarks.text"));
        this.bQueryBookmarks.setToolTipText(NbBundle.getMessage(AnalysisTopComponent.class, (String)"AnalysisTopComponent.bQueryBookmarks.toolTipText"));
        this.bQueryBookmarks.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnalysisTopComponent.this.bQueryBookmarksActionPerformed(evt);
            }
        });
        this.btQueryBookmarked.setIcon(new ImageIcon(this.getClass().getResource("/star.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.btQueryBookmarked, (String)NbBundle.getMessage(AnalysisTopComponent.class, (String)"AnalysisTopComponent.btQueryBookmarked.text"));
        this.btQueryBookmarked.setToolTipText(NbBundle.getMessage(AnalysisTopComponent.class, (String)"AnalysisTopComponent.btQueryBookmarked.toolTipText"));
        this.btQueryBookmarked.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnalysisTopComponent.this.btQueryBookmarkedActionPerformed(evt);
            }
        });
        this.lQueryTime.setFont(new Font("Dialog", 0, 12));
        this.lQueryTime.setHorizontalAlignment(4);
        Mnemonics.setLocalizedText((JLabel)this.lQueryTime, (String)NbBundle.getMessage(AnalysisTopComponent.class, (String)"AnalysisTopComponent.lQueryTime.text"));
        this.lSearchStatus.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((JLabel)this.lSearchStatus, (String)NbBundle.getMessage(AnalysisTopComponent.class, (String)"AnalysisTopComponent.lSearchStatus.text", (Object[])new Object[]{0, 0}));
        this.spWrapper.setDividerLocation(220);
        this.spWrapper.setOrientation(0);
        this.spWrapper.setResizeWeight(0.5);
        this.jLabel1.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(AnalysisTopComponent.class, (String)"AnalysisTopComponent.jLabel1.text"));
        this.tfFilter.setText(NbBundle.getMessage(AnalysisTopComponent.class, (String)"AnalysisTopComponent.tfFilter.text"));
        this.bExport.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((AbstractButton)this.bExport, (String)NbBundle.getMessage(AnalysisTopComponent.class, (String)"AnalysisTopComponent.bExport.text"));
        this.bExport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnalysisTopComponent.this.bExportActionPerformed(evt);
            }
        });
        this.tFields.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.jScrollPane1.setViewportView(this.tFields);
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 837, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfFilter).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bExport))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.tfFilter, -2, -1, -2).addComponent(this.bExport)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 178, Short.MAX_VALUE).addContainerGap()));
        this.spWrapper.setTopComponent(this.jPanel1);
        this.jLabel2.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(AnalysisTopComponent.class, (String)"AnalysisTopComponent.jLabel2.text"));
        this.tResults.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.jScrollPane2.setViewportView(this.tResults);
        Mnemonics.setLocalizedText((AbstractButton)this.bShowSimpleHistoricalCorrelation, (String)NbBundle.getMessage(AnalysisTopComponent.class, (String)"AnalysisTopComponent.bShowSimpleHistoricalCorrelation.text"));
        this.bShowSimpleHistoricalCorrelation.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AnalysisTopComponent.this.bShowSimpleHistoricalCorrelationActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane2, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel2, GroupLayout.Alignment.TRAILING, -1, 837, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.bShowSimpleHistoricalCorrelation))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane2, -1, 194, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bShowSimpleHistoricalCorrelation).addGap(6, 6, 6)));
        this.spWrapper.setRightComponent(this.jPanel2);
        Mnemonics.setLocalizedText((JLabel)this.lLoading, (String)NbBundle.getMessage(AnalysisTopComponent.class, (String)"AnalysisTopComponent.lLoading.text"));
        this.cpChart.setCollapsed(true);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent((Component)this.cpChart, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent((Component)this.lLoading, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfSearch).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bSearch).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bQueryBookmarks, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btQueryBookmarked, -2, 30, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bDisplayOptions, -2, 30, -2)).addGroup(layout.createSequentialGroup().addComponent(this.lSearchStatus, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.lQueryTime)).addComponent(this.spWrapper, GroupLayout.Alignment.LEADING)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.bSearch, -1, -1, Short.MAX_VALUE).addComponent(this.bDisplayOptions, -1, -1, Short.MAX_VALUE).addComponent(this.bQueryBookmarks, -1, -1, Short.MAX_VALUE).addComponent(this.btQueryBookmarked, -1, -1, Short.MAX_VALUE).addComponent((Component)this.lLoading, -1, -1, Short.MAX_VALUE).addComponent(this.tfSearch)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lQueryTime).addComponent(this.lSearchStatus)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent((Component)this.cpChart, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.spWrapper).addContainerGap()));
    }

    private void bSearchActionPerformed(ActionEvent evt) {
        this.startSearch();
    }

    private void bDisplayOptionsActionPerformed(ActionEvent evt) {
        DisplayOptionsDisplayer.display(this.displayOptions);
    }

    private void btQueryBookmarkedActionPerformed(ActionEvent evt) {
        try {
            if (this.btQueryBookmarked.isSelected() && !this.tfSearch.getText().isEmpty()) {
                final QuerySetNamePanel panel = new QuerySetNamePanel();
                DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getMessage(AnalysisTopComponent.class, (String)"SetQueryName.dialog.title"), true, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int opt = (Integer)e.getSource();
                        if (DialogDescriptor.OK_OPTION.equals(opt)) {
                            SavedQueryData q = new SavedQueryData();
                            q.setName(panel.getTypedName());
                            q.setQuery(AnalysisTopComponent.this.tfSearch.getText());
                            q.setType(SavedQueryDataType.SECURITY_EVENTS_QUERY);
                            q.setId(DigestUtils.md5Hex((String)String.format("%s%s", q.getQuery(), q.getType())));
                            try {
                                AnalysisTopComponent.this.apiService.saveSavedQuery(q);
                            }
                            catch (ApiServiceException_Exception ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                    }
                });
                DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
            } else if (this.queryData != null) {
                this.apiService.deleteSavedQuery(this.queryData.getId());
            }
        }
        catch (ApiServiceException_Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void bQueryBookmarksActionPerformed(ActionEvent evt) {
        ArrayList<SavedQueryData> queries;
        try {
            queries = this.apiService.getSecurityEventQueries();
        }
        catch (ApiServiceException_Exception ex) {
            queries = new ArrayList<SavedQueryData>();
            Exceptions.printStackTrace((Throwable)ex);
        }
        final SavedQueryDataDialog dialog = new SavedQueryDataDialog();
        dialog.setData(queries);
        dialog.setLocationRelativeTo(WindowManager.getDefault().getMainWindow());
        dialog.setVisible(true);
        dialog.setDefaultCloseOperation(2);
        dialog.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
                SavedQueryData selectedQueryBookmark = dialog.getSelectedQueryBookmark();
                if (selectedQueryBookmark != null) {
                    AnalysisTopComponent.this.queryData = selectedQueryBookmark;
                    AnalysisTopComponent.this.tfSearch.setText(dialog.getSelectedQueryBookmark().getQuery());
                    AnalysisTopComponent.this.btQueryBookmarked.setSelected(true);
                    AnalysisTopComponent.this.startSearch();
                }
            }
        });
    }

    private void bExportActionPerformed(ActionEvent evt) {
        SwingWorker<XSSFWorkbook, Void> sw = new SwingWorker<XSSFWorkbook, Void>(){
            private ProgressHandle ph = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(SecurityEventsTopComponent.class, (String)"SecurityEventsTopComponent.Statistics.export.progress.title"));

            @Override
            protected XSSFWorkbook doInBackground() throws Exception {
                AnalysisTopComponent.this.bExport.setEnabled(false);
                this.ph.start();
                this.ph.switchToIndeterminate();
                XSSFWorkbook wb = new XSSFWorkbook();
                XSSFSheet sheet = wb.createSheet("Analysis");
                XSSFRow titleRow = sheet.createRow(0);
                for (int i = 0; i < AnalysisTopComponent.this.fieldsTableModel.getColumnCount(); ++i) {
                    String columnName = AnalysisTopComponent.this.fieldsTableModel.getColumnName(i);
                    XSSFCell titleCell = titleRow.createCell(i);
                    titleCell.setCellValue(columnName);
                }
                int rowCount = 1;
                int colCount = 0;
                List<LinkedHashMap<String, String>> data = AnalysisTopComponent.this.memDB.selectDataForExport(AnalysisTopComponent.this.fieldsTableModel.getColumnNames());
                for (Map map : data) {
                    XSSFRow row = sheet.createRow(rowCount++);
                    colCount = 0;
                    for (String value : map.values()) {
                        XSSFCell cell = row.createCell(colCount++);
                        cell.setCellValue(value);
                    }
                }
                for (int i = 0; i < AnalysisTopComponent.this.fieldsTableModel.getColumnCount(); ++i) {
                    sheet.autoSizeColumn(i);
                }
                return wb;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void done() {
                block17: {
                    try {
                        XSSFWorkbook wb = (XSSFWorkbook)this.get();
                        String fileName = this.genFileName();
                        JFileChooser saveDialog = new JFileChooser();
                        saveDialog.setDialogTitle(NbBundle.getMessage(SecurityEventsTopComponent.class, (String)"SecurityEventsTopComponent.Statistics.export.message.title"));
                        saveDialog.setDialogType(1);
                        saveDialog.setSelectedFile(new File(fileName));
                        int actionDialog = saveDialog.showSaveDialog(WindowManager.getDefault().getMainWindow());
                        if (actionDialog != 0) break block17;
                        File dfile = new File(saveDialog.getCurrentDirectory(), saveDialog.getSelectedFile().getName());
                        dfile.createNewFile();
                        try (FileOutputStream fileOuputStream = new FileOutputStream(dfile);){
                            wb.write((OutputStream)fileOuputStream);
                        }
                    }
                    catch (IOException | InterruptedException | ExecutionException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    finally {
                        this.ph.finish();
                        AnalysisTopComponent.this.bExport.setEnabled(true);
                    }
                }
            }

            private String genFileName() {
                DateTime now = new DateTime();
                DateTimeFormatter dtf = ISODateTimeFormat.basicDateTimeNoMillis();
                return String.format(NbBundle.getMessage(AnalysisTopComponent.class, (String)"AnalysisTopComponent.export.filename"), now.toString(dtf));
            }
        };
        sw.execute();
    }

    private void bShowSimpleHistoricalCorrelationActionPerformed(ActionEvent evt) {
        String query = this.tfSearch.getText();
        LinkedHashMap<String, String> fieldsValues = new LinkedHashMap<String, String>();
        for (int i = 0; i < this.tResults.getColumnCount(); ++i) {
            if (this.tResults.getColumnName(i).equals("func.count")) continue;
            fieldsValues.put(this.tResults.getColumnName(i), (String)this.resultTableModel.getValueAt(0, this.resultTableModel.getColumnIndexByColumnName(this.tResults.getColumnName(i))));
        }
        final SimpleHistoricalCorrelationPanel scp = new SimpleHistoricalCorrelationPanel(query, fieldsValues);
        final JButton save = new JButton("Save Script");
        DialogDescriptor des = new DialogDescriptor((Object)scp, NbBundle.getMessage(SecurityEventDetailsTopComponent.class, (String)"SimpleCorrelatorPanel.title"), false, new Object[]{save, DialogDescriptor.CANCEL_OPTION}, (Object)save, 0, HelpCtx.DEFAULT_HELP, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource().equals(save)) {
                    if (scp.isScriptValid() && !scp.getScriptText().isEmpty()) {
                        boolean success = false;
                        try {
                            AnalysisTopComponent.this.apiService.createScriptWithText(scp.getScriptName(), scp.getScriptText(), "javascript", "Script created with SimpleHistoricalCorrelator", ScriptType.SCHEDULED);
                            AnalysisTopComponent.this.apiService.addTask(scp.getScriptName(), scp.getScriptCron());
                            String scriptType = NbBundle.getMessage(SecurityEventDetailsTopComponent.class, (String)("scrypt.type." + ScriptType.SCHEDULED));
                            String savedText = NbBundle.getMessage(SecurityEventDetailsTopComponent.class, (String)"SecurityEventsTopComponent.simpleCorrelator.scriptSaved");
                            JOptionPane.showMessageDialog(scp, String.format(savedText, scp.getScriptName(), scriptType));
                            success = true;
                        }
                        catch (ApiServiceException_Exception ex) {
                            LOGGER.info("" + ex.getFaultInfo().getData());
                            JOptionPane.showMessageDialog(scp, ex.getFaultInfo().getData().get(0), "Save faild", 2);
                        }
                        if (success) {
                            AnalysisTopComponent.this.dialog.setVisible(false);
                            AnalysisTopComponent.this.dialog.dispose();
                        }
                    } else {
                        JOptionPane.showMessageDialog(scp, NbBundle.getMessage(SecurityEventDetailsTopComponent.class, (String)"SecurityEventsTopComponent.simpleCorrelator.scriptNotValid"));
                    }
                }
            }
        });
        this.dialog = DialogDisplayer.getDefault().createDialog(des);
        this.dialog.setVisible(true);
    }

    public void componentOpened() {
        this.startAutoRefreshTimer();
    }

    public void componentClosed() {
        this.stopAutoRefreshTimer();
        this.memDB.dispose();
        this.tfFilter.setText("");
        this.resultTableModel.resetData();
        if (this.searchExecutor != null) {
            this.searchExecutor.shutdown();
        }
    }

    private Set<String> getMappings() {
        HashSet<String> items = new HashSet<String>();
        try {
            Map mappings = this.apiService.getMappings();
            for (String cat : mappings.keySet()) {
                if (!cat.equalsIgnoreCase("who") && !cat.equalsIgnoreCase("what") && !cat.equalsIgnoreCase("where") && !cat.equalsIgnoreCase("when") && !cat.equalsIgnoreCase("extra")) continue;
                for (String field : (List)mappings.get(cat)) {
                    StringBuilder sb = new StringBuilder();
                    sb.append(cat);
                    sb.append(".");
                    sb.append(field);
                    items.add(sb.toString());
                }
            }
        }
        catch (ApiServiceException_Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return items;
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
        p.setProperty("search_string", this.tfSearch.getText());
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
        try {
            this.tfSearch.setText(p.getProperty("search_string"));
        }
        catch (NumberFormatException ex) {
            LOGGER.warning(String.format("Error converting to number: %s", ex.getMessage()));
        }
    }

    public void doSearch(String query) {
        this.tfSearch.setText(query);
        this.startSearch();
    }

    public void doSearch(String query, long start, long finish) {
        this.displayOptions.setNow(false);
        this.displayOptions.setLastNHours(false);
        this.displayOptions.setTimeStart(start);
        this.displayOptions.setTimeFinish(finish);
        this.doSearch(query);
    }

    public DisplayOptions getDisplayOptions() {
        return this.displayOptions;
    }

    private void updateCountSearchStatus() {
        if (this.searchExecutor != null) {
            List<String> errors = this.searchExecutor.getSearchContext().getSearchResults().getErrors();
            long totalDuration = this.searchExecutor.getSearchContext().getSearchResults().getTotalDuration();
            if (!errors.isEmpty()) {
                this.lSearchStatus.setIcon(new ImageIcon(this.getClass().getResource("/delete.png")));
                StringBuilder sb = new StringBuilder();
                for (String err : errors) {
                    sb.append(err);
                    sb.append(", ");
                }
                if (sb.toString().length() > 2) {
                    sb.replace(sb.toString().length() - 2, sb.toString().length(), "");
                }
                String error = NbBundle.getMessage(SecurityEventsTopComponent.class, (String)"SecurityEventsTopComponent.lSearchStatus.failed.text", (Object[])new Object[]{totalDuration, sb.toString()});
                this.lSearchStatus.setToolTipText(error);
            } else {
                this.lSearchStatus.setIcon(null);
                this.lSearchStatus.setToolTipText("");
                this.bSearch.setForeground(Color.black);
            }
            this.lSearchStatus.setText(NbBundle.getMessage(SecurityEventsTopComponent.class, (String)"SecurityEventsTopComponent.lSearchStatus.text.label", (Object[])new Object[]{totalDuration, this.searchExecutor.getSearchContext().getSearchResults().getTotalHits()}));
        }
    }

    private void updateSearchTime() {
        this.lQueryTime.setText(NbBundle.getMessage(AnalysisTopComponent.class, (String)"SecurityEventsTopComponent.lQueryTime.text.label", (Object[])new Object[]{this.isoTimeFormat.print(this.displayOptions.getTimeStart()), this.isoTimeFormat.print(this.displayOptions.getTimeFinish())}));
    }

    public void updateDisplayOptions(DisplayOptions displayOptions) {
        this.displayOptions.setAutoRefresh(displayOptions.getAutoRefresh());
        this.displayOptions.setPageSize(displayOptions.getPageSize());
        this.displayOptions.setIndexSplit(displayOptions.getIndexSplit());
        this.displayOptions.setIntervalObj(displayOptions.getIntervalObj());
        this.displayOptions.setIntervals(displayOptions.getIntervals());
        this.displayOptions.setLastNHours(false);
        this.displayOptions.setLastNHoursSelectedIndex(displayOptions.getLastNHoursSelectedIndex());
        this.displayOptions.setNow(false);
        if (this.displayOptions.isNow()) {
            displayOptions.adjustTime();
        }
        this.displayOptions.setTimeStart(displayOptions.getTimeStart());
        this.displayOptions.setTimeFinish(displayOptions.getTimeFinish());
        this.displayOptions.setShowOverview(displayOptions.isShowOverview());
        this.displayOptions.setDescOrder(displayOptions.isDescOrder());
    }

    public void startSearch() {
        if (this.countChart != null) {
            this.countChart.getChartPanel().removeChartMouseListener(this.chartMouseListener);
            this.countChart = null;
        }
        this.cpChart.setCollapsed(true);
        this.pmColumns.removeAll();
        this.memDB.dispose();
        this.fieldsTableModel.resetData();
        this.resultTableModel.resetData();
        if (this.searchExecutor != null) {
            this.searchExecutor.shutdown();
        }
        this.lQueryTime.setText(NbBundle.getMessage(SecurityEventsTopComponent.class, (String)"SecurityEventsTopComponent.lQueryTime.text.CalculatingTimestamps"));
        this.lSearchStatus.setText(NbBundle.getMessage(SecurityEventsTopComponent.class, (String)"SecurityEventsTopComponent.lQueryTime.text.PreparingSearch"));
        this.displayOptions.adjustTime();
        try {
            LOGGER.info(String.format("START SEARCH: s: %s f: %s", new DateTime(this.displayOptions.getTimeStart()), new DateTime(this.displayOptions.getTimeFinish())));
            this.lLoading.setBusy(true);
            this.searchExecutor = new SearchExecutor(this.tfSearch.getText(), this.displayOptions.getTimeStart(), this.displayOptions.getTimeFinish(), this.displayOptions.getIndexSplit(), this.displayOptions.getPageSize(), false, this);
            this.searchExecutor.startSearch();
            this.updateSearchTime();
            this.setDisplayName(TopComponentTitleShortener.shortenTitle(this.searchExecutor.ifQueryIsEmptySetToDefault(this.tfSearch.getText())));
            this.startAutoRefreshTimer();
            this.previousQuery = this.tfSearch.getText();
        }
        catch (ApiServiceException_Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.updateUndoQuery();
    }

    private void fetch(DateRange dr) {
        try {
            this.searchExecutor.fetch(dr);
        }
        catch (ApiServiceException_Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private ChartPanel createChart(TimeTableXYDataset dataset) {
        if (this.countChart == null) {
            MyStackedXYBarRenderer renderer = new MyStackedXYBarRenderer();
            this.countChart = new FrontCountBarChart(dataset, renderer);
            ChartPanel chartPanel = this.countChart.getChartPanel();
            chartPanel.getChart().removeLegend();
        } else {
            this.countChart.updateChart(dataset);
            this.pChart.invalidate();
            this.pChart.repaint();
        }
        return this.countChart.getChartPanel();
    }

    private TimeTableXYDataset createDataset() {
        TimeTableXYDataset dataset = new TimeTableXYDataset();
        dataset.setDomainIsPointsInTime(true);
        Map<DateRange, SearchState> searchStateForDateRange = this.searchExecutor.getSearchContext().getSearchStateForDateRange();
        for (DateRange dr : searchStateForDateRange.keySet()) {
            SearchState ss = searchStateForDateRange.get(dr);
            if (ss.getTotalHits() == null) continue;
            long totalHits = ss.getTotalHits();
            if (ss.getTotalHits() == -1L) {
                long m;
                totalHits = m = this.searchExecutor.getAverageCountValueForGraph();
            }
            dataset.add((TimePeriod)new SimpleTimePeriod(dr.getStartTimeStamp(), dr.getFinishTimeStamp()), (double)totalHits, (Comparable)((Object)""));
        }
        return dataset;
    }
}

