/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.prseditor.nodes;

import java.util.ArrayList;
import java.util.List;
import org.jdesktop.swingx.treetable.AbstractMutableTreeTableNode;
import org.jdesktop.swingx.treetable.MutableTreeTableNode;
import org.jdesktop.swingx.treetable.TreeTableNode;
import rs.co.ast.aspen.gui.module.prseditor.Filter;
import rs.co.ast.aspen.gui.module.prseditor.TestGroupWrapper;
import rs.co.ast.aspen.gui.module.prseditor.TestRuleWrapper;
import rs.co.ast.aspen.gui.module.prseditor.nodes.TestRuleNode;
import rs.co.ast.aspen.gui.module.prseditor.nodes.TestRuleSetNode;

public class TestGroupNode
extends AbstractMutableTreeTableNode {
    private TestGroupWrapper groupWrapper;
    private List<AbstractMutableTreeTableNode> childrens = new ArrayList<AbstractMutableTreeTableNode>();
    private boolean success;

    public TestGroupNode(MutableTreeTableNode parent, TestGroupWrapper groupWrapper, boolean success, Filter filter) {
        this.parent = parent;
        this.groupWrapper = groupWrapper;
        this.success = success;
        this.createChildNodes(filter);
    }

    private void createChildNodes(Filter filter) {
        for (TestGroupWrapper g : this.groupWrapper.getSubGroups()) {
            TestGroupNode tgn = new TestGroupNode((MutableTreeTableNode)this, g, g.isSuccess(), filter);
            this.childrens.add(tgn);
            System.out.println(String.format("%s", g.getGroup().getName()));
            for (TestRuleWrapper r : g.getTestRules()) {
                TestRuleNode trn = new TestRuleNode((MutableTreeTableNode)tgn, r, r.isSuccess(), filter);
                tgn.addChild(trn);
            }
        }
    }

    public TestGroupWrapper getGroupWrapper() {
        return this.groupWrapper;
    }

    public Object getValueAt(int column) {
        switch (column) {
            case 0: {
                return this.groupWrapper;
            }
        }
        return "";
    }

    public int getColumnCount() {
        return 4;
    }

    public void setParent(MutableTreeTableNode newParent) {
        this.parent = newParent;
    }

    public TreeTableNode getParent() {
        return this.parent;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setSuccess(boolean success) {
        this.success = success;
        if (this.parent instanceof TestGroupNode) {
            TestGroupNode tg = (TestGroupNode)this.parent;
            tg.checkSuccess();
        } else if (this.parent instanceof TestRuleSetNode) {
            TestRuleSetNode tr = (TestRuleSetNode)this.parent;
            tr.checkSuccess();
        }
    }

    public List<AbstractMutableTreeTableNode> getChildren() {
        return this.childrens;
    }

    public boolean addChild(AbstractMutableTreeTableNode childNode) {
        return this.childrens.add(childNode);
    }

    private boolean checkSubGroups() {
        boolean ret = true;
        for (TestGroupWrapper g : this.groupWrapper.getSubGroups()) {
            if (g.isSuccess()) continue;
            ret = false;
            break;
        }
        return ret;
    }

    private boolean checkSubRules() {
        boolean ret = true;
        for (TestRuleWrapper gr : this.groupWrapper.getTestRules()) {
            if (gr.isSuccess()) continue;
            ret = false;
            break;
        }
        return ret;
    }

    public void checkSuccess() {
        this.success = this.checkSubGroups() && this.checkSubRules();
    }
}

