/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.datamaps.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.SwingUtilities;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import rs.co.ast.aspen.gui.module.datamaps.DataMapName;
import rs.co.ast.aspen.gui.module.datamaps.DataMapsTopComponent;
import rs.co.ast.aspen.gui.module.datamaps.ExportEnterFieldsPanel;
import rs.co.ast.aspen.gui.module.datamaps.ExportGenerator;

public final class ExportDataMapToExcelAction
implements ActionListener,
ExportGenerator.WorkFinishedListener {
    private final DataMapName dataMapName;
    private final ExportGenerator.WorkFinishedListener exportListener = this;
    private final RequestProcessor req = new RequestProcessor("export_thread", 1, true);

    public ExportDataMapToExcelAction(DataMapName dataMapName) {
        this.dataMapName = dataMapName;
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        final ExportEnterFieldsPanel panel = new ExportEnterFieldsPanel(this.dataMapName, true);
        DialogDescriptor d = new DialogDescriptor((Object)panel, NbBundle.getMessage(DataMapsTopComponent.class, (String)"DataMapsTopComponent.enterFieldsPanel.title"), false, null);
        DialogDisplayer.getDefault().createDialog(d).setVisible(true);
        d.setButtonListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int opt = (Integer)e.getSource();
                if (DialogDescriptor.OK_OPTION.equals(opt)) {
                    ExportGenerator gen = new ExportGenerator(ExportDataMapToExcelAction.this.dataMapName.getName(), panel.getFields(), panel.useMultipleWorkSheets());
                    gen.addWorkFinishedListener(ExportDataMapToExcelAction.this.exportListener);
                    ExportDataMapToExcelAction.this.req.execute((Runnable)gen);
                }
            }
        });
    }

    @Override
    public void done(ExportGenerator.WorkFinishedEvent event, String fileName, byte[] file, final Boolean success) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int messageType = 0;
                String message = NbBundle.getMessage(DataMapsTopComponent.class, (String)"DataMapsTopComponent.exportMessage.error");
                if (success.booleanValue()) {
                    messageType = 1;
                    message = NbBundle.getMessage(DataMapsTopComponent.class, (String)"DataMapsTopComponent.exportMessage.success");
                }
                NotifyDescriptor.Message d = new NotifyDescriptor.Message((Object)message, messageType);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)d);
            }
        });
    }
}

