/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.rawlogs.export.strategies;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.SwingWorker;
import org.joda.time.DateTime;
import org.openide.util.Exceptions;
import rs.co.ast.aspen.api.service.ApiServiceException_Exception;
import rs.co.ast.aspen.api.service.DateRange;
import rs.co.ast.aspen.api.service.RawLogsSearchResults;
import rs.co.ast.aspen.api.service.SearchState;
import rs.co.ast.aspen.gui.rawlogs.export.strategies.ExportStrategy;

public class JSONExportStrategy
extends ExportStrategy {
    private static final ObjectMapper mapper = new ObjectMapper();

    public JSONExportStrategy(String query, String exportPath, long startTime, long finishTime, long indexSplit) throws ApiServiceException_Exception {
        super(query, exportPath, startTime, finishTime, indexSplit, "json");
    }

    @Override
    public SwingWorker<byte[], Void> search(final String fileName, final SearchState searchState, final DateRange dateRange) {
        return new SwingWorker<byte[], Void>(){

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            protected byte[] doInBackground() throws Exception {
                RawLogsSearchResults result = JSONExportStrategy.this.fetch(searchState, dateRange);
                ExportStrategy.logger.info(String.format("FETCH - s: %s - f: %s, o: %d, d: %d, t: %d", new DateTime(dateRange.getStartTimeStamp()), new DateTime(dateRange.getFinishTimeStamp()), result.getSearchState().getOffset(), result.getContainer().getRowLogs().size(), result.getSearchState().getTotalHits()));
                if (!result.getContainer().getErrors().isEmpty()) {
                    ExportStrategy.logger.warning(String.format("FETCH ERRORS - %s", result.getContainer().getErrors()));
                    JSONExportStrategy.this.fileSkippedSupport.fireFileSkippedEvent(fileName, dateRange, searchState);
                    return null;
                }
                List rawLogs = result.getContainer().getRowLogs();
                byte[] val = mapper.writerWithDefaultPrettyPrinter().writeValueAsBytes((Object)rawLogs);
                try (ByteArrayOutputStream osFile = new ByteArrayOutputStream();){
                    osFile.write(val);
                    JSONExportStrategy.this.progressValueChangedSupport.fireProgressValueChangedEvent(rawLogs.size(), rawLogs.size(), rawLogs.size(), 0.0f);
                    byte[] byArray = osFile.toByteArray();
                    return byArray;
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    return null;
                }
            }

            @Override
            protected void done() {
                try {
                    byte[] file = (byte[])this.get();
                    if (file == null) {
                        return;
                    }
                    JSONExportStrategy.this.taskMonitor.completeFetch(fileName);
                    JSONExportStrategy.this.fileCreatedSupport.fireFileCreatedEvent(fileName, file, true);
                }
                catch (InterruptedException | ExecutionException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        };
    }
}

