/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.meshes;

import com.jme3.math.Vector2f;
import com.jme3.math.Vector3f;
import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.file.BlenderFileException;
import com.jme3.scene.plugins.blender.file.Pointer;
import com.jme3.scene.plugins.blender.file.Structure;
import com.jme3.scene.plugins.blender.meshes.Edge;
import com.jme3.scene.plugins.blender.meshes.IndexesLoop;
import com.jme3.scene.plugins.blender.meshes.MeshHelper;
import com.jme3.scene.plugins.blender.meshes.TemporalMesh;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Face
implements Comparator<Integer> {
    private static final Logger LOGGER = Logger.getLogger(Face.class.getName());
    private IndexesLoop indexes;
    private List<IndexesLoop> triangulatedFaces;
    private boolean smooth;
    private int materialNumber;
    private Map<String, List<Vector2f>> faceUVCoords;
    private List<byte[]> vertexColors;
    private TemporalMesh temporalMesh;

    public Face(Integer[] indexes, boolean smooth, int materialNumber, Map<String, List<Vector2f>> faceUVCoords, List<byte[]> vertexColors, TemporalMesh temporalMesh) {
        this.setTemporalMesh(temporalMesh);
        this.indexes = new IndexesLoop(indexes);
        this.smooth = smooth;
        this.materialNumber = materialNumber;
        this.faceUVCoords = faceUVCoords;
        this.temporalMesh = temporalMesh;
        this.vertexColors = vertexColors;
    }

    private Face() {
    }

    public Face clone() {
        Face result = new Face();
        result.indexes = this.indexes.clone();
        result.smooth = this.smooth;
        result.materialNumber = this.materialNumber;
        if (this.faceUVCoords != null) {
            result.faceUVCoords = new HashMap<String, List<Vector2f>>(this.faceUVCoords.size());
            for (Map.Entry<String, List<Vector2f>> entry : this.faceUVCoords.entrySet()) {
                ArrayList<Vector2f> uvs = new ArrayList<Vector2f>(entry.getValue().size());
                for (Vector2f v : entry.getValue()) {
                    uvs.add(v.clone());
                }
                result.faceUVCoords.put(entry.getKey(), uvs);
            }
        }
        if (this.vertexColors != null) {
            result.vertexColors = new ArrayList<byte[]>(this.vertexColors.size());
            for (byte[] colors : this.vertexColors) {
                result.vertexColors.add((byte[])colors.clone());
            }
        }
        result.temporalMesh = this.temporalMesh;
        return result;
    }

    private Integer getIndex(int indexPosition) {
        if (indexPosition >= this.indexes.size()) {
            indexPosition %= this.indexes.size();
        } else if (indexPosition < 0) {
            indexPosition = this.indexes.size() - -indexPosition % this.indexes.size();
        }
        return this.indexes.get(indexPosition);
    }

    public TemporalMesh getTemporalMesh() {
        return this.temporalMesh;
    }

    public IndexesLoop getIndexes() {
        return this.indexes;
    }

    public Vector3f computeCentroid() {
        Vector3f result = new Vector3f();
        List<Vector3f> vertices = this.temporalMesh.getVertices();
        for (Integer index : this.indexes) {
            result.addLocal(vertices.get(index));
        }
        return result.divideLocal((float)this.indexes.size());
    }

    public List<List<Integer>> getCurrentIndexes() {
        if (this.triangulatedFaces == null) {
            return Arrays.asList(this.indexes.getAll());
        }
        ArrayList<List<Integer>> result = new ArrayList<List<Integer>>(this.triangulatedFaces.size());
        for (IndexesLoop loop : this.triangulatedFaces) {
            result.add(loop.getAll());
        }
        return result;
    }

    private List<Face> detachTriangle(Integer[] triangleIndexes) throws BlenderFileException {
        LOGGER.fine("Detaching triangle.");
        if (triangleIndexes.length != 3) {
            throw new IllegalArgumentException("Cannot detach triangle with that does not have 3 indexes!");
        }
        MeshHelper meshHelper = (MeshHelper)this.temporalMesh.getBlenderContext().getHelper(MeshHelper.class);
        ArrayList<Face> detachedFaces = new ArrayList<Face>();
        ArrayList<Integer> path = new ArrayList<Integer>(this.indexes.size());
        boolean[] edgeRemoved = new boolean[]{this.indexes.removeEdge(triangleIndexes[0], triangleIndexes[1]), this.indexes.removeEdge(triangleIndexes[0], triangleIndexes[2]), this.indexes.removeEdge(triangleIndexes[1], triangleIndexes[2])};
        Integer[][] indexesPairs = new Integer[][]{{triangleIndexes[0], triangleIndexes[1]}, {triangleIndexes[0], triangleIndexes[2]}, {triangleIndexes[1], triangleIndexes[2]}};
        for (int i = 0; i < 3; ++i) {
            if (edgeRemoved[i]) continue;
            this.indexes.findPath(indexesPairs[i][0], indexesPairs[i][1], path);
            if (path.size() == 0) {
                this.indexes.findPath(indexesPairs[i][1], indexesPairs[i][0], path);
            }
            if (path.size() == 0) {
                throw new IllegalStateException("Triangulation failed. Cannot find path between two indexes. Please apply triangulation in Blender as a workaround.");
            }
            if (detachedFaces.size() == 0 && path.size() < this.indexes.size()) {
                Integer[] indexesSublist = path.toArray(new Integer[path.size()]);
                detachedFaces.add(new Face(indexesSublist, this.smooth, this.materialNumber, meshHelper.selectUVSubset(this, indexesSublist), meshHelper.selectVertexColorSubset(this, indexesSublist), this.temporalMesh));
                for (int j = 0; j < path.size() - 1; ++j) {
                    this.indexes.removeEdge((Integer)path.get(j), (Integer)path.get(j + 1));
                }
                this.indexes.removeEdge((Integer)path.get(path.size() - 1), (Integer)path.get(0));
                continue;
            }
            this.indexes.addEdge((Integer)path.get(path.size() - 1), (Integer)path.get(0));
        }
        return detachedFaces;
    }

    public void setTemporalMesh(TemporalMesh temporalMesh) {
        if (temporalMesh == null) {
            throw new IllegalArgumentException("No temporal mesh for the face given!");
        }
        this.temporalMesh = temporalMesh;
    }

    public void flipIndexes() {
        this.indexes.reverse();
        if (this.faceUVCoords != null) {
            for (Map.Entry<String, List<Vector2f>> entry : this.faceUVCoords.entrySet()) {
                Collections.reverse(entry.getValue());
            }
        }
    }

    public void flipUV(boolean u, boolean v) {
        if (this.faceUVCoords != null) {
            for (Map.Entry<String, List<Vector2f>> entry : this.faceUVCoords.entrySet()) {
                for (Vector2f uv : entry.getValue()) {
                    uv.set(u ? 1.0f - uv.x : uv.x, v ? 1.0f - uv.y : uv.y);
                }
            }
        }
    }

    public Map<String, List<Vector2f>> getUvSets() {
        return this.faceUVCoords;
    }

    public int vertexCount() {
        return this.indexes.size();
    }

    public TriangulationWarning triangulate() {
        LOGGER.fine("Triangulating face.");
        assert (this.indexes.size() >= 3) : "Invalid indexes amount for face. 3 is the required minimum!";
        this.triangulatedFaces = new ArrayList<IndexesLoop>(this.indexes.size() - 2);
        Integer[] indexes = new Integer[3];
        TriangulationWarning warning = TriangulationWarning.NONE;
        try {
            ArrayList<Face> facesToTriangulate = new ArrayList<Face>(Arrays.asList(this.clone()));
            block2: while (facesToTriangulate.size() > 0 && warning == TriangulationWarning.NONE) {
                Face face = (Face)facesToTriangulate.remove(0);
                if (face.getIndexes().size() == 3) {
                    this.triangulatedFaces.add(face.getIndexes().clone());
                    continue;
                }
                int previousIndex1 = -1;
                int previousIndex2 = -1;
                int previousIndex3 = -1;
                while (face.vertexCount() > 0) {
                    indexes[0] = face.getIndex(0);
                    indexes[1] = face.findClosestVertex(indexes[0], -1);
                    indexes[2] = face.findClosestVertex(indexes[0], indexes[1]);
                    LOGGER.finer("Veryfying improper triangulation of the temporal mesh.");
                    if (indexes[0] < 0 || indexes[1] < 0 || indexes[2] < 0) {
                        warning = TriangulationWarning.CLOSEST_VERTS;
                        continue block2;
                    }
                    if (previousIndex1 == indexes[0] && previousIndex2 == indexes[1] && previousIndex3 == indexes[2]) {
                        warning = TriangulationWarning.INFINITE_LOOP;
                        continue block2;
                    }
                    previousIndex1 = indexes[0];
                    previousIndex2 = indexes[1];
                    previousIndex3 = indexes[2];
                    Arrays.sort(indexes, this);
                    facesToTriangulate.addAll(face.detachTriangle(indexes));
                    this.triangulatedFaces.add(new IndexesLoop(indexes));
                }
            }
        }
        catch (BlenderFileException e) {
            LOGGER.log(Level.WARNING, "Errors occured during face triangulation: {0}. The face will be triangulated with the most direct algorithm, but the results might not be identical to blender.", e.getLocalizedMessage());
            warning = TriangulationWarning.UNKNOWN;
        }
        if (warning != TriangulationWarning.NONE) {
            LOGGER.finest("Triangulation the face using the most direct algorithm.");
            indexes[0] = this.getIndex(0);
            for (int i = 1; i < this.vertexCount() - 1; ++i) {
                indexes[1] = this.getIndex(i);
                indexes[2] = this.getIndex(i + 1);
                this.triangulatedFaces.add(new IndexesLoop(indexes));
            }
        }
        return warning;
    }

    public boolean isSmooth() {
        return this.smooth;
    }

    public int getMaterialNumber() {
        return this.materialNumber;
    }

    public List<byte[]> getVertexColors() {
        return this.vertexColors;
    }

    public String toString() {
        return "Face " + this.indexes;
    }

    private int findClosestVertex(int index, int indexToIgnore) {
        int result = -1;
        List<Vector3f> vertices = this.temporalMesh.getVertices();
        Vector3f v1 = vertices.get(index);
        float distance = Float.MAX_VALUE;
        for (int i : this.indexes) {
            Vector3f v2;
            float d;
            if (i == index || i == indexToIgnore || !((d = (v2 = vertices.get(i)).distance(v1)) < distance) || !this.contains(new Edge(index, i, 0.0f, true, this.temporalMesh)) || indexToIgnore >= 0 && !this.contains(new Edge(indexToIgnore, i, 0.0f, true, this.temporalMesh))) continue;
            result = i;
            distance = d;
        }
        return result;
    }

    private boolean contains(Edge edge) {
        int index1 = edge.getFirstIndex();
        int index2 = edge.getSecondIndex();
        if (!this.indexes.areNeighbours(index1, index2)) {
            for (int i = 0; i < this.indexes.size(); ++i) {
                int i1 = this.getIndex(i - 1);
                int i2 = this.getIndex(i);
                if (i1 == index1 || i1 == index2 || i2 == index1 || i2 == index2 || !edge.cross(new Edge(i1, i2, 0.0f, false, this.temporalMesh))) continue;
                return false;
            }
            Vector3f edgeMiddlePoint = edge.computeCentroid();
            Vector3f edgeVector = edge.getSecondVertex().subtract(edge.getFirstVertex());
            Vector3f edgeNormal = this.temporalMesh.getNormals().get(index1).cross(edgeVector).normalizeLocal();
            Edge e = new Edge(edgeMiddlePoint, edgeNormal.add(edgeMiddlePoint));
            ArrayList<Vector3f> crossingVectors = new ArrayList<Vector3f>();
            for (int i = 0; i < this.indexes.size(); ++i) {
                int i2;
                int i1 = this.getIndex(i);
                Vector3f crossPoint = e.getCrossPoint(new Edge(i1, i2 = this.getIndex(i + 1).intValue(), 0.0f, false, this.temporalMesh), true, false);
                if (crossPoint == null) continue;
                crossingVectors.add(crossPoint.subtractLocal(edgeMiddlePoint));
            }
            if (crossingVectors.size() == 0) {
                return false;
            }
            ArrayList<Vector3f> distinctCrossingVectors = new ArrayList<Vector3f>();
            for (Vector3f cv : crossingVectors) {
                double minDistance = Double.MAX_VALUE;
                for (Vector3f dcv : distinctCrossingVectors) {
                    minDistance = Math.min(minDistance, (double)dcv.distance(cv));
                }
                if (!(minDistance > 1.1920928955078125E-7)) continue;
                distinctCrossingVectors.add(cv);
            }
            if (distinctCrossingVectors.size() == 0) {
                throw new IllegalStateException("There MUST be at least 2 crossing vertices!");
            }
            float direction = Math.signum(((Vector3f)distinctCrossingVectors.get(0)).dot(edgeNormal));
            for (int i = 1; i < distinctCrossingVectors.size(); ++i) {
                if (direction == Math.signum(((Vector3f)distinctCrossingVectors.get(i)).dot(edgeNormal))) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.indexes.hashCode();
        result = 31 * result + this.temporalMesh.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Face)) {
            return false;
        }
        Face other = (Face)obj;
        if (!this.indexes.equals(other.indexes)) {
            return false;
        }
        return this.temporalMesh.equals((Object)other.temporalMesh);
    }

    public static List<Face> loadAll(Structure meshStructure, Map<String, List<Vector2f>> userUVGroups, List<byte[]> verticesColors, TemporalMesh temporalMesh, BlenderContext blenderContext) throws BlenderFileException {
        LOGGER.log(Level.FINE, "Loading all faces from mesh: {0}", meshStructure.getName());
        ArrayList<Face> result = new ArrayList<Face>();
        MeshHelper meshHelper = (MeshHelper)blenderContext.getHelper(MeshHelper.class);
        if (meshHelper.isBMeshCompatible(meshStructure)) {
            LOGGER.fine("Reading BMesh.");
            Pointer pMLoop = (Pointer)meshStructure.getFieldValue("mloop");
            Pointer pMPoly = (Pointer)meshStructure.getFieldValue("mpoly");
            if (pMPoly.isNotNull() && pMLoop.isNotNull()) {
                List<Structure> polys = pMPoly.fetchData();
                List<Structure> loops = pMLoop.fetchData();
                for (Structure poly : polys) {
                    int materialNumber = ((Number)poly.getFieldValue("mat_nr")).intValue();
                    int loopStart = ((Number)poly.getFieldValue("loopstart")).intValue();
                    int totLoop = ((Number)poly.getFieldValue("totloop")).intValue();
                    boolean smooth = (((Number)poly.getFieldValue("flag")).byteValue() & 1) != 0;
                    Integer[] vertexIndexes = new Integer[totLoop];
                    for (int i = loopStart; i < loopStart + totLoop; ++i) {
                        vertexIndexes[i - loopStart] = ((Number)loops.get(i).getFieldValue("v")).intValue();
                    }
                    HashMap<String, List<Vector2f>> uvCoords = new HashMap<String, List<Vector2f>>();
                    for (Map.Entry<String, List<Vector2f>> entry : userUVGroups.entrySet()) {
                        List<Vector2f> uvs = entry.getValue().subList(loopStart, loopStart + totLoop);
                        uvCoords.put(entry.getKey(), new ArrayList<Vector2f>(uvs));
                    }
                    ArrayList<byte[]> vertexColors = null;
                    if (verticesColors != null && verticesColors.size() > 0) {
                        vertexColors = new ArrayList<byte[]>(totLoop);
                        for (int i = loopStart; i < loopStart + totLoop; ++i) {
                            vertexColors.add(verticesColors.get(i));
                        }
                    }
                    result.add(new Face(vertexIndexes, smooth, materialNumber, uvCoords, vertexColors, temporalMesh));
                }
            }
        } else {
            List<Structure> mFaces;
            LOGGER.fine("Reading traditional faces.");
            Pointer pMFace = (Pointer)meshStructure.getFieldValue("mface");
            List<Structure> list = mFaces = pMFace.isNotNull() ? pMFace.fetchData() : null;
            if (mFaces != null && mFaces.size() > 0) {
                for (int i = 0; i < mFaces.size(); ++i) {
                    Integer[] integerArray;
                    Structure mFace = mFaces.get(i);
                    int materialNumber = ((Number)mFace.getFieldValue("mat_nr")).intValue();
                    boolean smooth = (((Number)mFace.getFieldValue("flag")).byteValue() & 1) != 0;
                    int v1 = ((Number)mFace.getFieldValue("v1")).intValue();
                    int v2 = ((Number)mFace.getFieldValue("v2")).intValue();
                    int v3 = ((Number)mFace.getFieldValue("v3")).intValue();
                    int v4 = ((Number)mFace.getFieldValue("v4")).intValue();
                    int vertCount = v4 == 0 ? 3 : 4;
                    HashMap<String, List<Vector2f>> faceUVCoords = new HashMap<String, List<Vector2f>>();
                    for (Map.Entry<String, List<Vector2f>> entry : userUVGroups.entrySet()) {
                        ArrayList<Vector2f> uvCoordsForASingleFace = new ArrayList<Vector2f>(vertCount);
                        for (int j = 0; j < vertCount; ++j) {
                            uvCoordsForASingleFace.add(entry.getValue().get(i * 4 + j));
                        }
                        faceUVCoords.put(entry.getKey(), uvCoordsForASingleFace);
                    }
                    Object vertexColors = null;
                    if (verticesColors != null && verticesColors.size() > 0) {
                        vertexColors = new ArrayList(vertCount);
                        vertexColors.add(verticesColors.get(v1));
                        vertexColors.add(verticesColors.get(v2));
                        vertexColors.add(verticesColors.get(v3));
                        if (vertCount == 4) {
                            vertexColors.add(verticesColors.get(v4));
                        }
                    }
                    if (vertCount == 4) {
                        Integer[] integerArray2 = new Integer[4];
                        integerArray2[0] = v1;
                        integerArray2[1] = v2;
                        integerArray2[2] = v3;
                        integerArray = integerArray2;
                        integerArray2[3] = v4;
                    } else {
                        Integer[] integerArray3 = new Integer[3];
                        integerArray3[0] = v1;
                        integerArray3[1] = v2;
                        integerArray = integerArray3;
                        integerArray3[2] = v3;
                    }
                    result.add(new Face(integerArray, smooth, materialNumber, faceUVCoords, (List<byte[]>)vertexColors, temporalMesh));
                }
            }
        }
        LOGGER.log(Level.FINE, "Loaded {0} faces.", result.size());
        return result;
    }

    @Override
    public int compare(Integer index1, Integer index2) {
        return this.indexes.indexOf(index1) - this.indexes.indexOf(index2);
    }

    public static enum TriangulationWarning {
        NONE(null),
        CLOSEST_VERTS("Unable to find two closest vertices while triangulating face."),
        INFINITE_LOOP("Infinite loop detected during triangulation."),
        UNKNOWN("There was an unknown problem with face triangulation. Please see log for details.");

        private String description;

        private TriangulationWarning(String description) {
            this.description = description;
        }

        public String toString() {
            return this.description;
        }
    }
}

