/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.scripteditor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.AbstractTableModel;
import org.openide.util.NbBundle;
import rs.co.ast.aspen.api.service.ScriptType;
import rs.co.ast.aspen.gui.module.scripteditor.ScriptUpdate;
import rs.co.ast.aspen.gui.module.scripteditor.ScriptUpdateComparatorByName;
import rs.co.ast.aspen.gui.module.scripteditor.ScriptUpdateComparatorByOrder;

public class ScriptUpdateTableModel
extends AbstractTableModel {
    private List<ScriptUpdate> scripts;
    private final Map<ScriptType, List<ScriptUpdate>> scriptsOfType = new HashMap<ScriptType, List<ScriptUpdate>>();
    private Map<String, ScriptUpdate> changedScripts = new HashMap<String, ScriptUpdate>();

    public List<ScriptUpdate> sortScriptsByOrder(ScriptType type) {
        List<ScriptUpdate> s = this.getScriptsByType(type);
        if (s != null) {
            ArrayList<ScriptUpdate> list = new ArrayList<ScriptUpdate>();
            list.addAll(s);
            this.scripts = list;
            Collections.sort(this.scripts, new ScriptUpdateComparatorByOrder());
            this.fireTableDataChanged();
            return list;
        }
        return new ArrayList<ScriptUpdate>();
    }

    public List<ScriptUpdate> sortScriptsByName(ScriptType type) {
        List<ScriptUpdate> s = this.getScriptsByType(type);
        if (s != null) {
            ArrayList<ScriptUpdate> list = new ArrayList<ScriptUpdate>();
            list.addAll(s);
            this.scripts = list;
            Collections.sort(this.scripts, new ScriptUpdateComparatorByName());
            this.fireTableDataChanged();
            return list;
        }
        return new ArrayList<ScriptUpdate>();
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return ScriptUpdate.class;
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public String getColumnName(int column) {
        return NbBundle.getMessage(ScriptUpdateTableModel.class, (String)"ScriptEditorTopComponent.tScripts.col0.title");
    }

    public void setData(List<ScriptUpdate> scripts) {
        this.scripts = scripts;
        this.sortByType();
        this.getScriptsByType(ScriptType.ROUTING);
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.scripts != null ? this.scripts.size() : 0;
    }

    public Map<ScriptType, List<ScriptUpdate>> getScriptsOfType() {
        return this.scriptsOfType;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex >= 0 && rowIndex < this.scripts.size()) {
            return this.scripts.get(rowIndex);
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public List<ScriptUpdate> moveDown(int row) {
        ArrayList<ScriptUpdate> list = new ArrayList<ScriptUpdate>();
        if (row < this.scripts.size() - 1) {
            ScriptUpdate script = this.scripts.get(row);
            ScriptUpdate pscript = this.scripts.get(row + 1);
            long order = script.getOrder();
            script.setOrder(pscript.getOrder());
            pscript.setOrder(order);
            this.scripts.set(row, pscript);
            this.scripts.set(row + 1, script);
            list.add(script);
            list.add(pscript);
            this.fireTableDataChanged();
        }
        return list;
    }

    public List<ScriptUpdate> moveUp(int row) {
        ArrayList<ScriptUpdate> list = new ArrayList<ScriptUpdate>();
        if (row > 0) {
            ScriptUpdate script = this.scripts.get(row);
            ScriptUpdate pscript = this.scripts.get(row - 1);
            long order = script.getOrder();
            script.setOrder(pscript.getOrder());
            pscript.setOrder(order);
            this.scripts.set(row, pscript);
            this.scripts.set(row - 1, script);
            list.add(script);
            list.add(pscript);
            this.fireTableDataChanged();
        }
        return list;
    }

    public boolean scriptAlreadyExist(String name, ScriptType type) {
        List<ScriptUpdate> scriptNames = this.scriptsOfType.get(type);
        return scriptNames.stream().anyMatch(script -> script.getName().equals(name));
    }

    private List<ScriptUpdate> getScriptsByType(ScriptType type) {
        this.scripts = this.scriptsOfType.get(type);
        this.fireTableDataChanged();
        return this.scripts;
    }

    private void sortByType() {
        for (ScriptType t : ScriptType.values()) {
            ArrayList<ScriptUpdate> list = new ArrayList<ScriptUpdate>();
            for (ScriptUpdate s : this.scripts) {
                if (!s.getType().equals((Object)t)) continue;
                list.add(s);
            }
            this.scriptsOfType.put(t, list);
        }
    }

    public Map<String, ScriptUpdate> getChangedScripts() {
        return this.changedScripts;
    }

    public void setChangedScripts(Map<String, ScriptUpdate> changedScripts) {
        this.changedScripts = changedScripts;
    }

    public ScriptUpdate getScriptByRow(int row) {
        ScriptUpdate retScript = null;
        if (row >= 0 && row < this.scripts.size()) {
            retScript = this.scripts.get(row);
        }
        return retScript;
    }

    public int getRowByScriptName(String scriptName) {
        int ret = -1;
        for (int i = 0; i < this.scripts.size(); ++i) {
            if (!this.scripts.get(i).getName().equalsIgnoreCase(scriptName)) continue;
            ret = i;
        }
        return ret;
    }
}

