/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.scripteditor;

import java.awt.Component;
import java.awt.Font;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import rs.co.ast.aspen.api.service.Script;
import rs.co.ast.aspen.gui.module.scripteditor.ScriptEditorTableModel;

public class ScriptEditorTableRenderer
extends JLabel
implements TableCellRenderer {
    private ScriptEditorTableModel model = null;

    public ScriptEditorTableRenderer() {
        this.setOpaque(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (this.model == null) {
            this.model = (ScriptEditorTableModel)table.getModel();
        }
        if (value == null) {
            return this;
        }
        Script script = (Script)value;
        if (isSelected) {
            this.setForeground(table.getSelectionForeground());
            this.setBackground(table.getSelectionBackground());
        } else if (script.isEnabled()) {
            this.setForeground(table.getForeground());
            this.setBackground(table.getBackground());
        } else {
            this.setForeground(UIManager.getColor("MenuItem.disabledForeground"));
            this.setBackground(table.getBackground());
        }
        if (hasFocus) {
            this.setBorder(UIManager.getBorder("Table.focusCellHighlightBorder"));
            if (table.isCellEditable(row, column)) {
                this.setForeground(UIManager.getColor("Table.focusCellForeground"));
                this.setBackground(UIManager.getColor("Table.focusCellBackground"));
            }
        } else {
            this.setBorder(new EmptyBorder(1, 1, 1, 1));
        }
        if (this.model.getChangedScripts().containsKey(script.getId())) {
            this.setFont(new Font(this.getFont().getName(), 1, this.getFont().getSize()));
        } else {
            this.setFont(new Font(this.getFont().getName(), 0, this.getFont().getSize()));
        }
        this.setText(script.getName());
        return this;
    }
}

