/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.scripteditor;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import rs.co.ast.aspen.api.service.ScriptType;
import rs.co.ast.aspen.gui.module.scripteditor.ScriptTypeComboBoxModel;

public class AddNewScriptPanel
extends JPanel {
    private ScriptTypeComboBoxModel scriptTypeModel = new ScriptTypeComboBoxModel();
    private Pattern pat = Pattern.compile("[a-zA-Z0-9_]+");
    private boolean isNameValid = false;
    private JComboBox cbType;
    private JScrollPane jScrollPane1;
    private JLabel lDesc;
    private JLabel lName;
    private JLabel lType;
    private JTextArea taDesc;
    private JTextField tfName;

    public AddNewScriptPanel(String selectedScriptType) {
        this.initComponents();
        this.scriptTypeModel.setSelectedItem(selectedScriptType);
        this.cbType.setModel(this.scriptTypeModel);
        this.cbType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AddNewScriptPanel.this.getScriptType() != ScriptType.VISUALISATION_RULESET && AddNewScriptPanel.this.getScriptType() != ScriptType.VISUALISATION_CONFIGURATION) {
                    Matcher mat = AddNewScriptPanel.this.pat.matcher(AddNewScriptPanel.this.tfName.getText());
                    AddNewScriptPanel.this.isNameValid = mat.matches();
                    if (AddNewScriptPanel.this.isNameValid) {
                        AddNewScriptPanel.this.tfName.setBorder(UIManager.getBorder("TextField.border"));
                    } else {
                        AddNewScriptPanel.this.tfName.setBorder(new LineBorder(Color.RED));
                    }
                } else {
                    AddNewScriptPanel.this.isNameValid = true;
                    AddNewScriptPanel.this.tfName.setBorder(UIManager.getBorder("TextField.border"));
                }
                AddNewScriptPanel.this.tfName.repaint();
            }
        });
        this.tfName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.checkName();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.checkName();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.checkName();
            }

            private void checkName() {
                if (AddNewScriptPanel.this.getScriptType() != ScriptType.VISUALISATION_RULESET && AddNewScriptPanel.this.getScriptType() != ScriptType.VISUALISATION_CONFIGURATION) {
                    Matcher mat = AddNewScriptPanel.this.pat.matcher(AddNewScriptPanel.this.tfName.getText());
                    AddNewScriptPanel.this.isNameValid = mat.matches();
                    if (AddNewScriptPanel.this.isNameValid) {
                        AddNewScriptPanel.this.tfName.setBorder(UIManager.getBorder("TextField.border"));
                    } else {
                        AddNewScriptPanel.this.tfName.setBorder(new LineBorder(Color.RED));
                    }
                } else {
                    AddNewScriptPanel.this.isNameValid = true;
                    AddNewScriptPanel.this.tfName.setBorder(UIManager.getBorder("TextField.border"));
                }
                AddNewScriptPanel.this.tfName.repaint();
            }
        });
    }

    public String getScriptName() {
        return this.tfName.getText();
    }

    public ScriptType getScriptType() {
        return this.scriptTypeModel.getSelectedItem(this.scriptTypeModel.getSelectedIndex());
    }

    public void setSelectedScriptType(String t) {
        this.scriptTypeModel.setSelectedItem(t);
    }

    public String getScriptDesc() {
        return this.taDesc.getText();
    }

    public boolean IsNameValid() {
        return this.isNameValid;
    }

    private void initComponents() {
        this.lName = new JLabel();
        this.lType = new JLabel();
        this.tfName = new JTextField();
        this.cbType = new JComboBox();
        this.lDesc = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.taDesc = new JTextArea();
        Mnemonics.setLocalizedText((JLabel)this.lName, (String)NbBundle.getMessage(AddNewScriptPanel.class, (String)"AddNewScriptPanel.lName.text"));
        Mnemonics.setLocalizedText((JLabel)this.lType, (String)NbBundle.getMessage(AddNewScriptPanel.class, (String)"AddNewScriptPanel.lType.text"));
        this.tfName.setText(NbBundle.getMessage(AddNewScriptPanel.class, (String)"AddNewScriptPanel.tfName.text"));
        Mnemonics.setLocalizedText((JLabel)this.lDesc, (String)NbBundle.getMessage(AddNewScriptPanel.class, (String)"AddNewScriptPanel.lDesc.text"));
        this.taDesc.setColumns(20);
        this.taDesc.setRows(5);
        this.jScrollPane1.setViewportView(this.taDesc);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.lDesc).addComponent(this.lName).addComponent(this.lType)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbType, 0, -1, Short.MAX_VALUE).addComponent(this.tfName).addComponent(this.jScrollPane1, -1, 280, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lName).addComponent(this.tfName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.lType).addComponent(this.cbType, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.lDesc).addGap(0, 64, Short.MAX_VALUE)).addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE)).addContainerGap()));
    }
}

