/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.scheduler;

import com.cronutils.model.Cron;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinition;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.parser.CronParser;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;
import rs.co.ast.aspen.api.service.ApiService;
import rs.co.ast.aspen.api.service.ApiServiceException_Exception;
import rs.co.ast.aspen.api.service.ModuleVersionUtils;
import rs.co.ast.aspen.api.service.ScheduledTask;
import rs.co.ast.aspen.gui.module.scheduler.AddNewTaskPanel;
import rs.co.ast.aspen.gui.module.scheduler.TaskTableModel;
import rs.co.ast.aspen.gui.module.scheduler.TaskTableRenderer;

@TopComponent.Description(preferredID="SchedulerTopComponent", iconBase="rs/co/ast/aspen/gui/module/scheduler/sheduled.png", persistenceType=0)
public final class SchedulerTopComponent
extends TopComponent {
    private static final Logger logger = Logger.getLogger(SchedulerTopComponent.class.getName());
    private ApiService apiService = (ApiService)Lookup.getDefault().lookup(ApiService.class);
    private TaskTableModel tableModel = new TaskTableModel();
    private DateTimeFormatter dtf = ISODateTimeFormat.basicDateTime();
    private List<ScheduledTask> allTasks;
    private int prevRow = 0;
    private CronDefinition cronDefinition = CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.UNIX);
    private CronParser parser = new CronParser(this.cronDefinition);
    private Pattern pat = Pattern.compile("[a-zA-Z0-9-,\\/ ?#*]");
    private Dialog dialog;
    private boolean isCRONValid = false;
    private JButton bDelete;
    private JButton bNew;
    private JButton bReset;
    private JButton bUpdate;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSplitPane jSplitPane1;
    private JTable tTasks;
    private JTextField tfCRON;
    private JTextField tfLastExecuted;
    private JTextField tfScriptName;

    public SchedulerTopComponent() {
        logger.info(String.format("%s version: %s", ModuleVersionUtils.getModuleDisplayName((ModuleVersionUtils.CodeName)ModuleVersionUtils.CodeName.SCHEDULER), ModuleVersionUtils.getModuleVersion((ModuleVersionUtils.CodeName)ModuleVersionUtils.CodeName.SCHEDULER)));
        this.initComponents();
        this.disableButtons();
        this.setName(NbBundle.getMessage(SchedulerTopComponent.class, (String)"CTL_SchedulerTopComponent"));
        this.setToolTipText(NbBundle.getMessage(SchedulerTopComponent.class, (String)"HINT_SchedulerTopComponent"));
        this.tTasks.setDefaultRenderer(ScheduledTask.class, new TaskTableRenderer());
        this.tTasks.setSelectionMode(0);
        this.tTasks.setRowSelectionAllowed(true);
        this.tTasks.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ScheduledTask task = (ScheduledTask)SchedulerTopComponent.this.tableModel.getValueAt(SchedulerTopComponent.this.tTasks.getSelectedRow(), 0);
                if (task != null) {
                    SchedulerTopComponent.this.setTaskProperties(task);
                    SchedulerTopComponent.this.bDelete.setEnabled(true);
                    SchedulerTopComponent.this.bReset.setEnabled(true);
                    SchedulerTopComponent.this.prevRow = SchedulerTopComponent.this.tableModel.getObjectRowPosition(task);
                } else {
                    SchedulerTopComponent.this.prevRow = 0;
                }
            }
        });
        this.tfCRON.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.doChange();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.doChange();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.doChange();
            }

            private void doChange() {
                SchedulerTopComponent.this.checkCRON();
                SchedulerTopComponent.this.checkForChange();
            }
        });
        this.tfCRON.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                this.check(e);
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            private void check(KeyEvent e) {
                char c = e.getKeyChar();
                Matcher m = SchedulerTopComponent.this.pat.matcher(String.valueOf(c));
                if (!m.matches()) {
                    e.consume();
                }
            }
        });
    }

    private void initComponents() {
        this.jSplitPane1 = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.tTasks = new JTable();
        this.bNew = new JButton();
        this.bDelete = new JButton();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.tfLastExecuted = new JTextField();
        this.jLabel4 = new JLabel();
        this.tfCRON = new JTextField();
        this.bUpdate = new JButton();
        this.bReset = new JButton();
        this.jLabel5 = new JLabel();
        this.tfScriptName = new JTextField();
        this.setPreferredSize(new Dimension(800, 600));
        this.jSplitPane1.setDividerLocation(250);
        this.tTasks.setModel(this.tableModel);
        this.tTasks.setColumnSelectionAllowed(true);
        this.jScrollPane1.setViewportView(this.tTasks);
        this.tTasks.getColumnModel().getSelectionModel().setSelectionMode(0);
        if (this.tTasks.getColumnModel().getColumnCount() > 0) {
            this.tTasks.getColumnModel().getColumn(0).setHeaderValue(NbBundle.getMessage(SchedulerTopComponent.class, (String)"SchedulerTopComponent.tTasks.columnModel.title0"));
        }
        Mnemonics.setLocalizedText((AbstractButton)this.bNew, (String)NbBundle.getMessage(SchedulerTopComponent.class, (String)"SchedulerTopComponent.bNew.text"));
        this.bNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SchedulerTopComponent.this.bNewActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.bDelete, (String)NbBundle.getMessage(SchedulerTopComponent.class, (String)"SchedulerTopComponent.bDelete.text"));
        this.bDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SchedulerTopComponent.this.bDeleteActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.bNew).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bDelete).addGap(0, 57, Short.MAX_VALUE)).addComponent(this.jScrollPane1, -2, 0, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.linkSize(0, this.bDelete, this.bNew);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 519, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.bNew).addComponent(this.bDelete)).addContainerGap()));
        this.jSplitPane1.setLeftComponent(this.jPanel1);
        this.jLabel1.setFont(new Font("Ubuntu", 1, 15));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(SchedulerTopComponent.class, (String)"SchedulerTopComponent.jLabel1.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(SchedulerTopComponent.class, (String)"SchedulerTopComponent.jLabel2.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(SchedulerTopComponent.class, (String)"SchedulerTopComponent.jLabel3.text"));
        this.tfLastExecuted.setText(NbBundle.getMessage(SchedulerTopComponent.class, (String)"SchedulerTopComponent.tfLastExecuted.text"));
        this.tfLastExecuted.setEnabled(false);
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(SchedulerTopComponent.class, (String)"SchedulerTopComponent.jLabel4.text"));
        this.tfCRON.setText(NbBundle.getMessage(SchedulerTopComponent.class, (String)"SchedulerTopComponent.tfCRON.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.bUpdate, (String)NbBundle.getMessage(SchedulerTopComponent.class, (String)"SchedulerTopComponent.bUpdate.text"));
        this.bUpdate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SchedulerTopComponent.this.bUpdateActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.bReset, (String)NbBundle.getMessage(SchedulerTopComponent.class, (String)"SchedulerTopComponent.bReset.text"));
        this.bReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SchedulerTopComponent.this.bResetActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(SchedulerTopComponent.class, (String)"SchedulerTopComponent.jLabel5.text"));
        this.tfScriptName.setText(NbBundle.getMessage(SchedulerTopComponent.class, (String)"SchedulerTopComponent.tfScriptName.text"));
        this.tfScriptName.setDisabledTextColor(new Color(51, 51, 51));
        this.tfScriptName.setEnabled(false);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.bUpdate).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bReset).addGap(0, 313, Short.MAX_VALUE)).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addComponent(this.jSeparator1).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel4).addComponent(this.jLabel3).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tfLastExecuted).addComponent(this.tfCRON, -1, 431, Short.MAX_VALUE).addComponent(this.tfScriptName))).addComponent(this.jLabel5, -2, 0, Short.MAX_VALUE)).addContainerGap()));
        jPanel2Layout.linkSize(0, this.bReset, this.bUpdate);
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.tfScriptName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.tfLastExecuted, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.tfCRON, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel5, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 177, Short.MAX_VALUE).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.bUpdate).addComponent(this.bReset)).addContainerGap()));
        this.jSplitPane1.setRightComponent(this.jPanel2);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jSplitPane1, -1, 776, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jSplitPane1).addContainerGap()));
    }

    private void bResetActionPerformed(ActionEvent evt) {
        ScheduledTask task = (ScheduledTask)this.tableModel.getValueAt(this.tTasks.getSelectedRow(), 0);
        if (task != null) {
            this.setTaskProperties(task);
            this.bUpdate.setEnabled(false);
        }
    }

    private void bUpdateActionPerformed(ActionEvent evt) {
        ScheduledTask task = (ScheduledTask)this.tableModel.getValueAt(this.tTasks.getSelectedRow(), 0);
        if (task != null) {
            try {
                this.apiService.updateTask(task.getId(), this.tfScriptName.getText(), this.tfCRON.getText());
                new Updater().execute();
                this.bUpdate.setEnabled(false);
            }
            catch (ApiServiceException_Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void bDeleteActionPerformed(ActionEvent evt) {
        ScheduledTask task;
        NotifyDescriptor.Confirmation d = new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(SchedulerTopComponent.class, (String)"DeleteTaskConfirmation.message"), NbBundle.getMessage(SchedulerTopComponent.class, (String)"DeleteTaskConfirmation.title"), 0);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)d) == NotifyDescriptor.YES_OPTION && (task = (ScheduledTask)this.tableModel.getValueAt(this.tTasks.getSelectedRow(), 0)) != null) {
            try {
                this.apiService.deleteTask(task.getId());
                new Updater().execute();
            }
            catch (ApiServiceException_Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void bNewActionPerformed(ActionEvent evt) {
        final AddNewTaskPanel panel = new AddNewTaskPanel();
        final JButton add = new JButton(NbBundle.getMessage(SchedulerTopComponent.class, (String)"AddNewTask.add"));
        DialogDescriptor d = new DialogDescriptor((Object)panel, NbBundle.getMessage(SchedulerTopComponent.class, (String)"AddNewTask.title"), false, new Object[]{add, DialogDescriptor.CANCEL_OPTION}, (Object)add, 0, HelpCtx.DEFAULT_HELP, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource().equals(add)) {
                    if (panel.isCRONValid()) {
                        boolean success = false;
                        try {
                            SchedulerTopComponent.this.apiService.addTask(panel.getTaskName(), panel.getCRON());
                            new Updater().execute();
                            success = true;
                        }
                        catch (ApiServiceException_Exception ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                        if (success) {
                            SchedulerTopComponent.this.dialog.setVisible(false);
                            SchedulerTopComponent.this.dialog.dispose();
                        }
                    } else {
                        JOptionPane.showMessageDialog(panel, NbBundle.getMessage(SchedulerTopComponent.class, (String)"SchedulerTopComponent.CRON.NotValid"), "", 0);
                    }
                }
            }
        });
        this.dialog = DialogDisplayer.getDefault().createDialog(d);
        this.dialog.setVisible(true);
    }

    public void componentOpened() {
        new Updater().execute();
    }

    public void componentClosed() {
    }

    void writeProperties(Properties p) {
        p.setProperty("version", "1.0");
    }

    void readProperties(Properties p) {
        String version = p.getProperty("version");
    }

    private void setTaskProperties(ScheduledTask task) {
        this.tfScriptName.setText(task.getScriptName());
        if (task.getLastExecuted() > 0L) {
            this.tfLastExecuted.setText(this.dtf.print(task.getLastExecuted().longValue()));
        } else {
            this.tfLastExecuted.setText(NbBundle.getMessage(SchedulerTopComponent.class, (String)"SchedulerTopComponent.never"));
        }
        this.tfCRON.setText(task.getCronSpec());
    }

    private void disableButtons() {
        this.bDelete.setEnabled(false);
        this.bUpdate.setEnabled(false);
        this.bReset.setEnabled(false);
    }

    private boolean checkForChange() {
        ScheduledTask task = (ScheduledTask)this.tableModel.getValueAt(this.tTasks.getSelectedRow(), 0);
        if (task != null) {
            if (!task.getCronSpec().equals(this.tfCRON.getText()) && !this.tfCRON.getText().isEmpty() && this.isCRONValid) {
                this.bUpdate.setEnabled(true);
                return true;
            }
            this.bUpdate.setEnabled(false);
            return false;
        }
        return false;
    }

    public void checkCRON() {
        try {
            Cron cron = this.parser.parse(this.tfCRON.getText());
            cron.validate();
            this.tfCRON.setBorder(UIManager.getBorder("TextField.border"));
            this.tfCRON.repaint();
            this.isCRONValid = true;
        }
        catch (IllegalArgumentException ex) {
            this.tfCRON.setBorder(new LineBorder(Color.RED));
            this.tfCRON.repaint();
            this.isCRONValid = false;
        }
    }

    private void emptyTaskProperties() {
        this.tfScriptName.setText("");
        this.tfLastExecuted.setText("");
        this.tfCRON.setText("");
    }

    public class Updater
    extends SwingWorker<List<ScheduledTask>, Void> {
        @Override
        protected List<ScheduledTask> doInBackground() throws Exception {
            try {
                return SchedulerTopComponent.this.apiService.getAllTasks();
            }
            catch (ApiServiceException_Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return new ArrayList<ScheduledTask>();
            }
        }

        @Override
        protected void done() {
            try {
                SchedulerTopComponent.this.allTasks = (List)this.get();
                if (SchedulerTopComponent.this.allTasks != null) {
                    SchedulerTopComponent.this.tableModel.setData(SchedulerTopComponent.this.allTasks);
                    ScheduledTask task = (ScheduledTask)SchedulerTopComponent.this.tableModel.getValueAt(SchedulerTopComponent.this.tTasks.getSelectedRow(), 0);
                    SchedulerTopComponent.this.prevRow = SchedulerTopComponent.this.tableModel.getObjectRowPosition(task);
                    if (SchedulerTopComponent.this.prevRow == -1) {
                        SchedulerTopComponent.this.prevRow = 0;
                    }
                    int tmp = SchedulerTopComponent.this.prevRow;
                    if (SchedulerTopComponent.this.tTasks.getRowCount() > 0) {
                        SchedulerTopComponent.this.tTasks.setRowSelectionInterval(tmp, tmp);
                        SchedulerTopComponent.this.tTasks.changeSelection(tmp, 0, false, false);
                        SchedulerTopComponent.this.tTasks.repaint();
                    }
                }
            }
            catch (InterruptedException | ExecutionException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

