/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.scheduler;

import com.cronutils.model.Cron;
import com.cronutils.model.CronType;
import com.cronutils.model.definition.CronDefinition;
import com.cronutils.model.definition.CronDefinitionBuilder;
import com.cronutils.parser.CronParser;
import java.awt.Color;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.border.LineBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import rs.co.ast.aspen.api.service.ApiService;
import rs.co.ast.aspen.api.service.ApiServiceException_Exception;
import rs.co.ast.aspen.api.service.Script;
import rs.co.ast.aspen.api.service.ScriptType;

public class AddNewTaskPanel
extends JPanel {
    private static final Logger logger = Logger.getLogger(AddNewTaskPanel.class.getName());
    private ApiService apiService = (ApiService)Lookup.getDefault().lookup(ApiService.class);
    private CronDefinition cronDefinition = CronDefinitionBuilder.instanceDefinitionFor((CronType)CronType.UNIX);
    private CronParser parser = new CronParser(this.cronDefinition);
    private Pattern pat = Pattern.compile("[a-zA-Z0-9-,\\/ ?#*]");
    private boolean isCRONValid = false;
    private JComboBox cbScriptName;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JTextField tfCRON;

    public AddNewTaskPanel() {
        this.initComponents();
        this.tfCRON.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                char c = e.getKeyChar();
                Matcher m = AddNewTaskPanel.this.pat.matcher(String.valueOf(c));
                if (!m.matches()) {
                    e.consume();
                }
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }
        });
        this.tfCRON.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.checkCRON();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.checkCRON();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.checkCRON();
            }

            public void checkCRON() {
                try {
                    Cron cron = AddNewTaskPanel.this.parser.parse(AddNewTaskPanel.this.tfCRON.getText());
                    cron.validate();
                    AddNewTaskPanel.this.tfCRON.setBorder(UIManager.getBorder("TextField.border"));
                    AddNewTaskPanel.this.tfCRON.repaint();
                    AddNewTaskPanel.this.isCRONValid = true;
                }
                catch (IllegalArgumentException ex) {
                    AddNewTaskPanel.this.tfCRON.setBorder(new LineBorder(Color.RED));
                    AddNewTaskPanel.this.tfCRON.repaint();
                    AddNewTaskPanel.this.isCRONValid = false;
                }
            }
        });
        this.fillcbScriptNames();
    }

    public String getTaskName() {
        return this.cbScriptName.getSelectedItem().toString();
    }

    public String getCRON() {
        return this.tfCRON.getText();
    }

    public boolean isCRONValid() {
        return this.isCRONValid;
    }

    public void setIsCRONValid(boolean isCRONValid) {
        this.isCRONValid = isCRONValid;
    }

    private void fillcbScriptNames() {
        try {
            List scriptsByType = this.apiService.getScriptsByType(ScriptType.SCHEDULED);
            for (Script s : scriptsByType) {
                this.cbScriptName.addItem(s.getName());
            }
        }
        catch (ApiServiceException_Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.cbScriptName = new JComboBox();
        this.jLabel2 = new JLabel();
        this.tfCRON = new JTextField();
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(AddNewTaskPanel.class, (String)"AddNewTaskPanel.jLabel1.text"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(AddNewTaskPanel.class, (String)"AddNewTaskPanel.jLabel2.text"));
        this.tfCRON.setText(NbBundle.getMessage(AddNewTaskPanel.class, (String)"AddNewTaskPanel.tfCRON.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbScriptName, 0, 200, Short.MAX_VALUE).addComponent(this.tfCRON)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.cbScriptName, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.tfCRON, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

