/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.datamaps;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Logger;
import org.apache.poi.hssf.model.InternalWorkbook;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.openide.util.Exceptions;
import rs.co.ast.aspen.gui.module.datamaps.ExcelCellObject;
import rs.co.ast.aspen.gui.module.datamaps.ExcelRowObject;
import rs.co.ast.aspen.gui.module.datamaps.ReportDataMapKey;

public class ExportHelper {
    private static final Logger logger = Logger.getLogger(ExportHelper.class.getName());

    public static List<String> getAllUniqueFields(List<ReportDataMapKey> data) {
        HashSet<String> keys = new HashSet<String>();
        ArrayList<String> fields = new ArrayList<String>();
        for (ReportDataMapKey key : data) {
            ExportHelper.getMapKeysRecursion(ExportHelper.json2HashMap(key.getValue()), keys);
        }
        fields.addAll(keys);
        return fields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> json2HashMap(String json) {
        Map map = null;
        ObjectMapper mapper = new ObjectMapper();
        try {
            map = (Map)mapper.readValue(json, (TypeReference)new TypeReference<HashMap<String, Object>>(){});
            return map;
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            return map;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String hashMap2Json(List<ReportDataMapKey> dataMapKeys) {
        String json = "";
        ObjectMapper mapper = new ObjectMapper();
        try {
            json = mapper.writerWithDefaultPrettyPrinter().writeValueAsString(dataMapKeys);
            return json;
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            return json;
        }
    }

    public static HSSFWorkbook makeExcelDocument(String mapName, List<ReportDataMapKey> data, List<String> fields) {
        InternalWorkbook workBook = InternalWorkbook.createWorkbook();
        HSSFWorkbook wb = HSSFWorkbook.create((InternalWorkbook)workBook);
        Map<String, List<ExcelCellObject>> map = ExportHelper.getValuesForFields(data, fields);
        int countFields = ExportHelper.countFields(map);
        if (countFields == 0) {
            return wb;
        }
        int page = 1;
        int row = 0;
        int cell = 0;
        HSSFSheet sheet = wb.createSheet("page " + page);
        HSSFCellStyle style = wb.createCellStyle();
        style.setFillForegroundColor(HSSFColor.HSSFColorPredefined.LIME.getIndex());
        style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        HSSFRow titleRow = sheet.createRow(row++);
        HSSFCell cellKeyCol = titleRow.createCell(cell++);
        cellKeyCol.setCellValue("key");
        for (int i = 0; i < fields.size(); ++i) {
            String field = fields.get(i);
            cellKeyCol = titleRow.createCell(cell++);
            cellKeyCol.setCellValue(field);
        }
        for (String key : map.keySet()) {
            int i;
            List<ExcelCellObject> val = map.get(key);
            HSSFRow xrow = null;
            HSSFCell cellKey = null;
            for (i = 0; i < val.size(); i += countFields) {
                xrow = sheet.createRow(row++);
                cell = 0;
                cellKey = xrow.createCell(cell++);
                cellKey.setCellValue(key);
                for (int j = i; j < countFields + i; ++j) {
                    ExcelCellObject excelCellObj = val.get(j);
                    cellKey = xrow.createCell(cell++);
                    cellKey.setCellValue(excelCellObj.getValue());
                }
                if (row != 65536) continue;
                row = 1;
                row = 1;
                sheet = wb.createSheet("page " + ++page);
            }
            for (i = 0; i < countFields + 1; ++i) {
                sheet.autoSizeColumn(i);
            }
        }
        return wb;
    }

    public static HSSFWorkbook makeExcelMultiSheetDocument(String mapName, List<ReportDataMapKey> data, List<String> fields) {
        InternalWorkbook workBook = InternalWorkbook.createWorkbook();
        HSSFWorkbook wb = HSSFWorkbook.create((InternalWorkbook)workBook);
        Map<String, List<ExcelCellObject>> map = ExportHelper.getValuesForFields(data, fields);
        int countFields = ExportHelper.countFields(map);
        if (countFields == 0) {
            return wb;
        }
        for (String key : map.keySet()) {
            int i;
            List<ExcelCellObject> val = map.get(key);
            String sheetName = key.replace("[", "").replace("]", "");
            if (sheetName.length() >= 31) {
                sheetName = sheetName.substring(0, 31);
            }
            if (workBook.doesContainsSheetName(sheetName, -1)) {
                sheetName = UUID.randomUUID().toString();
            }
            HSSFSheet sheet = wb.createSheet(sheetName);
            HSSFCellStyle style = wb.createCellStyle();
            style.setFillForegroundColor(HSSFColor.HSSFColorPredefined.LIME.getIndex());
            style.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            HSSFRow titleRow = sheet.createRow(0);
            for (int i2 = 0; i2 < countFields; ++i2) {
                ExcelCellObject excelCellObj = val.get(i2);
                HSSFCell cellKey = titleRow.createCell(i2);
                cellKey.setCellValue(excelCellObj.getKey());
            }
            HSSFRow row = null;
            HSSFCell cellKey = null;
            int rowCount = 1;
            for (i = 0; i < val.size(); i += countFields) {
                row = sheet.createRow(rowCount++);
                int cellCount = 0;
                for (int j = i; j < countFields + i; ++j) {
                    ExcelCellObject excelCellObj = val.get(j);
                    cellKey = row.createCell(cellCount++);
                    cellKey.setCellValue(excelCellObj.getValue());
                }
            }
            for (i = 0; i < countFields; ++i) {
                sheet.autoSizeColumn(i);
            }
        }
        return wb;
    }

    private static int countFields(Map<String, List<ExcelCellObject>> map) {
        int max = 0;
        String theKey = "";
        for (String key : map.keySet()) {
            List<ExcelCellObject> get = map.get(key);
            if (get.size() <= max) continue;
            max = get.size();
            theKey = key;
        }
        List<ExcelCellObject> val = map.get(theKey);
        if (val != null && !val.isEmpty()) {
            ExcelCellObject ref = val.get(0);
            for (int i = 1; i < val.size(); ++i) {
                if (!ref.getKey().equals(val.get(i).getKey())) continue;
                return i;
            }
        }
        return max;
    }

    public static Map<String, List<ExcelCellObject>> getValuesForFields(List<ReportDataMapKey> data, List<String> fields) {
        HashMap<String, List<ExcelCellObject>> mapRows = new HashMap<String, List<ExcelCellObject>>();
        for (ReportDataMapKey key : data) {
            Map<String, Object> map = ExportHelper.json2HashMap(key.getValue());
            ArrayList<ExcelCellObject> list = new ArrayList<ExcelCellObject>();
            ExportHelper.mapRecursion(map, fields, list);
            mapRows.put(key.getKey(), list);
        }
        return mapRows;
    }

    private static void mapRecursion(Map<String, Object> map, List<String> fields, List<ExcelCellObject> list) {
        try {
            for (String key : map.keySet()) {
                Object obj = map.get(key);
                if (fields.contains(key)) {
                    String val;
                    if (obj instanceof Map) {
                        ObjectMapper mapper = new ObjectMapper();
                        val = mapper.writeValueAsString(obj);
                        ExportHelper.mapRecursion((Map)obj, fields, list);
                    } else {
                        val = obj instanceof String ? (String)obj : (obj instanceof Integer ? ((Integer)obj).toString() : obj.toString());
                    }
                    ExcelCellObject ero = new ExcelCellObject(key, val);
                    list.add(ero);
                    continue;
                }
                if (!(obj instanceof Map)) continue;
                ExportHelper.mapRecursion((Map)obj, fields, list);
            }
        }
        catch (JsonProcessingException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private static void getMapKeysRecursion(Map<String, Object> map, Set<String> keys) {
        for (String key : map.keySet()) {
            Object obj = map.get(key);
            if (obj instanceof Map) {
                ExportHelper.getMapKeysRecursion((Map)obj, keys);
                continue;
            }
            keys.add(key);
        }
    }

    private static List<ExcelRowObject> getExcelRows(Map<String, Object> map) {
        ArrayList<ExcelRowObject> list = new ArrayList<ExcelRowObject>();
        if (map != null) {
            for (String key : map.keySet()) {
                Object val = map.get(key);
                if (!(val instanceof Map)) continue;
                list.add(new ExcelRowObject(key, (Map)val));
            }
        }
        return list;
    }
}

