/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.shader;

import com.jme3.asset.AssetManager;
import com.jme3.material.ShaderGenerationInfo;
import com.jme3.material.plugins.ConditionParser;
import com.jme3.shader.Shader;
import com.jme3.shader.ShaderGenerator;
import com.jme3.shader.ShaderNode;
import com.jme3.shader.ShaderNodeDefinition;
import com.jme3.shader.ShaderNodeVariable;
import com.jme3.shader.VariableMapping;
import java.util.ArrayList;
import java.util.List;

public class Glsl100ShaderGenerator
extends ShaderGenerator {
    private static final String INDENTCHAR = "\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t\t";
    protected ShaderNodeVariable inPosTmp;

    public Glsl100ShaderGenerator(AssetManager assetManager) {
        super(assetManager);
    }

    @Override
    protected void generateUniforms(StringBuilder source, ShaderGenerationInfo info, Shader.ShaderType type) {
        this.generateUniforms(source, type == Shader.ShaderType.Vertex ? info.getVertexUniforms() : info.getFragmentUniforms());
    }

    protected void generateUniforms(StringBuilder source, List<ShaderNodeVariable> uniforms) {
        source.append("\n");
        for (ShaderNodeVariable var : uniforms) {
            this.declareVariable(source, var, false, "uniform");
        }
    }

    @Override
    protected void generateAttributes(StringBuilder source, ShaderGenerationInfo info) {
        source.append("\n");
        boolean inPosition = false;
        for (ShaderNodeVariable var : info.getAttributes()) {
            if (var.getName().equals("inPosition")) {
                inPosition = true;
                var.setCondition(null);
                this.fixInPositionType(var);
                this.inPosTmp = var;
            }
            this.declareAttribute(source, var);
        }
        if (!inPosition) {
            this.inPosTmp = new ShaderNodeVariable("vec3", "inPosition");
            this.declareAttribute(source, this.inPosTmp);
        }
    }

    @Override
    protected void generateVaryings(StringBuilder source, ShaderGenerationInfo info, Shader.ShaderType type) {
        source.append("\n");
        for (ShaderNodeVariable var : info.getVaryings()) {
            this.declareVarying(source, var, type != Shader.ShaderType.Vertex);
        }
    }

    @Override
    protected void generateDeclarativeSection(StringBuilder source, ShaderNode shaderNode, String nodeSource, ShaderGenerationInfo info) {
        if (nodeSource.replaceAll("\\n", "").trim().length() > 0) {
            nodeSource = this.updateDefinesName(nodeSource, shaderNode);
            source.append("\n");
            this.unIndent();
            this.startCondition(shaderNode.getCondition(), source);
            source.append(nodeSource);
            source.append("\n");
            this.endCondition(shaderNode.getCondition(), source);
            this.indent();
        }
    }

    @Override
    protected void generateStartOfMainSection(StringBuilder source, ShaderGenerationInfo info, Shader.ShaderType type) {
        source.append("\n");
        source.append("void main() {\n");
        this.indent();
        this.appendIndent(source);
        if (type == Shader.ShaderType.Vertex) {
            this.declareGlobalPosition(info, source);
        } else if (type == Shader.ShaderType.Fragment) {
            for (ShaderNodeVariable global : info.getFragmentGlobals()) {
                this.declareVariable(source, global, "vec4(1.0)");
            }
        }
        source.append("\n");
    }

    @Override
    protected void generateEndOfMainSection(StringBuilder source, ShaderGenerationInfo info, Shader.ShaderType type) {
        source.append("\n");
        if (type == Shader.ShaderType.Vertex) {
            this.appendOutput(source, "gl_Position", info.getVertexGlobal());
        } else if (type == Shader.ShaderType.Fragment) {
            List<ShaderNodeVariable> globals = info.getFragmentGlobals();
            if (globals.size() == 1) {
                this.appendOutput(source, "gl_FragColor", globals.get(0));
            } else {
                int i = 0;
                for (ShaderNodeVariable global : globals) {
                    this.appendOutput(source, "gl_FragData[" + i + "]", global);
                    ++i;
                }
            }
        }
        this.unIndent();
        this.appendIndent(source);
        source.append("}\n");
    }

    protected void appendOutput(StringBuilder source, String globalOutputName, ShaderNodeVariable var) {
        this.appendIndent(source);
        source.append(globalOutputName);
        source.append(" = ");
        source.append(var.getNameSpace());
        source.append("_");
        source.append(var.getName());
        source.append(";\n");
    }

    @Override
    protected void generateNodeMainSection(StringBuilder source, ShaderNode shaderNode, String nodeSource, ShaderGenerationInfo info) {
        nodeSource = this.updateDefinesName(nodeSource, shaderNode);
        source.append("\n");
        this.comment(source, shaderNode, "Begin");
        this.startCondition(shaderNode.getCondition(), source);
        ArrayList<String> declaredInputs = new ArrayList<String>();
        for (VariableMapping mapping : shaderNode.getInputMapping()) {
            String newName;
            ShaderNodeVariable rightVariable = mapping.getRightVariable();
            ShaderNodeVariable leftVariable = mapping.getLeftVariable();
            if (this.isWorldOrMaterialParam(rightVariable) && rightVariable.getType().startsWith("sampler")) {
                nodeSource = this.replace(nodeSource, leftVariable, rightVariable.getPrefix() + rightVariable.getName());
            } else {
                if (leftVariable.getType().startsWith("sampler")) {
                    throw new IllegalArgumentException("a Sampler must be a uniform");
                }
                this.map(mapping, source);
            }
            if (declaredInputs.contains(newName = shaderNode.getName() + "_" + leftVariable.getName())) continue;
            nodeSource = this.replace(nodeSource, leftVariable, newName);
            declaredInputs.add(newName);
        }
        ShaderNodeDefinition definition = shaderNode.getDefinition();
        for (ShaderNodeVariable var : definition.getInputs()) {
            String fullName;
            if (var.getDefaultValue() == null || declaredInputs.contains(fullName = shaderNode.getName() + "_" + var.getName())) continue;
            ShaderNodeVariable variable = new ShaderNodeVariable(var.getType(), shaderNode.getName(), var.getName(), var.getMultiplicity());
            if (!this.isVarying(info, variable)) {
                this.declareVariable(source, variable, var.getDefaultValue(), true, null);
            }
            nodeSource = this.replaceVariableName(nodeSource, variable);
            declaredInputs.add(fullName);
        }
        for (ShaderNodeVariable var : definition.getOutputs()) {
            ShaderNodeVariable v = new ShaderNodeVariable(var.getType(), shaderNode.getName(), var.getName(), var.getMultiplicity());
            if (declaredInputs.contains(shaderNode.getName() + "_" + var.getName())) continue;
            if (!this.isVarying(info, v)) {
                this.declareVariable(source, v);
            }
            nodeSource = this.replaceVariableName(nodeSource, v);
        }
        source.append(nodeSource);
        for (VariableMapping mapping : shaderNode.getOutputMapping()) {
            this.map(mapping, source);
        }
        this.endCondition(shaderNode.getCondition(), source);
        this.comment(source, shaderNode, "End");
    }

    protected void declareVariable(StringBuilder source, ShaderNodeVariable var, boolean appendNameSpace) {
        this.declareVariable(source, var, appendNameSpace, null);
    }

    protected void declareVariable(StringBuilder source, ShaderNodeVariable var) {
        this.declareVariable(source, var, true, null);
    }

    protected void declareVariable(StringBuilder source, ShaderNodeVariable var, String value) {
        this.declareVariable(source, var, value, true, null);
    }

    protected void declareVariable(StringBuilder source, ShaderNodeVariable var, boolean appendNameSpace, String modifier) {
        this.declareVariable(source, var, null, appendNameSpace, modifier);
    }

    protected void declareVariable(StringBuilder source, ShaderNodeVariable var, String value, boolean appendNameSpace, String modifier) {
        this.startCondition(var.getCondition(), source);
        this.appendIndent(source);
        if (modifier != null) {
            source.append(modifier);
            source.append(" ");
        }
        source.append(var.getType());
        source.append(" ");
        if (appendNameSpace) {
            source.append(var.getNameSpace());
            source.append("_");
        }
        source.append(var.getPrefix());
        source.append(var.getName());
        if (var.getMultiplicity() != null) {
            source.append("[");
            source.append(var.getMultiplicity().toUpperCase());
            source.append("]");
        }
        if (value != null) {
            source.append(" = ");
            source.append(value);
        }
        source.append(";\n");
        this.endCondition(var.getCondition(), source);
    }

    protected void startCondition(String condition, StringBuilder source) {
        if (condition != null) {
            this.appendIndent(source);
            source.append("#if ");
            source.append(condition);
            source.append("\n");
            this.indent();
        }
    }

    protected void endCondition(String condition, StringBuilder source) {
        if (condition != null) {
            this.unIndent();
            this.appendIndent(source);
            source.append("#endif\n");
        }
    }

    protected void map(VariableMapping mapping, StringBuilder source) {
        this.startCondition(mapping.getCondition(), source);
        this.appendIndent(source);
        if (!mapping.getLeftVariable().isShaderOutput()) {
            source.append(mapping.getLeftVariable().getType());
            source.append(" ");
        }
        source.append(mapping.getLeftVariable().getNameSpace());
        source.append("_");
        source.append(mapping.getLeftVariable().getName());
        if (mapping.getLeftVariable().getMultiplicity() != null) {
            source.append("[");
            source.append(mapping.getLeftVariable().getMultiplicity());
            source.append("]");
        }
        if (mapping.getLeftSwizzling().length() > 0) {
            source.append(" = ");
            source.append(mapping.getLeftVariable().getType());
            source.append("(0.0);\n");
            this.appendIndent(source);
            source.append(mapping.getLeftVariable().getNameSpace());
            source.append("_");
            source.append(mapping.getLeftVariable().getName());
            source.append(".");
            source.append(mapping.getLeftSwizzling());
        }
        source.append(" = ");
        String namePrefix = this.getAppendableNameSpace(mapping.getRightVariable());
        source.append(namePrefix);
        source.append(mapping.getRightVariable().getPrefix());
        source.append(mapping.getRightVariable().getName());
        if (mapping.getRightSwizzling().length() > 0) {
            source.append(".");
            source.append(mapping.getRightSwizzling());
        }
        source.append(";\n");
        this.endCondition(mapping.getCondition(), source);
    }

    protected String replaceVariableName(String nodeSource, ShaderNodeVariable var) {
        String namePrefix = this.getAppendableNameSpace(var);
        String newName = namePrefix + var.getName();
        nodeSource = this.replace(nodeSource, var, newName);
        return nodeSource;
    }

    protected boolean isVarying(ShaderGenerationInfo info, ShaderNodeVariable v) {
        boolean isVarying = false;
        for (ShaderNodeVariable shaderNodeVariable : info.getVaryings()) {
            if (!shaderNodeVariable.equals(v)) continue;
            isVarying = true;
        }
        return isVarying;
    }

    protected void comment(StringBuilder source, ShaderNode shaderNode, String comment) {
        this.appendIndent(source);
        source.append("//");
        source.append(shaderNode.getName());
        source.append(" : ");
        source.append(comment);
        source.append("\n");
    }

    protected String getAppendableNameSpace(ShaderNodeVariable var) {
        String namePrefix = var.getNameSpace() + "_";
        if (namePrefix.equals("Attr_") || namePrefix.equals("WorldParam_") || namePrefix.equals("MatParam_")) {
            namePrefix = "";
        }
        return namePrefix;
    }

    protected String updateDefinesName(String nodeSource, ShaderNode shaderNode) {
        String[] lines = nodeSource.split("\\n");
        ConditionParser parser = new ConditionParser();
        for (String line : lines) {
            if (!line.trim().startsWith("#if")) continue;
            List<String> params = parser.extractDefines(line.trim());
            String l = line.trim().replaceAll("defined", "").replaceAll("#if ", "").replaceAll("#ifdef", "");
            boolean match = false;
            for (String param : params) {
                for (VariableMapping map : shaderNode.getInputMapping()) {
                    if (!map.getLeftVariable().getName().equals(param) || map.getCondition() == null) continue;
                    l = l.replaceAll(param, map.getCondition());
                    match = true;
                }
            }
            if (!match) continue;
            nodeSource = nodeSource.replace(line.trim(), "#if " + l);
        }
        return nodeSource;
    }

    protected String replace(String nodeSource, ShaderNodeVariable var, String newName) {
        nodeSource = nodeSource.replaceAll("(?<=\\W)" + var.getName() + "(?=\\W)", newName);
        return nodeSource;
    }

    protected boolean isWorldOrMaterialParam(ShaderNodeVariable var) {
        return var.getNameSpace().equals("MatParam") || var.getNameSpace().equals("WorldParam");
    }

    @Override
    protected String getLanguageAndVersion(Shader.ShaderType type) {
        return "GLSL100";
    }

    protected void appendIndent(StringBuilder source) {
        source.append(INDENTCHAR.substring(0, this.indent));
    }

    protected void declareAttribute(StringBuilder source, ShaderNodeVariable var) {
        this.declareVariable(source, var, false, "attribute");
    }

    protected void declareVarying(StringBuilder source, ShaderNodeVariable var, boolean input) {
        this.declareVariable(source, var, true, "varying");
    }

    protected void unIndent() {
        --this.indent;
        this.indent = Math.max(0, this.indent);
    }

    protected void indent() {
        ++this.indent;
        this.indent = Math.min(10, this.indent);
    }

    protected void fixInPositionType(ShaderNodeVariable var) {
        if (!var.getType().equals("vec3") || !var.getType().equals("vec4")) {
            var.setType("vec3");
        }
    }

    protected void declareGlobalPosition(ShaderGenerationInfo info, StringBuilder source) {
        if (this.inPosTmp.getType().equals(info.getVertexGlobal().getType())) {
            this.declareVariable(source, info.getVertexGlobal(), "inPosition");
        } else {
            this.declareVariable(source, info.getVertexGlobal(), "vec4(inPosition,1.0)");
        }
    }
}

