/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.prseditor;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.explorer.ExplorerManager;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;
import rs.co.ast.aspen.api.service.ParsingRuleAssignment;
import rs.co.ast.aspen.api.service.ParsingRuleMetaRule;
import rs.co.ast.aspen.api.service.ParsingRuleTestCase;
import rs.co.ast.aspen.core.module.prsmodel.RuleSetModel;
import rs.co.ast.aspen.core.module.prsmodel.dto.ParsingRuleDTOWrapper;
import rs.co.ast.aspen.core.module.prsmodel.dto.ParsingRulesGroupDTOWrapper;
import rs.co.ast.aspen.gui.module.prseditor.AssignmentPanel;
import rs.co.ast.aspen.gui.module.prseditor.JumpToDialog;
import rs.co.ast.aspen.gui.module.prseditor.MetaRulePanel;
import rs.co.ast.aspen.gui.module.prseditor.ParsingRulesetEditorTopComponent;
import rs.co.ast.aspen.gui.module.prseditor.RegExpDebuggerPanel;
import rs.co.ast.aspen.gui.module.prseditor.TestCaseCheckPanel;
import rs.co.ast.aspen.gui.module.prseditor.TestCasesTableRenderer;
import rs.co.ast.aspen.gui.module.prseditor.models.FocusGroupService;
import rs.co.ast.aspen.gui.module.prseditor.models.TestCasesTableModel;
import rs.co.ast.aspen.gui.module.prseditor.nodes.RulesGroupNode;

public class RuleDetailsPanel
extends JPanel
implements ExplorerManager.Provider,
PropertyChangeListener {
    private RuleSetModel model = (RuleSetModel)Lookup.getDefault().lookup(RuleSetModel.class);
    private FocusGroupService groupService = (FocusGroupService)Lookup.getDefault().lookup(FocusGroupService.class);
    private final Lookup.Result<ParsingRuleDTOWrapper> lr = Utilities.actionsGlobalContext().lookupResult(ParsingRuleDTOWrapper.class);
    private final TestCasesTableModel testCasesTableModel = new TestCasesTableModel();
    private ParsingRuleDTOWrapper rule;
    private ParsingRulesGroupDTOWrapper group;
    private ExplorerManager explorerManager = new ExplorerManager();
    private InstanceContent instanceContentMetaRule = new InstanceContent();
    private Lookup selectedMetaRule = new AbstractLookup((AbstractLookup.Content)this.instanceContentMetaRule);
    private InstanceContent instanceContentAssignment = new InstanceContent();
    private Lookup selectedAssignment = new AbstractLookup((AbstractLookup.Content)this.instanceContentAssignment);
    private InstanceContent instanceContentTestCase = new InstanceContent();
    private Lookup selectedTestCase = new AbstractLookup((AbstractLookup.Content)this.instanceContentTestCase);
    private int x;
    private int y;
    private Collection<? extends Action> editModeActions = Lookups.forPath((String)"Actions/EditMode").lookupAll(Action.class);
    private Collection<? extends Action> testCaseActions = Lookups.forPath((String)"Actions/RightClickTestCase").lookupAll(Action.class);
    private JButton bAction;
    private JButton bAddAssignment;
    private JButton bAddMetaRule;
    private JButton bAddTestCase;
    private JButton bBuildRegexp;
    private JComboBox cbCategory;
    private JComboBox cbKey;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JScrollPane jScrollPane4;
    private JScrollPane jScrollPane5;
    private JScrollPane jScrollPane6;
    private JScrollPane jScrollPane7;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JSeparator jSeparator4;
    private JSplitPane jSplitPane1;
    private JSplitPane jSplitPane2;
    private JTabbedPane jTabbedPane1;
    private JPanel pAssignments;
    private JPanel pChecks;
    private JPanel pMetaRules;
    private JPanel pTestCase;
    private JPopupMenu pmAction;
    private JPopupMenu pmTestCase;
    private JRadioButtonMenuItem rbContinueParsing;
    private JRadioButtonMenuItem rbJumpToGroup;
    private JRadioButtonMenuItem rbSilent;
    private JRadioButtonMenuItem rbStopParsing;
    private JTable tTestCases;
    private JTextArea taRegexp;
    private JToggleButton tbType;
    private JTextField tfValue;

    public RuleDetailsPanel() {
        this.initComponents();
        this.addAncestorListener(new MyAncestorListener(this).getAncestorListener());
        this.initPopupMenus();
        this.setEditable(this.model.isEditMode());
        this.pChecks.setLayout(new BoxLayout(this.pChecks, 1));
        ButtonGroup btnGroup = new ButtonGroup();
        btnGroup.add(this.rbStopParsing);
        btnGroup.add(this.rbSilent);
        btnGroup.add(this.rbContinueParsing);
        btnGroup.add(this.rbJumpToGroup);
        this.lr.allInstances();
        this.lr.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent ev) {
                Lookup.Result lookupResult = (Lookup.Result)ev.getSource();
                Collection instances = lookupResult.allInstances();
                for (Object o : instances) {
                    if (!(o instanceof ParsingRuleDTOWrapper)) continue;
                    RuleDetailsPanel.this.rule = (ParsingRuleDTOWrapper)o;
                    RuleDetailsPanel.this.updateDisplay(RuleDetailsPanel.this.rule);
                }
            }
        });
        this.taRegexp.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
            }

            @Override
            public void focusLost(FocusEvent e) {
                String text = RuleDetailsPanel.this.taRegexp.getText();
                String regex = RuleDetailsPanel.this.rule.getRegexp();
                if (regex == null) {
                    regex = "";
                }
                if (!regex.equals(text)) {
                    String tmp = RuleDetailsPanel.this.taRegexp.getText();
                    RuleDetailsPanel.this.model.setRuleRegexp(RuleDetailsPanel.this.rule, tmp);
                    RuleDetailsPanel.this.taRegexp.setCaretPosition(RuleDetailsPanel.this.taRegexp.getText().length());
                }
            }
        });
        this.rbStopParsing.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RuleDetailsPanel.this.updateActionButton();
                RuleDetailsPanel.this.model.setRuleContinueParsing(RuleDetailsPanel.this.rule, false);
            }
        });
        this.rbSilent.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RuleDetailsPanel.this.updateActionButton();
                RuleDetailsPanel.this.model.setRuleSilent(RuleDetailsPanel.this.rule, true);
            }
        });
        this.rbContinueParsing.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RuleDetailsPanel.this.updateActionButton();
                RuleDetailsPanel.this.model.setRuleContinueParsing(RuleDetailsPanel.this.rule, true);
            }
        });
        this.rbJumpToGroup.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                final JumpToDialog dialog = new JumpToDialog();
                dialog.setVisible(true);
                dialog.setFocusable(true);
                dialog.setFocusableWindowState(true);
                dialog.addWindowFocusListener(new WindowFocusListener(){

                    @Override
                    public void windowGainedFocus(WindowEvent e) {
                    }

                    @Override
                    public void windowLostFocus(WindowEvent e) {
                        dialog.setVisible(false);
                    }
                });
                dialog.addWindowListener(new WindowListener(){

                    @Override
                    public void windowOpened(WindowEvent e) {
                    }

                    @Override
                    public void windowClosing(WindowEvent e) {
                    }

                    @Override
                    public void windowClosed(WindowEvent e) {
                    }

                    @Override
                    public void windowIconified(WindowEvent e) {
                    }

                    @Override
                    public void windowDeiconified(WindowEvent e) {
                    }

                    @Override
                    public void windowActivated(WindowEvent e) {
                    }

                    @Override
                    public void windowDeactivated(WindowEvent e) {
                        Object selectedNode;
                        if (dialog.isOk() && (selectedNode = dialog.getSelectedNode()) instanceof RulesGroupNode) {
                            RulesGroupNode groupNode = (RulesGroupNode)selectedNode;
                            RuleDetailsPanel.this.group = groupNode.getGroup();
                            if (RuleDetailsPanel.this.rule != null && RuleDetailsPanel.this.group != null) {
                                RuleDetailsPanel.this.model.setRuleJumpTo(RuleDetailsPanel.this.rule, RuleDetailsPanel.this.group.getId());
                            }
                            RuleDetailsPanel.this.updateActionButton();
                        }
                    }
                });
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                RuleDetailsPanel.this.x = e.getX();
                RuleDetailsPanel.this.y = e.getY();
            }
        });
        this.tTestCases.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (RuleDetailsPanel.this.tTestCases.getSelectedRow() > -1) {
                    RuleDetailsPanel.this.updateChecksPanel();
                } else {
                    RuleDetailsPanel.this.pChecks.removeAll();
                    RuleDetailsPanel.this.refreshChecksGUI();
                }
            }
        });
        this.tTestCases.setDefaultRenderer(ParsingRuleTestCase.class, new TestCasesTableRenderer());
        this.tTestCases.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.getButton() == 3) {
                    int row = RuleDetailsPanel.this.tTestCases.rowAtPoint(e.getPoint());
                    int column = RuleDetailsPanel.this.tTestCases.columnAtPoint(e.getPoint());
                    if (!RuleDetailsPanel.this.tTestCases.isRowSelected(row)) {
                        RuleDetailsPanel.this.tTestCases.setRowSelectionInterval(row, row);
                        RuleDetailsPanel.this.tTestCases.changeSelection(row, column, false, false);
                    }
                    RuleDetailsPanel.this.pmTestCase.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.tTestCases.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting() && RuleDetailsPanel.this.tTestCases.getSelectedRowCount() == 1) {
                    ArrayList<ParsingRuleTestCase> testCases = new ArrayList<ParsingRuleTestCase>();
                    ParsingRuleTestCase testCase = RuleDetailsPanel.this.testCasesTableModel.getTestCase(RuleDetailsPanel.this.tTestCases.getSelectedRow());
                    testCases.add(testCase);
                    RuleDetailsPanel.this.instanceContentTestCase.set(testCases, null);
                }
            }
        });
        this.cbCategory.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                RequestProcessor.getDefault().execute(new Runnable(){

                    @Override
                    public void run() {
                        RuleDetailsPanel.this.updateKeys((String)RuleDetailsPanel.this.cbCategory.getSelectedItem());
                    }
                });
            }
        });
        this.updateKeys((String)this.cbCategory.getSelectedItem());
    }

    private void initPopupMenus() {
        JMenuItem item;
        this.pmTestCase.removeAll();
        if (this.model.isEditMode()) {
            for (Action action : this.testCaseActions) {
                item = new JMenuItem(action);
                this.pmTestCase.add(item);
            }
        }
        for (Action action : this.editModeActions) {
            item = new JMenuItem(action);
            this.pmTestCase.add(item);
        }
    }

    private void updateKeys(String category) {
        List mappingsForCategory = this.model.getMappingsForCategory(category);
        this.cbKey.removeAllItems();
        if (mappingsForCategory != null) {
            for (String s : mappingsForCategory) {
                this.cbKey.addItem(s);
            }
        }
    }

    private void updateChecksPanel() {
        this.pChecks.removeAll();
        ParsingRuleTestCase testCase = this.testCasesTableModel.getTestCase(this.tTestCases.getSelectedRow());
        ParsingRuleTestCase.Checks checks = testCase.getChecks();
        if (checks != null && checks.getEntry() != null) {
            for (ParsingRuleTestCase.Checks.Entry n : checks.getEntry()) {
                TestCaseCheckPanel checkPanel = new TestCaseCheckPanel(this.rule, n.getValue());
                this.pChecks.add(checkPanel);
            }
            this.refreshChecksGUI();
        }
    }

    private void refreshChecksGUI() {
        this.pChecks.validate();
        this.pChecks.repaint();
        this.jScrollPane6.validate();
        this.jScrollPane6.repaint();
        this.jPanel2.validate();
        this.jPanel2.repaint();
    }

    public Lookup getSelectedMetaRuleLookup() {
        return this.selectedMetaRule;
    }

    public Lookup getSelectedAssignmentLookup() {
        return this.selectedAssignment;
    }

    public Lookup getSelectedTestCaseLookup() {
        return this.selectedTestCase;
    }

    public ExplorerManager getExplorerManager() {
        return this.explorerManager;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!evt.getPropertyName().equals("ancestor")) {
            switch (evt.getPropertyName()) {
                case "ruleChanged": {
                    this.firePropertyChange("ruleChanged", "", this.rule);
                    break;
                }
                case "editModeChanged": {
                    Component[] components;
                    for (Component c : components = this.pChecks.getComponents()) {
                        if (!(c instanceof TestCaseCheckPanel)) continue;
                        TestCaseCheckPanel p = (TestCaseCheckPanel)c;
                        p.toggleEditable();
                    }
                    this.setEditable(this.model.isEditMode());
                    this.initPopupMenus();
                }
            }
        }
    }

    private void setEditable(boolean edit) {
        this.taRegexp.setEditable(edit);
        this.cbCategory.setEditable(edit);
        this.cbCategory.setEnabled(edit);
        this.cbKey.setEditable(edit);
        this.cbKey.setEnabled(edit);
        this.tfValue.setEditable(edit);
        this.tfValue.setEnabled(edit);
        this.tbType.setEnabled(edit);
        this.bAddTestCase.setEnabled(edit);
        this.bAddMetaRule.setEnabled(edit);
        this.bAddAssignment.setEnabled(edit);
    }

    public void updateDisplay(ParsingRuleDTOWrapper rule) {
        if (rule != null) {
            this.taRegexp.setText(rule.getRegexp());
            this.taRegexp.select(0, 0);
            this.updateActionButton();
            this.pMetaRules.removeAll();
            for (ParsingRuleMetaRule m : rule.getMetaRules()) {
                this.pMetaRules.add(new MetaRulePanel(m));
            }
            this.pMetaRules.validate();
            this.pMetaRules.repaint();
            this.pMetaRules.getParent().validate();
            this.pMetaRules.getParent().repaint();
            this.pAssignments.removeAll();
            for (ParsingRuleAssignment a : rule.getAssignments()) {
                this.pAssignments.add(new AssignmentPanel(a));
            }
            this.pAssignments.validate();
            this.pAssignments.repaint();
            this.pAssignments.getParent().validate();
            this.pAssignments.getParent().repaint();
            this.testCasesTableModel.setData(rule.getTestCases());
        } else {
            this.taRegexp.setText("");
            this.bAction.setText(NbBundle.getMessage(ParsingRulesetEditorTopComponent.class, (String)"RuleJumpTo.none"));
            this.pMetaRules.removeAll();
            this.pAssignments.removeAll();
            this.testCasesTableModel.setData(null);
        }
        this.pChecks.removeAll();
        this.refreshChecksGUI();
    }

    private void updateActionButton() {
        boolean silent;
        boolean continueParsing = this.rule.isContinueParsing() == null ? false : this.rule.isContinueParsing();
        boolean bl = silent = this.rule.isSilent() == null ? false : this.rule.isSilent();
        if (continueParsing) {
            this.bAction.setText(NbBundle.getMessage(ParsingRulesetEditorTopComponent.class, (String)"RuleDetailsPanel.action.continueParsing"));
            this.rbContinueParsing.setSelected(true);
        } else if (silent) {
            this.bAction.setText(NbBundle.getMessage(ParsingRulesetEditorTopComponent.class, (String)"RuleDetailsPanel.action.silent"));
            this.rbSilent.setSelected(true);
        } else if (this.rule.getMatchedGroupId() != null) {
            this.group = this.model.getGroup(this.rule.getMatchedGroupId());
            StringBuilder sb = new StringBuilder();
            sb.append("<html>");
            sb.append(NbBundle.getMessage(ParsingRulesetEditorTopComponent.class, (String)"RuleJumpTo.none"));
            sb.append(" <strong>");
            if (this.group != null) {
                sb.append(this.group.getName());
            } else {
                sb.append("Group not found!");
            }
            sb.append("</strong></html>");
            this.bAction.setText(sb.toString());
            this.rbJumpToGroup.setSelected(true);
        } else {
            this.bAction.setText(NbBundle.getMessage(ParsingRulesetEditorTopComponent.class, (String)"RuleJumpTo.stopParsing"));
            this.rbStopParsing.setSelected(true);
            this.rbContinueParsing.setSelected(false);
            this.rbSilent.setSelected(false);
            this.rbJumpToGroup.setSelected(false);
        }
    }

    private void initComponents() {
        this.pmAction = new JPopupMenu();
        this.rbStopParsing = new JRadioButtonMenuItem();
        this.rbSilent = new JRadioButtonMenuItem();
        this.rbContinueParsing = new JRadioButtonMenuItem();
        this.rbJumpToGroup = new JRadioButtonMenuItem();
        this.pmTestCase = new JPopupMenu();
        this.jLabel1 = new JLabel();
        this.bAction = new JButton();
        this.bBuildRegexp = new JButton();
        this.jScrollPane3 = new JScrollPane();
        this.taRegexp = new JTextArea();
        this.jTabbedPane1 = new JTabbedPane();
        this.jSplitPane2 = new JSplitPane();
        this.jPanel3 = new JPanel();
        this.jLabel4 = new JLabel();
        this.jSeparator2 = new JSeparator();
        this.jScrollPane4 = new JScrollPane();
        this.pMetaRules = new JPanel();
        this.bAddMetaRule = new JButton();
        this.jPanel4 = new JPanel();
        this.jLabel5 = new JLabel();
        this.jSeparator4 = new JSeparator();
        this.jScrollPane5 = new JScrollPane();
        this.pAssignments = new JPanel();
        this.bAddAssignment = new JButton();
        this.jScrollPane7 = new JScrollPane();
        this.pTestCase = new JPanel();
        this.jSplitPane1 = new JSplitPane();
        this.jScrollPane1 = new JScrollPane();
        this.tTestCases = new JTable();
        this.jScrollPane2 = new JScrollPane();
        this.jPanel2 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jScrollPane6 = new JScrollPane();
        this.pChecks = new JPanel();
        this.jLabel3 = new JLabel();
        this.cbCategory = new JComboBox();
        this.jLabel6 = new JLabel();
        this.cbKey = new JComboBox();
        this.jLabel7 = new JLabel();
        this.tfValue = new JTextField();
        this.bAddTestCase = new JButton();
        this.tbType = new JToggleButton();
        this.rbStopParsing.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.rbStopParsing, (String)NbBundle.getMessage(RuleDetailsPanel.class, (String)"RuleDetailsPanel.rbStopParsing.text"));
        this.pmAction.add(this.rbStopParsing);
        this.rbSilent.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.rbSilent, (String)NbBundle.getMessage(RuleDetailsPanel.class, (String)"RuleDetailsPanel.rbSilent.text"));
        this.pmAction.add(this.rbSilent);
        this.rbContinueParsing.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.rbContinueParsing, (String)NbBundle.getMessage(RuleDetailsPanel.class, (String)"RuleDetailsPanel.rbContinueParsing.text"));
        this.pmAction.add(this.rbContinueParsing);
        this.rbJumpToGroup.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.rbJumpToGroup, (String)NbBundle.getMessage(RuleDetailsPanel.class, (String)"RuleDetailsPanel.rbJumpToGroup.text"));
        this.pmAction.add(this.rbJumpToGroup);
        this.jLabel1.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(RuleDetailsPanel.class, (String)"RuleDetailsPanel.jLabel1.text"));
        this.bAction.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((AbstractButton)this.bAction, (String)NbBundle.getMessage(RuleDetailsPanel.class, (String)"RuleDetailsPanel.bAction.text"));
        this.bAction.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RuleDetailsPanel.this.bActionActionPerformed(evt);
            }
        });
        this.bBuildRegexp.setIcon(new ImageIcon(this.getClass().getResource("/wrench.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.bBuildRegexp, (String)NbBundle.getMessage(RuleDetailsPanel.class, (String)"RuleDetailsPanel.bBuildRegexp.text"));
        this.bBuildRegexp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RuleDetailsPanel.this.bBuildRegexpActionPerformed(evt);
            }
        });
        this.taRegexp.setColumns(20);
        this.taRegexp.setLineWrap(true);
        this.taRegexp.setRows(3);
        this.jScrollPane3.setViewportView(this.taRegexp);
        this.jTabbedPane1.setFont(new Font("Dialog", 0, 12));
        this.jSplitPane2.setResizeWeight(0.5);
        this.jLabel4.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(RuleDetailsPanel.class, (String)"RuleDetailsPanel.jLabel4.text"));
        this.pMetaRules.setLayout(new BoxLayout(this.pMetaRules, 1));
        this.jScrollPane4.setViewportView(this.pMetaRules);
        this.bAddMetaRule.setFont(new Font("Dialog", 0, 12));
        this.bAddMetaRule.setIcon(new ImageIcon(this.getClass().getResource("/add.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.bAddMetaRule, (String)NbBundle.getMessage(RuleDetailsPanel.class, (String)"RuleDetailsPanel.bAddMetaRule.text"));
        this.bAddMetaRule.setMargin(new Insets(0, 0, 0, 0));
        this.bAddMetaRule.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RuleDetailsPanel.this.bAddMetaRuleActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane4).addGroup(GroupLayout.Alignment.LEADING, jPanel3Layout.createSequentialGroup().addComponent(this.jLabel4, -1, 403, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bAddMetaRule)).addComponent(this.jSeparator2, GroupLayout.Alignment.LEADING)).addContainerGap()));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.bAddMetaRule).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator2, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane4, -1, 230, Short.MAX_VALUE).addContainerGap()));
        this.jSplitPane2.setLeftComponent(this.jPanel3);
        this.jLabel5.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((JLabel)this.jLabel5, (String)NbBundle.getMessage(RuleDetailsPanel.class, (String)"RuleDetailsPanel.jLabel5.text"));
        this.pAssignments.setLayout(new BoxLayout(this.pAssignments, 1));
        this.jScrollPane5.setViewportView(this.pAssignments);
        this.bAddAssignment.setFont(new Font("Dialog", 0, 12));
        this.bAddAssignment.setIcon(new ImageIcon(this.getClass().getResource("/add.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.bAddAssignment, (String)NbBundle.getMessage(RuleDetailsPanel.class, (String)"RuleDetailsPanel.bAddAssignment.text"));
        this.bAddAssignment.setMargin(new Insets(0, 0, 0, 0));
        this.bAddAssignment.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RuleDetailsPanel.this.bAddAssignmentActionPerformed(evt);
            }
        });
        GroupLayout jPanel4Layout = new GroupLayout(this.jPanel4);
        this.jPanel4.setLayout(jPanel4Layout);
        jPanel4Layout.setHorizontalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jScrollPane5).addGroup(GroupLayout.Alignment.LEADING, jPanel4Layout.createSequentialGroup().addComponent(this.jLabel5, -1, 415, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bAddAssignment)).addComponent(this.jSeparator4, GroupLayout.Alignment.LEADING)).addContainerGap()));
        jPanel4Layout.setVerticalGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel4Layout.createSequentialGroup().addContainerGap().addGroup(jPanel4Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5).addComponent(this.bAddAssignment)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator4, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane5, -1, 230, Short.MAX_VALUE).addContainerGap()));
        this.jSplitPane2.setRightComponent(this.jPanel4);
        this.jTabbedPane1.addTab(NbBundle.getMessage(RuleDetailsPanel.class, (String)"RuleDetailsPanel.jSplitPane2.TabConstraints.tabTitle"), this.jSplitPane2);
        this.pTestCase.setPreferredSize(new Dimension(200, 200));
        this.jSplitPane1.setDividerLocation(70);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane1.setPreferredSize(new Dimension(100, 100));
        this.jScrollPane1.setComponentPopupMenu(this.pmTestCase);
        this.tTestCases.setModel(this.testCasesTableModel);
        this.tTestCases.setColumnSelectionAllowed(true);
        this.tTestCases.getTableHeader().setReorderingAllowed(false);
        this.jScrollPane1.setViewportView(this.tTestCases);
        this.tTestCases.getColumnModel().getSelectionModel().setSelectionMode(0);
        this.jSplitPane1.setTopComponent(this.jScrollPane1);
        this.jPanel2.setPreferredSize(new Dimension(100, 100));
        this.jLabel2.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(RuleDetailsPanel.class, (String)"RuleDetailsPanel.jLabel2.text"));
        GroupLayout pChecksLayout = new GroupLayout(this.pChecks);
        this.pChecks.setLayout(pChecksLayout);
        pChecksLayout.setHorizontalGroup(pChecksLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 872, Short.MAX_VALUE));
        pChecksLayout.setVerticalGroup(pChecksLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 121, Short.MAX_VALUE));
        this.jScrollPane6.setViewportView(this.pChecks);
        this.jLabel3.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(RuleDetailsPanel.class, (String)"RuleDetailsPanel.jLabel3.text"));
        this.cbCategory.setFont(new Font("Dialog", 0, 12));
        this.cbCategory.setModel(new DefaultComboBoxModel<String>(new String[]{"what", "who", "when", "where", "extra"}));
        this.jLabel6.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((JLabel)this.jLabel6, (String)NbBundle.getMessage(RuleDetailsPanel.class, (String)"RuleDetailsPanel.jLabel6.text"));
        this.cbKey.setFont(new Font("Dialog", 0, 12));
        this.jLabel7.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((JLabel)this.jLabel7, (String)NbBundle.getMessage(RuleDetailsPanel.class, (String)"RuleDetailsPanel.jLabel7.text"));
        this.tfValue.setText(NbBundle.getMessage(RuleDetailsPanel.class, (String)"RuleDetailsPanel.tfValue.text"));
        this.bAddTestCase.setFont(new Font("Dialog", 0, 12));
        Mnemonics.setLocalizedText((AbstractButton)this.bAddTestCase, (String)NbBundle.getMessage(RuleDetailsPanel.class, (String)"RuleDetailsPanel.bAddTestCase.text"));
        this.bAddTestCase.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RuleDetailsPanel.this.bAddTestCaseActionPerformed(evt);
            }
        });
        this.tbType.setFont(new Font("Dialog", 0, 12));
        this.tbType.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.tbType, (String)NbBundle.getMessage(RuleDetailsPanel.class, (String)"RuleDetailsPanel.tbType.text"));
        this.tbType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RuleDetailsPanel.this.tbTypeActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane6, -1, 890, Short.MAX_VALUE).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1)).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbCategory, 0, 143, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbKey, 0, 174, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfValue, -1, 174, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tbType, -1, -1, Short.MAX_VALUE).addGap(44, 44, 44).addComponent(this.bAddTestCase))).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jSeparator1, -2, 10, -2).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.cbCategory, -2, -1, -2).addComponent(this.jLabel6).addComponent(this.cbKey, -2, -1, -2).addComponent(this.jLabel7).addComponent(this.tfValue, -2, -1, -2).addComponent(this.bAddTestCase).addComponent(this.tbType)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane6, -1, 113, Short.MAX_VALUE).addContainerGap()));
        this.jScrollPane2.setViewportView(this.jPanel2);
        this.jSplitPane1.setRightComponent(this.jScrollPane2);
        GroupLayout pTestCaseLayout = new GroupLayout(this.pTestCase);
        this.pTestCase.setLayout(pTestCaseLayout);
        pTestCaseLayout.setHorizontalGroup(pTestCaseLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pTestCaseLayout.createSequentialGroup().addContainerGap().addComponent(this.jSplitPane1, -1, 919, Short.MAX_VALUE).addContainerGap()));
        pTestCaseLayout.setVerticalGroup(pTestCaseLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pTestCaseLayout.createSequentialGroup().addContainerGap().addComponent(this.jSplitPane1, -1, 273, Short.MAX_VALUE).addContainerGap()));
        this.jScrollPane7.setViewportView(this.pTestCase);
        this.jTabbedPane1.addTab(NbBundle.getMessage(RuleDetailsPanel.class, (String)"RuleDetailsPanel.jScrollPane7.TabConstraints.tabTitle"), this.jScrollPane7);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1, -2, 95, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane3).addGap(18, 18, 18).addComponent(this.bBuildRegexp)).addComponent(this.bAction, -1, -1, Short.MAX_VALUE).addComponent(this.jTabbedPane1)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jScrollPane3, -1, 71, Short.MAX_VALUE).addComponent(this.jLabel1).addComponent(this.bBuildRegexp, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.bAction).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jTabbedPane1).addContainerGap()));
    }

    private void bActionActionPerformed(ActionEvent evt) {
        if (this.model.isEditMode()) {
            this.pmAction.show(this.bAction, this.x, this.y);
        } else if (this.rule != null) {
            this.groupService.groupFocusChanged(this.rule.getMatchedGroupId());
        }
    }

    private void bAddTestCaseActionPerformed(ActionEvent evt) {
        if (this.tTestCases.getSelectedRow() > -1) {
            this.model.addTestCaseCheck(this.rule, this.testCasesTableModel.getTestCase(this.tTestCases.getSelectedRow()), (String)this.cbCategory.getSelectedItem(), (String)this.cbKey.getSelectedItem(), this.tfValue.getText(), this.tbType.isSelected());
            this.updateDisplay(this.rule);
        }
    }

    private void bBuildRegexpActionPerformed(ActionEvent evt) {
        final RegExpDebuggerPanel panel = new RegExpDebuggerPanel(this.rule);
        panel.setText("");
        panel.setRegExp(this.rule.getRegexp());
        DialogDescriptor d = new DialogDescriptor((Object)panel, NbBundle.getMessage(RuleDetailsPanel.class, (String)"regexp_debugger.title"), false, null);
        DialogDisplayer.getDefault().createDialog(d).setVisible(true);
        if (this.model.isEditMode()) {
            d.setValid(true);
        } else {
            d.setValid(false);
        }
        d.setButtonListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int opt = (Integer)e.getSource();
                if (DialogDescriptor.OK_OPTION.equals(opt)) {
                    RuleDetailsPanel.this.taRegexp.setText(panel.getRegExp());
                }
            }
        });
    }

    private void tbTypeActionPerformed(ActionEvent evt) {
        if (this.tbType.isSelected()) {
            this.tbType.setText(NbBundle.getMessage(ParsingRulesetEditorTopComponent.class, (String)"TestCaseType.mustMatch"));
        } else {
            this.tbType.setText(NbBundle.getMessage(ParsingRulesetEditorTopComponent.class, (String)"TestCaseType.mustNotMatch"));
        }
    }

    private void bAddAssignmentActionPerformed(ActionEvent evt) {
        this.model.addAssignment(this.rule);
    }

    private void bAddMetaRuleActionPerformed(ActionEvent evt) {
        this.model.addMetaRule(this.rule);
    }

    public class MyAncestorListener
    implements AncestorListener {
        private RuleDetailsPanel panel;

        public MyAncestorListener(RuleDetailsPanel panel) {
            this.panel = panel;
        }

        public AncestorListener getAncestorListener() {
            return this;
        }

        @Override
        public void ancestorAdded(AncestorEvent event) {
            RuleDetailsPanel.this.model.addPropertyChangeListener((PropertyChangeListener)this.panel);
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
            RuleDetailsPanel.this.model.removePropertyChangeListener((PropertyChangeListener)this.panel);
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
        }
    }
}

