/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.query;

import java.io.InputStream;
import java.util.Map;
import net.sf.jasperreports.data.RewindableDataSourceProvider;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRValueParameter;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.data.JsonQLDataSource;
import net.sf.jasperreports.engine.data.JsonQLDataSourceProvider;
import net.sf.jasperreports.engine.data.TextDataSourceAttributes;
import net.sf.jasperreports.engine.query.AbstractJsonQueryExecuter;
import net.sf.jasperreports.engine.util.JRStringUtil;

public class JsonQLQueryExecuter
extends AbstractJsonQueryExecuter<JsonQLDataSource> {
    public static final String CANONICAL_LANGUAGE = "JSONQL";

    public JsonQLQueryExecuter(JasperReportsContext jasperReportsContext, JRDataset dataset, Map<String, ? extends JRValueParameter> parametersMap) {
        super(jasperReportsContext, dataset, parametersMap);
    }

    @Override
    protected String getCanonicalQueryLanguage() {
        return CANONICAL_LANGUAGE;
    }

    @Override
    protected String getParameterReplacement(String parameterName) {
        Object parameterValue = this.getParameterValue(parameterName);
        if (parameterValue == null) {
            return null;
        }
        Class<?> valueClass = parameterValue.getClass();
        if (Number.class.isAssignableFrom(valueClass) || Boolean.class.equals(valueClass)) {
            return String.valueOf(parameterValue);
        }
        StringBuilder sb = new StringBuilder("\"");
        sb.append(JRStringUtil.escapeJavaStringLiteral(String.valueOf(parameterValue)));
        sb.append("\"");
        return sb.toString();
    }

    @Override
    protected JsonQLDataSource getJsonDataInstance(InputStream jsonInputStream) throws JRException {
        return new JsonQLDataSource(jsonInputStream, this.getQueryString());
    }

    @Override
    protected JsonQLDataSource getJsonDataInstance(String jsonSource) throws JRException {
        return new JsonQLDataSource(this.getJasperReportsContext(), jsonSource, this.getQueryString());
    }

    @Override
    protected RewindableDataSourceProvider<JsonQLDataSource> getJsonDataProviderInstance(String source, TextDataSourceAttributes textAttributes) {
        return new JsonQLDataSourceProvider(this.getJasperReportsContext(), source, this.getQueryString(), textAttributes);
    }
}

