/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import net.sf.jasperreports.engine.JRPropertyExpression;
import net.sf.jasperreports.engine.base.JRBaseField;
import net.sf.jasperreports.engine.util.JRCloneUtils;

public class JRDesignField
extends JRBaseField {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_NAME = "name";
    public static final String PROPERTY_VALUE_CLASS_NAME = "valueClassName";
    public static final String PROPERTY_PROPERTY_EXPRESSIONS = "propertyExpressions";
    private List<JRPropertyExpression> propertyExpressions = new ArrayList<JRPropertyExpression>();

    public void setName(String name) {
        String old = this.name;
        this.name = name;
        this.getEventSupport().firePropertyChange(PROPERTY_NAME, old, this.name);
    }

    public void setValueClass(Class<?> clazz) {
        this.setValueClassName(clazz.getName());
    }

    public void setValueClassName(String className) {
        String old = this.valueClassName;
        this.valueClassName = className;
        this.valueClass = null;
        this.valueClassRealName = null;
        this.getEventSupport().firePropertyChange(PROPERTY_VALUE_CLASS_NAME, old, this.valueClassName);
    }

    public void addPropertyExpression(JRPropertyExpression propertyExpression) {
        this.propertyExpressions.add(propertyExpression);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_PROPERTY_EXPRESSIONS, propertyExpression, this.propertyExpressions.size() - 1);
    }

    public void removePropertyExpression(JRPropertyExpression propertyExpression) {
        int idx = this.propertyExpressions.indexOf(propertyExpression);
        if (idx >= 0) {
            this.propertyExpressions.remove(idx);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_PROPERTY_EXPRESSIONS, propertyExpression, idx);
        }
    }

    public JRPropertyExpression removePropertyExpression(String name) {
        JRPropertyExpression removed = null;
        ListIterator<JRPropertyExpression> it = this.propertyExpressions.listIterator();
        while (it.hasNext()) {
            JRPropertyExpression prop = it.next();
            if (!name.equals(prop.getName())) continue;
            removed = prop;
            int idx = it.previousIndex();
            it.remove();
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_PROPERTY_EXPRESSIONS, removed, idx);
            break;
        }
        return removed;
    }

    public List<JRPropertyExpression> getPropertyExpressionsList() {
        return this.propertyExpressions;
    }

    @Override
    public JRPropertyExpression[] getPropertyExpressions() {
        JRPropertyExpression[] props = this.propertyExpressions.isEmpty() ? null : this.propertyExpressions.toArray(new JRPropertyExpression[this.propertyExpressions.size()]);
        return props;
    }

    @Override
    public Object clone() {
        JRDesignField clone = (JRDesignField)super.clone();
        clone.propertyExpressions = JRCloneUtils.cloneList(this.propertyExpressions);
        return clone;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        if (this.propertyExpressions == null) {
            this.propertyExpressions = new ArrayList<JRPropertyExpression>();
        }
    }
}

