/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.rawlogs.query;

import java.util.HashSet;
import java.util.Set;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;

public class RawLogQueryHistory {
    private Set<String> queries = new HashSet<String>(10);
    private int lastUsedPosition;

    public void init() {
        try {
            this.queries.clear();
            Preferences p = NbPreferences.forModule(RawLogQueryHistory.class);
            for (String q : p.keys()) {
                if (!q.startsWith("query_")) continue;
                this.queries.add(p.get(q, ""));
            }
            this.lastUsedPosition = Integer.valueOf(p.get("lastUsedPosition", "1"));
        }
        catch (BackingStoreException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public Set<String> getQueries() {
        return this.queries;
    }

    public void put(String value) {
        if (value.isEmpty()) {
            return;
        }
        NbPreferences.forModule(RawLogQueryHistory.class).put("query_" + this.lastUsedPosition, value);
        NbPreferences.forModule(RawLogQueryHistory.class).put("lastUsedPosition", String.valueOf(this.lastUsedPosition + 1));
        this.lastUsedPosition = this.lastUsedPosition < 10 ? (this.lastUsedPosition = this.lastUsedPosition + 1) : 1;
    }
}

