/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.rawlogs.query;

import java.awt.event.MouseEvent;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.Range;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import rs.co.ast.aspen.api.service.RawLog;
import rs.co.ast.aspen.api.service.RawLogSimWrapper;
import rs.co.ast.aspen.gui.rawlogs.RawLogDetailsTableModel;

public class QueryManager {
    private static final Logger LOGGER = Logger.getLogger(QueryManager.class.getName());
    private static final DateTimeFormatter DTF = ISODateTimeFormat.dateTime().withZone(DateTimeZone.getDefault());

    public static String copyItemRow(RawLogDetailsTableModel.Item entry) {
        StringBuilder sb = new StringBuilder();
        if (entry.getCategory() != null) {
            sb.append(entry.getCategory()).append(".");
        }
        sb.append(entry.getKey().toLowerCase());
        sb.append(":");
        sb.append("\"");
        String value = entry.getValue();
        if (entry.getKey().equals("timestamp")) {
            try {
                value = DTF.print(Long.valueOf(value).longValue());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        sb.append(value);
        sb.append("\"");
        return sb.toString();
    }

    public static String copyRLDetailsRow(RawLogDetailsTableModel.Item entry, int selectedColumn) {
        StringBuilder sb = new StringBuilder();
        if (selectedColumn == 0) {
            if (entry.getCategory() != null) {
                sb.append(entry.getCategory()).append(".");
            }
            sb.append(entry.getKey().toLowerCase());
            sb.append(":");
        }
        sb.append("\"");
        String value = entry.getValue();
        if (entry.getKey().equals("timestamp")) {
            try {
                value = DTF.print(Long.valueOf(value).longValue());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        sb.append(value);
        sb.append("\"");
        return sb.toString();
    }

    public static String copyRawLogRow(RawLog event, String category, DateTimeFormatter isoTimeFormat) {
        StringBuilder sb = new StringBuilder();
        sb.append(category.toLowerCase());
        sb.append(":");
        sb.append("\"");
        String data = "";
        switch (category) {
            case "Timestamp": {
                data = isoTimeFormat.print(event.getTimestamp().longValue());
                break;
            }
            case "Source": {
                data = event.getSource();
                break;
            }
            case "Text": {
                data = event.getText();
            }
        }
        sb.append(data);
        sb.append("\"");
        return sb.toString();
    }

    public static String makeGraphZoomQuery(RawLogSimWrapper rawLogSimWrapper, DateTimeFormatter isoTimeFormat, PlotChangeEvent event) {
        Range dataRange = ((XYPlot)event.getPlot()).getDomainAxis().getRange();
        StringBuilder query = new StringBuilder();
        Pattern p = Pattern.compile(".*timestamp:\\[(.*)\\s+TO\\s+(.*)\\].*");
        Matcher m = p.matcher(rawLogSimWrapper.getQuery());
        if (m.matches() && m.groupCount() > 1) {
            String tmpQuery = rawLogSimWrapper.getQuery();
            tmpQuery = tmpQuery.replace(m.group(1), isoTimeFormat.print(Double.valueOf(dataRange.getLowerBound()).longValue()));
            tmpQuery = tmpQuery.replace(m.group(2), isoTimeFormat.print(Double.valueOf(dataRange.getUpperBound()).longValue()));
            query.append(tmpQuery);
        } else {
            boolean prefix;
            query.append(rawLogSimWrapper.getQuery());
            boolean bl = prefix = !rawLogSimWrapper.getQuery().equals("");
            if (prefix) {
                query.append(" AND ");
            }
            query.append("timestamp:[");
            query.append(isoTimeFormat.print(Double.valueOf(dataRange.getLowerBound()).longValue()));
            query.append(" TO ");
            query.append(isoTimeFormat.print(Double.valueOf(dataRange.getUpperBound()).longValue()));
            query.append("]");
        }
        return query.toString();
    }

    public static String makeIdQuery(String id) {
        StringBuilder sb = new StringBuilder();
        sb.append("id:\"");
        sb.append(id);
        sb.append("\"");
        return sb.toString();
    }

    public static String makeQueryTimeQuery(long timeStart, long timeFinish, DateTimeFormatter isoTimeFormat) {
        StringBuilder sb = new StringBuilder();
        sb.append("timestamp:[");
        sb.append(isoTimeFormat.print(timeStart));
        sb.append(" TO ");
        sb.append(isoTimeFormat.print(timeFinish));
        sb.append("]");
        return sb.toString();
    }

    public static String makeRLDetailsQuery(RawLogDetailsTableModel.Item entry, RawLogSimWrapper rlsw, MouseEvent e) {
        StringBuilder query = new StringBuilder();
        if (entry.getKey() != null) {
            StringBuilder sb = new StringBuilder();
            if (entry.getCategory() != null) {
                sb.append(entry.getCategory());
                sb.append(".");
            }
            sb.append(entry.getKey().toLowerCase());
            sb.append(":");
            sb.append("\"");
            sb.append(entry.getValue());
            sb.append("\"");
            String text = sb.toString();
            boolean prefix = rlsw.getQuery() != null ? !rlsw.getQuery().trim().equals("") : false;
            LOGGER.info(String.format("prefix: %s, query: %s", prefix, rlsw.getQuery()));
            if (QueryManager.isCTRL_SHIFT_CLICK(e)) {
                if (prefix) {
                    query.append(" OR ");
                }
                query.append(text);
            } else if (e.isShiftDown()) {
                if (prefix) {
                    query.append(" ");
                }
                query.append(" AND NOT ");
                query.append(text);
            } else if (e.isControlDown()) {
                if (prefix) {
                    query.append(" AND ");
                }
                query.append(text);
            }
        }
        return query.toString();
    }

    public static String makeRLDetailsQuery(RawLogDetailsTableModel.Item item, RawLogSimWrapper rlsw, MouseEvent e, int selectedColumn) {
        StringBuilder sb = new StringBuilder();
        if (selectedColumn == 0) {
            if (item.getCategory() != null) {
                sb.append(item.getCategory());
                sb.append(".");
            }
            sb.append(item.getKey().toLowerCase());
            sb.append(":");
            sb.append("\"");
            sb.append(item.getValue());
            sb.append("\"");
        } else {
            sb.append("\"");
            sb.append(item.getValue());
            sb.append("\"");
        }
        StringBuilder query = new StringBuilder();
        String text = sb.toString();
        if (rlsw.getQuery() == null) {
            rlsw.setQuery("");
        }
        String prevQuery = rlsw.getQuery().trim();
        boolean prefix = false;
        prefix = prevQuery.isEmpty() ? false : !prevQuery.endsWith("OR") && !prevQuery.endsWith("AND");
        if (QueryManager.isCTRL_SHIFT_CLICK(e)) {
            if (prefix) {
                query.append(" OR");
            }
            query.append(" ").append(text);
        } else if (e.isShiftDown()) {
            if (prefix) {
                query.append(" ");
            }
            query.append(" AND NOT");
            query.append(" ").append(text);
        } else if (e.isControlDown()) {
            if (prefix) {
                query.append(" AND");
            }
            query.append(" ").append(text);
        }
        return query.toString();
    }

    public static String makeSourceQuery(String source) {
        StringBuilder sb = new StringBuilder();
        sb.append("source:\"");
        sb.append(source);
        sb.append("\"");
        return sb.toString();
    }

    public static String makeTextQuery(String text, RawLogSimWrapper rlsw) {
        StringBuilder sb = new StringBuilder();
        sb.append("text:\"");
        String txt = text.replaceAll("<html>", "").replaceAll("</html>", "");
        if (rlsw != null && rlsw.getRawLog() != null && rlsw.getRawLog().getText() != null) {
            txt = rlsw.getRawLog().getText();
        }
        sb.append(txt);
        sb.append("\"");
        return sb.toString();
    }

    public static String makeTimestampQuery(String timestamp) {
        StringBuilder sb = new StringBuilder();
        sb.append("timestamp:\"");
        sb.append(timestamp);
        sb.append("\"");
        return sb.toString();
    }

    private static boolean isCTRL_SHIFT_CLICK(MouseEvent e) {
        int onmask = 1216;
        return (e.getModifiersEx() & onmask) == onmask;
    }
}

