/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.securityevents.widget;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.apache.commons.lang3.StringUtils;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.openide.awt.Mnemonics;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import rs.co.ast.aspen.api.service.ApiService;
import rs.co.ast.aspen.api.service.ApiServiceException_Exception;
import rs.co.ast.aspen.api.service.ItemsPerTimePeriod;
import rs.co.ast.aspen.api.service.TermTimeHistogram;
import rs.co.ast.aspen.gui.module.securityevents.DisplayOptions;
import rs.co.ast.aspen.gui.module.securityevents.SecurityEventWrapper;
import rs.co.ast.aspen.gui.module.securityevents.widget.LoadingPanel;
import rs.co.ast.aspen.gui.module.securityevents.widget.QueuePanel;
import rs.co.ast.aspen.gui.module.securityevents.widget.ReloadPanel;
import rs.co.ast.aspen.gui.module.securityevents.widget.Widget;
import rs.co.ast.chart.ASTChart;
import rs.co.ast.chart.OverviewChart;
import rs.co.ast.chart.event.ASTMouseEvent;
import rs.co.ast.chart.event.ASTMouseListener;
import rs.co.ast.chart.event.ASTPlotChangeListener;

public class ByFieldPanel
extends JPanel
implements Widget {
    private static final Logger logger = Logger.getLogger(ByFieldPanel.class.getName());
    private Lookup.Result<SecurityEventWrapper> lr = Utilities.actionsGlobalContext().lookupResult(SecurityEventWrapper.class);
    private static final int NO_SOURCES = 20;
    private static final int GRAPH_HEIGHT = 150;
    private static final int MAX_SOURCE_TITLE_LEN = 70;
    private Map<String, Color> itemColors = new HashMap<String, Color>();
    private SecurityEventWrapper securityEventWrapper;
    private transient MouseListener listener;
    private FileSystem fs = FileUtil.createMemoryFileSystem();
    private FileObject root = this.fs.getRoot();
    private UpdateParams params;
    private OverviewChart chart;
    private ASTPlotChangeListener plotChangeListener;
    private ASTMouseListener mouseListener;
    private LoadingPanel loadingPanel;
    private QueuePanel queuePanel;
    private JPanel graphPanel;
    private JButton jButton1;
    private JButton jButton10;
    private JButton jButton11;
    private JButton jButton12;
    private JButton jButton13;
    private JButton jButton14;
    private JButton jButton15;
    private JButton jButton16;
    private JButton jButton17;
    private JButton jButton18;
    private JButton jButton19;
    private JButton jButton2;
    private JButton jButton20;
    private JButton jButton21;
    private JButton jButton22;
    private JButton jButton23;
    private JButton jButton24;
    private JButton jButton25;
    private JButton jButton26;
    private JButton jButton27;
    private JButton jButton28;
    private JButton jButton29;
    private JButton jButton3;
    private JButton jButton30;
    private JButton jButton31;
    private JButton jButton32;
    private JButton jButton33;
    private JButton jButton34;
    private JButton jButton35;
    private JButton jButton36;
    private JButton jButton37;
    private JButton jButton38;
    private JButton jButton39;
    private JButton jButton4;
    private JButton jButton40;
    private JButton jButton5;
    private JButton jButton6;
    private JButton jButton7;
    private JButton jButton8;
    private JButton jButton9;
    private JPanel pDataPanel;

    public ByFieldPanel() {
        this.initComponents();
        this.setHandCursor();
        this.graphPanel.setLayout(new BorderLayout());
        this.lr.allInstances();
        this.lr.addLookupListener(ev -> {
            Lookup.Result res = (Lookup.Result)ev.getSource();
            Collection instances = res.allInstances();
            for (Object o : instances) {
                if (!(o instanceof SecurityEventWrapper)) continue;
                this.securityEventWrapper = (SecurityEventWrapper)o;
            }
        });
        this.listener = new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                JButton btn = (JButton)e.getSource();
                if (ByFieldPanel.this.securityEventWrapper != null) {
                    String query;
                    String prevQuery = ByFieldPanel.this.securityEventWrapper.getQuery();
                    String field = ByFieldPanel.this.params.getField();
                    String text = String.format("\"%s\"", btn.getToolTipText());
                    if (ByFieldPanel.this.isCTRL_SHIFT_CLICK(e)) {
                        String string = query = !prevQuery.isEmpty() ? prevQuery + " " : prevQuery;
                        if (!query.isEmpty()) {
                            query = query + "OR ";
                        }
                        query = query + field + ":" + text + "";
                    } else if (e.isShiftDown()) {
                        query = !prevQuery.isEmpty() ? prevQuery + " " : prevQuery;
                        query = query + "NOT" + field + ":" + text + "";
                    } else if (e.isControlDown()) {
                        query = !prevQuery.isEmpty() ? prevQuery + " AND " : prevQuery;
                        query = query + field + ":" + text + "";
                    } else {
                        query = field + ":" + text + "";
                    }
                    if (query != null && !query.isEmpty()) {
                        try {
                            FileObject fileData;
                            FileObject testFolder;
                            if (ByFieldPanel.this.root.getFileObject("SecurityEventFolder") == null) {
                                testFolder = ByFieldPanel.this.root.createFolder("SecurityEventFolder");
                                fileData = testFolder.createData("SecurityEventID", "securityevent");
                            } else {
                                testFolder = ByFieldPanel.this.root.getFileObject("SecurityEventFolder");
                                fileData = testFolder.getFileObject("SecurityEventID", "securityevent");
                            }
                            fileData.setAttribute("query", (Object)query);
                            fileData.setAttribute("start", (Object)ByFieldPanel.this.securityEventWrapper.getOptions().getTimeStart());
                            fileData.setAttribute("finish", (Object)ByFieldPanel.this.securityEventWrapper.getOptions().getTimeFinish());
                            fileData.setAttribute("lastNHours", (Object)ByFieldPanel.this.securityEventWrapper.getOptions().isLastNHours());
                            fileData.setAttribute("lastNHoursSelectedIndex", (Object)ByFieldPanel.this.securityEventWrapper.getOptions().getLastNHoursSelectedIndex());
                            fileData.setAttribute("now", (Object)ByFieldPanel.this.securityEventWrapper.getOptions().isNow());
                            fileData.setAttribute("ASC", (Object)false);
                            DataObject sedo = DataObject.find((FileObject)fileData);
                            ((OpenCookie)sedo.getLookup().lookup(OpenCookie.class)).open();
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        };
        this.plotChangeListener = event -> {
            this.params.getDisplayOptions().setTimeStart(event.getStartTime());
            this.params.getDisplayOptions().setTimeFinish(event.getFinishTime());
        };
        this.mouseListener = new ASTMouseListener(){

            public void mousePressed(ASTMouseEvent e) {
            }

            public void mouseReleased(ASTMouseEvent e) {
                double t = (e.getUpperBound() - e.getLowerBound()) / 30000.0 / 10.0;
                if (t < 9.0) {
                    ByFieldPanel.this.params.getDisplayOptions().setIntervalObj(ByFieldPanel.this.params.getDisplayOptions().getIntervals()[0]);
                }
            }
        };
        this.addListenerToButtons();
    }

    private boolean isCTRL_SHIFT_CLICK(MouseEvent e) {
        int onmask = 1216;
        return (e.getModifiersEx() & onmask) == onmask;
    }

    private void setHandCursor() {
        Cursor cur = new Cursor(12);
        this.jButton1.setCursor(cur);
        this.jButton3.setCursor(cur);
        this.jButton5.setCursor(cur);
        this.jButton8.setCursor(cur);
        this.jButton10.setCursor(cur);
        this.jButton11.setCursor(cur);
        this.jButton14.setCursor(cur);
        this.jButton15.setCursor(cur);
        this.jButton18.setCursor(cur);
        this.jButton19.setCursor(cur);
        this.jButton21.setCursor(cur);
        this.jButton24.setCursor(cur);
        this.jButton26.setCursor(cur);
        this.jButton28.setCursor(cur);
        this.jButton30.setCursor(cur);
        this.jButton32.setCursor(cur);
        this.jButton34.setCursor(cur);
        this.jButton36.setCursor(cur);
        this.jButton38.setCursor(cur);
        this.jButton40.setCursor(cur);
    }

    private void addListenerToButtons() {
        for (Component c : this.pDataPanel.getComponents()) {
            if (!(c instanceof JButton)) continue;
            c.addMouseListener(this.listener);
        }
    }

    @Override
    public void setLoadingPanel() {
        if (this.loadingPanel == null) {
            this.loadingPanel = new LoadingPanel();
        }
        this.removeAll();
        this.add(this.loadingPanel);
    }

    @Override
    public void setReloadPanel(ReloadPanel panel) {
        this.removeAll();
        this.add(panel);
    }

    @Override
    public void setQueuePanel() {
        if (this.queuePanel == null) {
            this.queuePanel = new QueuePanel();
        }
        this.removeAll();
        this.add(this.queuePanel);
    }

    @Override
    public void update(List<TermTimeHistogram> list, Class<?> clazz) {
        Map<String, Long> m = this.getTotalEventsByField(list);
        TreeMap<String, Long> sm = new TreeMap<String, Long>(new MyComparator(m, this.params.isSort()));
        sm.putAll(m);
        Iterator it = sm.keySet().iterator();
        for (int i = 0; i < 20; ++i) {
            String key = null;
            Long value = null;
            if (it.hasNext()) {
                key = (String)it.next();
                value = m.get(key);
                this.setLabelColor(i, ASTChart.COLORS[i]);
                this.itemColors.put(key, ASTChart.COLORS[i]);
            }
            String cnk = "title" + String.valueOf(i + 1);
            String cnv = "value" + String.valueOf(i + 1);
            for (Component c : this.pDataPanel.getComponents()) {
                JButton l;
                if (cnk.equals(c.getName())) {
                    l = (JButton)c;
                    if (key != null) {
                        l.setText(String.format("%d. \"%s\"", i + 1, StringUtils.abbreviate((String)key, (int)70)));
                        l.setToolTipText(key);
                        continue;
                    }
                    l.setText("");
                    continue;
                }
                if (!cnv.equals(c.getName())) continue;
                l = (JButton)c;
                l.setText(value != null ? String.format("%,d", value) : "");
            }
        }
        if (this.chart == null) {
            this.chart = new OverviewChart(this.createDataSet(list, sm, clazz));
            this.graphPanel.removeAll();
            this.graphPanel.add((Component)this.chart.getChartPanel());
        } else {
            this.graphPanel.removeAll();
            this.graphPanel.add((Component)this.chart.getChartPanel());
            this.chart.removeAllListeners();
            this.chart.updateChart(this.createDataSet(list, sm, clazz));
        }
        JPanel target = this.graphPanel;
        Dimension d = target.getSize();
        d.height = 150;
        ((Component)target).setMinimumSize(d);
        ((Component)target).setPreferredSize(d);
        ((Component)target).setMaximumSize(d);
        target.setSize(d);
        this.removeAll();
        this.add(this.pDataPanel);
        this.invalidate();
        this.revalidate();
        this.repaint();
    }

    @Override
    public List<TermTimeHistogram> getTimeHistogram(Object data) throws ApiServiceException_Exception {
        this.params = (UpdateParams)data;
        ApiService apiService = (ApiService)Lookup.getDefault().lookup(ApiService.class);
        return apiService.getSETermTimeHistogram(this.params.getQuery(), this.params.getField(), this.params.getTimeStart(), this.params.getTimeFinish(), this.params.getNoSources(), this.params.getInterval(), this.params.isSort());
    }

    private void setLabelColor(int index, Color color) {
        for (Component c : this.pDataPanel.getComponents()) {
            String n1 = "title" + String.valueOf(index + 1);
            String n2 = "value" + String.valueOf(index + 1);
            if (!n1.equals(c.getName()) && !n2.equals(c.getName())) continue;
            ((JButton)c).setForeground(color);
        }
    }

    private TimeSeries[] createDataSet(List<TermTimeHistogram> items, SortedMap<String, Long> sortedData, Class clazz) {
        ArrayList<TimeSeries> list = new ArrayList<TimeSeries>();
        HashMap map = new HashMap();
        HashSet<Long> times = new HashSet<Long>();
        items.forEach(tth -> map.put(tth.getTerm(), tth));
        int i = 0;
        for (String item : sortedData.keySet()) {
            if (i >= 20) break;
            TermTimeHistogram tth2 = (TermTimeHistogram)map.get(item);
            TimeSeries ts = new TimeSeries((Comparable)((Object)tth2.getTerm()));
            times.clear();
            for (ItemsPerTimePeriod iptp : tth2.getHistogram()) {
                if (iptp.getTime() < this.params.getTimeStart() || iptp.getTime() > this.params.getTimeFinish() || times.contains(iptp.getTime())) continue;
                times.add(iptp.getTime());
                ts.addOrUpdate(RegularTimePeriod.createInstance((Class)clazz, (Date)new Date(iptp.getTime()), (TimeZone)TimeZone.getDefault()), (double)iptp.getCount());
            }
            if (ts.getItemCount() > 0) {
                list.add(ts);
            }
            ++i;
        }
        TimeSeries[] arr = new TimeSeries[list.size()];
        return list.toArray(arr);
    }

    private void initComponents() {
        this.pDataPanel = new JPanel();
        this.graphPanel = new JPanel();
        this.jButton13 = new JButton();
        this.jButton12 = new JButton();
        this.jButton11 = new JButton();
        this.jButton19 = new JButton();
        this.jButton5 = new JButton();
        this.jButton3 = new JButton();
        this.jButton18 = new JButton();
        this.jButton16 = new JButton();
        this.jButton14 = new JButton();
        this.jButton6 = new JButton();
        this.jButton15 = new JButton();
        this.jButton20 = new JButton();
        this.jButton2 = new JButton();
        this.jButton1 = new JButton();
        this.jButton9 = new JButton();
        this.jButton10 = new JButton();
        this.jButton8 = new JButton();
        this.jButton7 = new JButton();
        this.jButton4 = new JButton();
        this.jButton17 = new JButton();
        this.jButton21 = new JButton();
        this.jButton22 = new JButton();
        this.jButton23 = new JButton();
        this.jButton24 = new JButton();
        this.jButton25 = new JButton();
        this.jButton26 = new JButton();
        this.jButton27 = new JButton();
        this.jButton28 = new JButton();
        this.jButton29 = new JButton();
        this.jButton30 = new JButton();
        this.jButton31 = new JButton();
        this.jButton32 = new JButton();
        this.jButton33 = new JButton();
        this.jButton34 = new JButton();
        this.jButton35 = new JButton();
        this.jButton36 = new JButton();
        this.jButton37 = new JButton();
        this.jButton38 = new JButton();
        this.jButton39 = new JButton();
        this.jButton40 = new JButton();
        this.pDataPanel.setBackground(new Color(255, 255, 255));
        this.graphPanel.setBackground(new Color(255, 255, 255));
        GroupLayout graphPanelLayout = new GroupLayout(this.graphPanel);
        this.graphPanel.setLayout(graphPanelLayout);
        graphPanelLayout.setHorizontalGroup(graphPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        graphPanelLayout.setVerticalGroup(graphPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 126, Short.MAX_VALUE));
        Mnemonics.setLocalizedText((AbstractButton)this.jButton13, (String)NbBundle.getMessage(ByFieldPanel.class, (String)"ByFieldPanel.jButton13.text"));
        this.jButton13.setBorder(null);
        this.jButton13.setContentAreaFilled(false);
        this.jButton13.setFocusPainted(false);
        this.jButton13.setHorizontalAlignment(4);
        this.jButton13.setMargin(new Insets(0, 0, 0, 0));
        this.jButton13.setName("value7");
        Mnemonics.setLocalizedText((AbstractButton)this.jButton12, (String)NbBundle.getMessage(ByFieldPanel.class, (String)"ByFieldPanel.jButton12.text"));
        this.jButton12.setBorder(null);
        this.jButton12.setContentAreaFilled(false);
        this.jButton12.setFocusPainted(false);
        this.jButton12.setHorizontalAlignment(4);
        this.jButton12.setMargin(new Insets(0, 0, 0, 0));
        this.jButton12.setName("value6");
        Mnemonics.setLocalizedText((AbstractButton)this.jButton11, (String)NbBundle.getMessage(ByFieldPanel.class, (String)"ByFieldPanel.jButton11.text"));
        this.jButton11.setBorder(null);
        this.jButton11.setContentAreaFilled(false);
        this.jButton11.setFocusPainted(false);
        this.jButton11.setHorizontalAlignment(4);
        this.jButton11.setMargin(new Insets(0, 0, 0, 0));
        this.jButton11.setName("title6");
        Mnemonics.setLocalizedText((AbstractButton)this.jButton19, (String)NbBundle.getMessage(ByFieldPanel.class, (String)"ByFieldPanel.jButton19.text"));
        this.jButton19.setBorder(null);
        this.jButton19.setContentAreaFilled(false);
        this.jButton19.setFocusPainted(false);
        this.jButton19.setHorizontalAlignment(4);
        this.jButton19.setMargin(new Insets(0, 0, 0, 0));
        this.jButton19.setName("title10");
        Mnemonics.setLocalizedText((AbstractButton)this.jButton5, (String)NbBundle.getMessage(ByFieldPanel.class, (String)"ByFieldPanel.jButton5.text"));
        this.jButton5.setBorder(null);
        this.jButton5.setContentAreaFilled(false);
        this.jButton5.setFocusPainted(false);
        this.jButton5.setHorizontalAlignment(4);
        this.jButton5.setMargin(new Insets(0, 0, 0, 0));
        this.jButton5.setName("title3");
        Mnemonics.setLocalizedText((AbstractButton)this.jButton3, (String)NbBundle.getMessage(ByFieldPanel.class, (String)"ByFieldPanel.jButton3.text"));
        this.jButton3.setBorder(null);
        this.jButton3.setContentAreaFilled(false);
        this.jButton3.setFocusPainted(false);
        this.jButton3.setHorizontalAlignment(4);
        this.jButton3.setMargin(new Insets(0, 0, 0, 0));
        this.jButton3.setName("title2");
        Mnemonics.setLocalizedText((AbstractButton)this.jButton18, (String)NbBundle.getMessage(ByFieldPanel.class, (String)"ByFieldPanel.jButton18.text"));
        this.jButton18.setBorder(null);
        this.jButton18.setContentAreaFilled(false);
        this.jButton18.setFocusPainted(false);
        this.jButton18.setHorizontalAlignment(4);
        this.jButton18.setMargin(new Insets(0, 0, 0, 0));
        this.jButton18.setName("title9");
        Mnemonics.setLocalizedText((AbstractButton)this.jButton16, (String)NbBundle.getMessage(ByFieldPanel.class, (String)"ByFieldPanel.jButton16.text"));
        this.jButton16.setBorder(null);
        this.jButton16.setContentAreaFilled(false);
        this.jButton16.setFocusPainted(false);
        this.jButton16.setHorizontalAlignment(4);
        this.jButton16.setMargin(new Insets(0, 0, 0, 0));
        this.jButton16.setName("value8");
        Mnemonics.setLocalizedText((AbstractButton)this.jButton14, (String)NbBundle.getMessage(ByFieldPanel.class, (String)"ByFieldPanel.jButton14.text"));
        this.jButton14.setBorder(null);
        this.jButton14.setContentAreaFilled(false);
        this.jButton14.setFocusPainted(false);
        this.jButton14.setHorizontalAlignment(4);
        this.jButton14.setMargin(new Insets(0, 0, 0, 0));
        this.jButton14.setName("title7");
        Mnemonics.setLocalizedText((AbstractButton)this.jButton6, (String)NbBundle.getMessage(ByFieldPanel.class, (String)"ByFieldPanel.jButton6.text"));
        this.jButton6.setBorder(null);
        this.jButton6.setContentAreaFilled(false);
        this.jButton6.setFocusPainted(false);
        this.jButton6.setHorizontalAlignment(4);
        this.jButton6.setMargin(new Insets(0, 0, 0, 0));
        this.jButton6.setName("value3");
        Mnemonics.setLocalizedText((AbstractButton)this.jButton15, (String)NbBundle.getMessage(ByFieldPanel.class, (String)"ByFieldPanel.jButton15.text"));
        this.jButton15.setBorder(null);
        this.jButton15.setContentAreaFilled(false);
        this.jButton15.setFocusPainted(false);
        this.jButton15.setHorizontalAlignment(4);
        this.jButton15.setMargin(new Insets(0, 0, 0, 0));
        this.jButton15.setName("title8");
        Mnemonics.setLocalizedText((AbstractButton)this.jButton20, (String)NbBundle.getMessage(ByFieldPanel.class, (String)"ByFieldPanel.jButton20.text"));
        this.jButton20.setBorder(null);
        this.jButton20.setContentAreaFilled(false);
        this.jButton20.setFocusPainted(false);
        this.jButton20.setHorizontalAlignment(4);
        this.jButton20.setMargin(new Insets(0, 0, 0, 0));
        this.jButton20.setName("value10");
        Mnemonics.setLocalizedText((AbstractButton)this.jButton2, (String)NbBundle.getMessage(ByFieldPanel.class, (String)"Top10EventSourcesPanel.value1.text"));
        this.jButton2.setBorder(null);
        this.jButton2.setContentAreaFilled(false);
        this.jButton2.setFocusPainted(false);
        this.jButton2.setHorizontalAlignment(4);
        this.jButton2.setMargin(new Insets(0, 0, 0, 0));
        this.jButton2.setName("value1");
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getMessage(ByFieldPanel.class, (String)"Top10EventSourcesPanel.title1.text"));
        this.jButton1.setBorder(null);
        this.jButton1.setContentAreaFilled(false);
        this.jButton1.setFocusPainted(false);
        this.jButton1.setHorizontalAlignment(4);
        this.jButton1.setMargin(new Insets(0, 0, 0, 0));
        this.jButton1.setName("title1");
        Mnemonics.setLocalizedText((AbstractButton)this.jButton9, (String)NbBundle.getMessage(ByFieldPanel.class, (String)"ByFieldPanel.jButton9.text"));
        this.jButton9.setBorder(null);
        this.jButton9.setContentAreaFilled(false);
        this.jButton9.setFocusPainted(false);
        this.jButton9.setHorizontalAlignment(4);
        this.jButton9.setMargin(new Insets(0, 0, 0, 0));
        this.jButton9.setName("value5");
        Mnemonics.setLocalizedText((AbstractButton)this.jButton10, (String)NbBundle.getMessage(ByFieldPanel.class, (String)"ByFieldPanel.jButton10.text"));
        this.jButton10.setBorder(null);
        this.jButton10.setContentAreaFilled(false);
        this.jButton10.setFocusPainted(false);
        this.jButton10.setHorizontalAlignment(4);
        this.jButton10.setMargin(new Insets(0, 0, 0, 0));
        this.jButton10.setName("title5");
        Mnemonics.setLocalizedText((AbstractButton)this.jButton8, (String)NbBundle.getMessage(ByFieldPanel.class, (String)"ByFieldPanel.jButton8.text"));
        this.jButton8.setBorder(null);
        this.jButton8.setContentAreaFilled(false);
        this.jButton8.setFocusPainted(false);
        this.jButton8.setHorizontalAlignment(4);
        this.jButton8.setMargin(new Insets(0, 0, 0, 0));
        this.jButton8.setName("title4");
        Mnemonics.setLocalizedText((AbstractButton)this.jButton7, (String)NbBundle.getMessage(ByFieldPanel.class, (String)"ByFieldPanel.jButton7.text"));
        this.jButton7.setBorder(null);
        this.jButton7.setContentAreaFilled(false);
        this.jButton7.setFocusPainted(false);
        this.jButton7.setHorizontalAlignment(4);
        this.jButton7.setMargin(new Insets(0, 0, 0, 0));
        this.jButton7.setName("value4");
        Mnemonics.setLocalizedText((AbstractButton)this.jButton4, (String)NbBundle.getMessage(ByFieldPanel.class, (String)"ByFieldPanel.jButton4.text"));
        this.jButton4.setBorder(null);
        this.jButton4.setContentAreaFilled(false);
        this.jButton4.setFocusPainted(false);
        this.jButton4.setHorizontalAlignment(4);
        this.jButton4.setMargin(new Insets(0, 0, 0, 0));
        this.jButton4.setName("value2");
        Mnemonics.setLocalizedText((AbstractButton)this.jButton17, (String)NbBundle.getMessage(ByFieldPanel.class, (String)"ByFieldPanel.jButton17.text"));
        this.jButton17.setBorder(null);
        this.jButton17.setContentAreaFilled(false);
        this.jButton17.setFocusPainted(false);
        this.jButton17.setHorizontalAlignment(4);
        this.jButton17.setMargin(new Insets(0, 0, 0, 0));
        this.jButton17.setName("value9");
        Mnemonics.setLocalizedText((AbstractButton)this.jButton21, (String)NbBundle.getMessage(ByFieldPanel.class, (String)"ByFieldPanel.jButton21.text"));
        this.jButton21.setBorder(null);
        this.jButton21.setContentAreaFilled(false);
        this.jButton21.setFocusPainted(false);
        this.jButton21.setHorizontalAlignment(4);
        this.jButton21.setMargin(new Insets(0, 0, 0, 0));
        this.jButton21.setName("title11");
        Mnemonics.setLocalizedText((AbstractButton)this.jButton22, (String)NbBundle.getMessage(ByFieldPanel.class, (String)"ByFieldPanel.jButton22.text"));
        this.jButton22.setBorder(null);
        this.jButton22.setContentAreaFilled(false);
        this.jButton22.setFocusPainted(false);
        this.jButton22.setHorizontalAlignment(4);
        this.jButton22.setMargin(new Insets(0, 0, 0, 0));
        this.jButton22.setName("value11");
        Mnemonics.setLocalizedText((AbstractButton)this.jButton23, (String)NbBundle.getMessage(ByFieldPanel.class, (String)"ByFieldPanel.jButton23.text"));
        this.jButton23.setBorder(null);
        this.jButton23.setContentAreaFilled(false);
        this.jButton23.setFocusPainted(false);
        this.jButton23.setHorizontalAlignment(4);
        this.jButton23.setMargin(new Insets(0, 0, 0, 0));
        this.jButton23.setName("value12");
        Mnemonics.setLocalizedText((AbstractButton)this.jButton24, (String)NbBundle.getMessage(ByFieldPanel.class, (String)"ByFieldPanel.jButton24.text"));
        this.jButton24.setBorder(null);
        this.jButton24.setContentAreaFilled(false);
        this.jButton24.setFocusPainted(false);
        this.jButton24.setHorizontalAlignment(4);
        this.jButton24.setMargin(new Insets(0, 0, 0, 0));
        this.jButton24.setName("title12");
        Mnemonics.setLocalizedText((AbstractButton)this.jButton25, (String)NbBundle.getMessage(ByFieldPanel.class, (String)"ByFieldPanel.jButton25.text"));
        this.jButton25.setBorder(null);
        this.jButton25.setContentAreaFilled(false);
        this.jButton25.setFocusPainted(false);
        this.jButton25.setHorizontalAlignment(4);
        this.jButton25.setMargin(new Insets(0, 0, 0, 0));
        this.jButton25.setName("value13");
        Mnemonics.setLocalizedText((AbstractButton)this.jButton26, (String)NbBundle.getMessage(ByFieldPanel.class, (String)"ByFieldPanel.jButton26.text"));
        this.jButton26.setBorder(null);
        this.jButton26.setContentAreaFilled(false);
        this.jButton26.setFocusPainted(false);
        this.jButton26.setHorizontalAlignment(4);
        this.jButton26.setMargin(new Insets(0, 0, 0, 0));
        this.jButton26.setName("title13");
        Mnemonics.setLocalizedText((AbstractButton)this.jButton27, (String)NbBundle.getMessage(ByFieldPanel.class, (String)"ByFieldPanel.jButton27.text"));
        this.jButton27.setBorder(null);
        this.jButton27.setContentAreaFilled(false);
        this.jButton27.setFocusPainted(false);
        this.jButton27.setHorizontalAlignment(4);
        this.jButton27.setMargin(new Insets(0, 0, 0, 0));
        this.jButton27.setName("value14");
        Mnemonics.setLocalizedText((AbstractButton)this.jButton28, (String)NbBundle.getMessage(ByFieldPanel.class, (String)"ByFieldPanel.jButton28.text"));
        this.jButton28.setBorder(null);
        this.jButton28.setContentAreaFilled(false);
        this.jButton28.setFocusPainted(false);
        this.jButton28.setHorizontalAlignment(4);
        this.jButton28.setMargin(new Insets(0, 0, 0, 0));
        this.jButton28.setName("title14");
        Mnemonics.setLocalizedText((AbstractButton)this.jButton29, (String)NbBundle.getMessage(ByFieldPanel.class, (String)"ByFieldPanel.jButton29.text"));
        this.jButton29.setBorder(null);
        this.jButton29.setContentAreaFilled(false);
        this.jButton29.setFocusPainted(false);
        this.jButton29.setHorizontalAlignment(4);
        this.jButton29.setMargin(new Insets(0, 0, 0, 0));
        this.jButton29.setName("value15");
        Mnemonics.setLocalizedText((AbstractButton)this.jButton30, (String)NbBundle.getMessage(ByFieldPanel.class, (String)"ByFieldPanel.jButton30.text"));
        this.jButton30.setBorder(null);
        this.jButton30.setContentAreaFilled(false);
        this.jButton30.setFocusPainted(false);
        this.jButton30.setHorizontalAlignment(4);
        this.jButton30.setMargin(new Insets(0, 0, 0, 0));
        this.jButton30.setName("title15");
        Mnemonics.setLocalizedText((AbstractButton)this.jButton31, (String)NbBundle.getMessage(ByFieldPanel.class, (String)"ByFieldPanel.jButton31.text"));
        this.jButton31.setBorder(null);
        this.jButton31.setContentAreaFilled(false);
        this.jButton31.setFocusPainted(false);
        this.jButton31.setHorizontalAlignment(4);
        this.jButton31.setMargin(new Insets(0, 0, 0, 0));
        this.jButton31.setName("value16");
        Mnemonics.setLocalizedText((AbstractButton)this.jButton32, (String)NbBundle.getMessage(ByFieldPanel.class, (String)"ByFieldPanel.jButton32.text"));
        this.jButton32.setBorder(null);
        this.jButton32.setContentAreaFilled(false);
        this.jButton32.setFocusPainted(false);
        this.jButton32.setHorizontalAlignment(4);
        this.jButton32.setMargin(new Insets(0, 0, 0, 0));
        this.jButton32.setName("title16");
        Mnemonics.setLocalizedText((AbstractButton)this.jButton33, (String)NbBundle.getMessage(ByFieldPanel.class, (String)"ByFieldPanel.jButton33.text"));
        this.jButton33.setBorder(null);
        this.jButton33.setContentAreaFilled(false);
        this.jButton33.setFocusPainted(false);
        this.jButton33.setHorizontalAlignment(4);
        this.jButton33.setMargin(new Insets(0, 0, 0, 0));
        this.jButton33.setName("value17");
        Mnemonics.setLocalizedText((AbstractButton)this.jButton34, (String)NbBundle.getMessage(ByFieldPanel.class, (String)"ByFieldPanel.jButton34.text"));
        this.jButton34.setBorder(null);
        this.jButton34.setContentAreaFilled(false);
        this.jButton34.setFocusPainted(false);
        this.jButton34.setHorizontalAlignment(4);
        this.jButton34.setMargin(new Insets(0, 0, 0, 0));
        this.jButton34.setName("title17");
        Mnemonics.setLocalizedText((AbstractButton)this.jButton35, (String)NbBundle.getMessage(ByFieldPanel.class, (String)"ByFieldPanel.jButton35.text"));
        this.jButton35.setBorder(null);
        this.jButton35.setContentAreaFilled(false);
        this.jButton35.setFocusPainted(false);
        this.jButton35.setHorizontalAlignment(4);
        this.jButton35.setMargin(new Insets(0, 0, 0, 0));
        this.jButton35.setName("value18");
        Mnemonics.setLocalizedText((AbstractButton)this.jButton36, (String)NbBundle.getMessage(ByFieldPanel.class, (String)"ByFieldPanel.jButton36.text"));
        this.jButton36.setBorder(null);
        this.jButton36.setContentAreaFilled(false);
        this.jButton36.setFocusPainted(false);
        this.jButton36.setHorizontalAlignment(4);
        this.jButton36.setMargin(new Insets(0, 0, 0, 0));
        this.jButton36.setName("title18");
        Mnemonics.setLocalizedText((AbstractButton)this.jButton37, (String)NbBundle.getMessage(ByFieldPanel.class, (String)"ByFieldPanel.jButton37.text"));
        this.jButton37.setBorder(null);
        this.jButton37.setContentAreaFilled(false);
        this.jButton37.setFocusPainted(false);
        this.jButton37.setHorizontalAlignment(4);
        this.jButton37.setMargin(new Insets(0, 0, 0, 0));
        this.jButton37.setName("value20");
        Mnemonics.setLocalizedText((AbstractButton)this.jButton38, (String)NbBundle.getMessage(ByFieldPanel.class, (String)"ByFieldPanel.jButton38.text"));
        this.jButton38.setBorder(null);
        this.jButton38.setContentAreaFilled(false);
        this.jButton38.setFocusPainted(false);
        this.jButton38.setHorizontalAlignment(4);
        this.jButton38.setMargin(new Insets(0, 0, 0, 0));
        this.jButton38.setName("title20");
        Mnemonics.setLocalizedText((AbstractButton)this.jButton39, (String)NbBundle.getMessage(ByFieldPanel.class, (String)"ByFieldPanel.jButton39.text"));
        this.jButton39.setBorder(null);
        this.jButton39.setContentAreaFilled(false);
        this.jButton39.setFocusPainted(false);
        this.jButton39.setHorizontalAlignment(4);
        this.jButton39.setMargin(new Insets(0, 0, 0, 0));
        this.jButton39.setName("value19");
        Mnemonics.setLocalizedText((AbstractButton)this.jButton40, (String)NbBundle.getMessage(ByFieldPanel.class, (String)"ByFieldPanel.jButton40.text"));
        this.jButton40.setBorder(null);
        this.jButton40.setContentAreaFilled(false);
        this.jButton40.setFocusPainted(false);
        this.jButton40.setHorizontalAlignment(4);
        this.jButton40.setMargin(new Insets(0, 0, 0, 0));
        this.jButton40.setName("title19");
        GroupLayout pDataPanelLayout = new GroupLayout(this.pDataPanel);
        this.pDataPanel.setLayout(pDataPanelLayout);
        pDataPanelLayout.setHorizontalGroup(pDataPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pDataPanelLayout.createSequentialGroup().addContainerGap().addGroup(pDataPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.graphPanel, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, pDataPanelLayout.createSequentialGroup().addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jButton2, -2, 93, -2)).addGroup(pDataPanelLayout.createSequentialGroup().addComponent(this.jButton3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 28, Short.MAX_VALUE).addComponent(this.jButton4, -2, 93, -2)).addGroup(pDataPanelLayout.createSequentialGroup().addComponent(this.jButton5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 28, Short.MAX_VALUE).addComponent(this.jButton6, -2, 93, -2)).addGroup(pDataPanelLayout.createSequentialGroup().addComponent(this.jButton8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 28, Short.MAX_VALUE).addComponent(this.jButton7, -2, 93, -2)).addGroup(pDataPanelLayout.createSequentialGroup().addComponent(this.jButton10).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 28, Short.MAX_VALUE).addComponent(this.jButton9, -2, 93, -2)).addGroup(pDataPanelLayout.createSequentialGroup().addComponent(this.jButton11).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 28, Short.MAX_VALUE).addComponent(this.jButton12, -2, 93, -2)).addGroup(pDataPanelLayout.createSequentialGroup().addComponent(this.jButton14).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 28, Short.MAX_VALUE).addComponent(this.jButton13, -2, 93, -2)).addGroup(pDataPanelLayout.createSequentialGroup().addComponent(this.jButton15).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 28, Short.MAX_VALUE).addComponent(this.jButton16, -2, 93, -2)).addGroup(pDataPanelLayout.createSequentialGroup().addComponent(this.jButton18).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 28, Short.MAX_VALUE).addComponent(this.jButton17, -2, 93, -2)).addGroup(pDataPanelLayout.createSequentialGroup().addComponent(this.jButton19).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 20, Short.MAX_VALUE).addComponent(this.jButton20, -2, 93, -2)).addGroup(pDataPanelLayout.createSequentialGroup().addComponent(this.jButton21).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 20, Short.MAX_VALUE).addComponent(this.jButton22, -2, 93, -2)).addGroup(GroupLayout.Alignment.TRAILING, pDataPanelLayout.createSequentialGroup().addComponent(this.jButton24).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 20, Short.MAX_VALUE).addComponent(this.jButton23, -2, 93, -2)).addGroup(pDataPanelLayout.createSequentialGroup().addComponent(this.jButton26).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 20, Short.MAX_VALUE).addComponent(this.jButton25, -2, 93, -2)).addGroup(pDataPanelLayout.createSequentialGroup().addComponent(this.jButton28).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 20, Short.MAX_VALUE).addComponent(this.jButton27, -2, 93, -2)).addGroup(pDataPanelLayout.createSequentialGroup().addComponent(this.jButton30).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 20, Short.MAX_VALUE).addComponent(this.jButton29, -2, 93, -2)).addGroup(pDataPanelLayout.createSequentialGroup().addComponent(this.jButton32).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 20, Short.MAX_VALUE).addComponent(this.jButton31, -2, 93, -2)).addGroup(pDataPanelLayout.createSequentialGroup().addComponent(this.jButton34).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 20, Short.MAX_VALUE).addComponent(this.jButton33, -2, 93, -2)).addGroup(GroupLayout.Alignment.TRAILING, pDataPanelLayout.createSequentialGroup().addComponent(this.jButton36).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 20, Short.MAX_VALUE).addComponent(this.jButton35, -2, 93, -2)).addGroup(pDataPanelLayout.createSequentialGroup().addComponent(this.jButton40).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 20, Short.MAX_VALUE).addComponent(this.jButton39, -2, 93, -2)).addGroup(pDataPanelLayout.createSequentialGroup().addComponent(this.jButton38).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 20, Short.MAX_VALUE).addComponent(this.jButton37, -2, 93, -2))).addContainerGap()));
        pDataPanelLayout.setVerticalGroup(pDataPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pDataPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.graphPanel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pDataPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1).addComponent(this.jButton2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pDataPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton3).addComponent(this.jButton4)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pDataPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton5).addComponent(this.jButton6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pDataPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton8).addComponent(this.jButton7)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pDataPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton10).addComponent(this.jButton9)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pDataPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton11).addComponent(this.jButton12)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pDataPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton14).addComponent(this.jButton13)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pDataPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton15).addComponent(this.jButton16)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pDataPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton18).addComponent(this.jButton17)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pDataPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton19).addComponent(this.jButton20)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pDataPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton21).addComponent(this.jButton22)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pDataPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton24).addComponent(this.jButton23)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pDataPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton26).addComponent(this.jButton25)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pDataPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton28).addComponent(this.jButton27)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pDataPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton30).addComponent(this.jButton29)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pDataPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton32).addComponent(this.jButton31)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pDataPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton34).addComponent(this.jButton33)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pDataPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton36).addComponent(this.jButton35)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pDataPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton40).addComponent(this.jButton39)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(pDataPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton38).addComponent(this.jButton37)).addGap(12, 12, 12)));
        this.setBackground(new Color(255, 255, 255));
        this.setLayout(new BorderLayout());
    }

    private Map<String, Long> getTotalEventsByField(List<TermTimeHistogram> data) {
        HashMap<String, Long> map = new HashMap<String, Long>();
        data.forEach(tth -> {
            String t = tth.getTerm();
            tth.getHistogram().stream().map(iptp -> {
                Long i = (Long)map.get(t);
                if (i == null) {
                    i = 0L;
                }
                i = i + iptp.getCount();
                return i;
            }).forEachOrdered(i -> map.put(t, (Long)i));
        });
        return map;
    }

    private static class MyComparator
    implements Comparator<String> {
        private Map<String, Long> map;
        private boolean sort;

        public MyComparator(Map<String, Long> map, boolean sort) {
            this.map = map;
            this.sort = sort;
        }

        @Override
        public int compare(String o1, String o2) {
            Long l1 = this.map.get(o1);
            Long l2 = this.map.get(o2);
            return this.sort ? (l1 <= l2 ? -1 : 1) : (l1 >= l2 ? -1 : 1);
        }
    }

    public static class UpdateParams {
        private String query;
        private long timeStart;
        private long timeFinish;
        private String interval;
        private DisplayOptions displayOptions;
        private String field;
        private boolean sort;
        private int noSources;

        public UpdateParams(String query, long timeStart, long timeFinish, String interval) {
            this.query = query;
            this.timeStart = timeStart;
            this.timeFinish = timeFinish;
            this.interval = interval;
        }

        public UpdateParams(String query, DisplayOptions displayOptions) {
            this.query = query;
            this.timeStart = displayOptions.getTimeStart();
            this.timeFinish = displayOptions.getTimeFinish();
            this.interval = displayOptions.getIntervalObj().getValue();
            this.displayOptions = displayOptions;
        }

        public String getQuery() {
            return this.query;
        }

        public void setQuery(String query) {
            this.query = query;
        }

        public long getTimeStart() {
            return this.timeStart;
        }

        public void setTimeStart(long timeStart) {
            this.timeStart = timeStart;
        }

        public long getTimeFinish() {
            return this.timeFinish;
        }

        public void setTimeFinish(long timeFinish) {
            this.timeFinish = timeFinish;
        }

        public String getInterval() {
            return this.interval;
        }

        public void setInterval(String interval) {
            this.interval = interval;
        }

        public DisplayOptions getDisplayOptions() {
            return this.displayOptions;
        }

        public void setDisplayOptions(DisplayOptions displayOptions) {
            this.displayOptions = displayOptions;
        }

        public String getField() {
            return this.field;
        }

        public UpdateParams setField(String field) {
            this.field = field;
            return this;
        }

        public boolean isSort() {
            return this.sort;
        }

        public UpdateParams setSort(boolean sort) {
            this.sort = sort;
            return this;
        }

        public int getNoSources() {
            return this.noSources;
        }

        public UpdateParams setNoSources(int noSources) {
            this.noSources = noSources;
            return this;
        }
    }
}

