/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.securityevents.query;

import java.awt.event.MouseEvent;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.Range;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import rs.co.ast.aspen.api.service.SecurityEvent;
import rs.co.ast.aspen.gui.module.securityevents.SecurityEventDetailsTableModel;
import rs.co.ast.aspen.gui.module.securityevents.SecurityEventWrapper;

public class QueryManager {
    private static final DateTimeFormatter DTF = ISODateTimeFormat.dateTime().withZone(DateTimeZone.getDefault());

    public static String copySEDetailsRow(SecurityEventDetailsTableModel.Item item, int columnIndex) {
        StringBuilder sb = new StringBuilder();
        if (item.getKey() != null && item.getValue() != null) {
            String category = item.getCategory().replaceAll("<html><b>", "").replaceAll("</b></html>", "").toLowerCase();
            if (columnIndex != 1) {
                sb.append(category);
                if (category.length() > 0) {
                    sb.append(".");
                }
                sb.append(item.getKey());
                sb.append(":");
            }
            sb.append("\"");
            String value = item.getValue().replace("\\", "\\\\");
            if (category.contains("when")) {
                try {
                    value = DTF.print(Long.valueOf(value).longValue());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            sb.append(value);
            sb.append("\"");
        } else {
            sb.append("");
        }
        return sb.toString();
    }

    public static String copySecurityEventColumn(SecurityEvent event, String category) {
        StringBuilder sb = new StringBuilder();
        switch (category) {
            case "What": {
                List entries;
                SecurityEvent.What what = event.getWhat();
                if (what == null || (entries = what.getEntry()) == null || entries.isEmpty()) break;
                for (SecurityEvent.What.Entry entry : entries) {
                    sb.append(entry.getKey().toLowerCase());
                    sb.append(":\"");
                    sb.append(entry.getValue());
                    sb.append("\"");
                    sb.append("\n");
                }
                break;
            }
            case "Who": {
                List entries;
                SecurityEvent.Who who = event.getWho();
                if (who == null || (entries = who.getEntry()) == null || entries.isEmpty()) break;
                for (SecurityEvent.Who.Entry entry : entries) {
                    sb.append(entry.getKey().toLowerCase());
                    sb.append(":\"");
                    sb.append(entry.getValue());
                    sb.append("\"");
                    sb.append("\n");
                }
                break;
            }
            case "When": {
                List entries;
                SecurityEvent.When when = event.getWhen();
                if (when == null || (entries = when.getEntry()) == null || entries.isEmpty()) break;
                for (SecurityEvent.When.Entry entry : entries) {
                    sb.append(entry.getKey().toLowerCase());
                    sb.append(":\"");
                    sb.append(entry.getValue());
                    sb.append("\"");
                    sb.append("\n");
                }
                break;
            }
            case "Where": {
                List entries;
                SecurityEvent.Where where = event.getWhere();
                if (where == null || (entries = where.getEntry()) == null || entries.isEmpty()) break;
                for (SecurityEvent.Where.Entry entry : entries) {
                    sb.append(entry.getKey().toLowerCase());
                    sb.append(":\"");
                    sb.append(entry.getValue());
                    sb.append("\"");
                    sb.append("\n");
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid column name");
            }
        }
        return sb.toString();
    }

    public static String makeCorrelationIdsQuery(String value) {
        String[] ids = value.split(",");
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (int i = 0; i < ids.length; ++i) {
            sb.append("_id:");
            sb.append("\"");
            sb.append(ids[i]);
            sb.append("\"");
            if (i == ids.length - 1) continue;
            sb.append(" OR ");
        }
        sb.append(")");
        return sb.toString();
    }

    public static String makeGraphZoomQuery(SecurityEventWrapper securityEventWrapper, DateTimeFormatter isoTimeFormat, PlotChangeEvent event) {
        Range dataRange = ((XYPlot)event.getPlot()).getDomainAxis().getRange();
        StringBuilder query = new StringBuilder();
        Pattern p = Pattern.compile(".*timestamp:\\[(.*)\\s+TO\\s+(.*)\\].*");
        Matcher m = p.matcher(securityEventWrapper.getQuery());
        if (m.matches() && m.groupCount() > 1) {
            String tmpQuery = securityEventWrapper.getQuery();
            tmpQuery = tmpQuery.replace(m.group(1), isoTimeFormat.print(Double.valueOf(dataRange.getLowerBound()).longValue()));
            tmpQuery = tmpQuery.replace(m.group(2), isoTimeFormat.print(Double.valueOf(dataRange.getUpperBound()).longValue()));
            query.append(tmpQuery);
        } else {
            boolean prefix;
            query.append(securityEventWrapper.getQuery());
            boolean bl = prefix = !securityEventWrapper.getQuery().equals("");
            if (prefix) {
                query.append(" AND ");
            }
            query.append("timestamp:[");
            query.append(isoTimeFormat.print(Double.valueOf(dataRange.getLowerBound()).longValue()));
            query.append(" TO ");
            query.append(isoTimeFormat.print(Double.valueOf(dataRange.getUpperBound()).longValue()));
            query.append("]");
        }
        return query.toString();
    }

    public static String makeQueryTimeQuery(long timeStart, long timeFinish, DateTimeFormatter isoTimeFormat) {
        StringBuilder sb = new StringBuilder();
        sb.append("timestamp:[");
        sb.append(isoTimeFormat.print(timeStart));
        sb.append(" TO ");
        sb.append(isoTimeFormat.print(timeFinish));
        sb.append("]");
        return sb.toString();
    }

    public static String makeSEDetailsQuery(SecurityEventDetailsTableModel.Item item, SecurityEventWrapper securityEventWrapper, MouseEvent e, int columnIndex) {
        StringBuilder sb = new StringBuilder();
        if (columnIndex == 0) {
            sb.append(item.getCategory().replaceAll("<html><b>", "").replaceAll("</b></html>", "").toLowerCase());
            if (item.getCategory().length() > 0) {
                sb.append(".");
            }
            sb.append(item.getKey());
            sb.append(":");
            sb.append("\"");
            sb.append(item.getValue().replace("\\", "\\\\").replace("\"", "\\\""));
            sb.append("\"");
        } else {
            sb.append("\"");
            sb.append(item.getValue().replace("\\", "\\\\").replace("\"", "\\\""));
            sb.append("\"");
        }
        StringBuilder query = new StringBuilder();
        String text = sb.toString();
        if (securityEventWrapper.getQuery() == null) {
            securityEventWrapper.setQuery("");
        }
        String prevQuery = securityEventWrapper.getQuery().trim();
        boolean prefix = false;
        prefix = prevQuery.isEmpty() ? false : !prevQuery.endsWith("OR") && !prevQuery.endsWith("AND");
        if (QueryManager.isCTRL_ALT_CLICK(e)) {
            if (prefix) {
                query.append(" OR");
            }
            query.append(" ").append(text);
        } else if (e.isShiftDown()) {
            if (prefix) {
                query.append(" ");
            }
            query.append(" AND NOT");
            query.append(" ").append(text);
        } else if (e.isControlDown()) {
            if (prefix) {
                query.append(" AND");
            }
            query.append(" ").append(text);
        }
        return query.toString();
    }

    private static boolean isCTRL_ALT_CLICK(MouseEvent e) {
        int onmask = 1664;
        return (e.getModifiersEx() & onmask) == onmask;
    }
}

