/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.securityevents;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.JXTaskPaneContainer;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import rs.co.ast.aspen.api.service.ApiService;
import rs.co.ast.aspen.gui.module.securityevents.DisplayOptions;
import rs.co.ast.aspen.gui.module.securityevents.widget.ByFieldPanel;
import rs.co.ast.aspen.gui.module.securityevents.widget.ByPriorityPanel;
import rs.co.ast.aspen.gui.module.securityevents.widget.Widget;
import rs.co.ast.aspen.gui.module.securityevents.widget.WidgetSettingsPanel;
import rs.co.ast.aspen.gui.module.securityevents.widget.WidgetUpdateWorker;

public class OverviewPanel
extends JPanel {
    private ExecutorService executor;
    private final List<Widget> widgets = new ArrayList<Widget>();
    private ByPriorityPanel byPriorityPanel;
    private ByFieldPanel byFieldPanelRight;
    private ByFieldPanel byFieldPanelLeft;
    private final String byPriority = NbBundle.getMessage(OverviewPanel.class, (String)"widget.eventsByPriority.title");
    private final String drawingWidget = NbBundle.getMessage(ByPriorityPanel.class, (String)"Widgets.progress.title");
    private WidgetSettingsPanel widgetSettingsPanelLeft = new WidgetSettingsPanel();
    private WidgetSettingsPanel widgetSettingsPanelRight = new WidgetSettingsPanel();
    private ApiService apiService = (ApiService)Lookup.getDefault().lookup(ApiService.class);
    private String search;
    private DisplayOptions displayOptions;
    private JXTaskPane tpLeft;
    private JXTaskPane tpRight;
    private JScrollPane jScrollPane1;
    private JPanel pContents;

    public OverviewPanel() {
        this.initComponents();
        this.widgetSettingsPanelRight.getCbFields().addItem("where.hostname");
        this.widgetSettingsPanelLeft.getCbFields().addItem("what.text");
        this.widgetSettingsPanelRight.getCbFields().setSelectedItem("where.hostname");
        this.widgetSettingsPanelLeft.getCbFields().setSelectedItem("what.text");
        this.byPriorityPanel = new ByPriorityPanel();
        this.byFieldPanelLeft = new ByFieldPanel();
        this.byFieldPanelRight = new ByFieldPanel();
        this.widgets.add(this.byPriorityPanel);
        this.widgets.add(this.byFieldPanelLeft);
        this.widgets.add(this.byFieldPanelRight);
        JXTaskPaneContainer tpcTop = new JXTaskPaneContainer();
        JXTaskPaneContainer tpcLeft = new JXTaskPaneContainer();
        JXTaskPaneContainer tpcRight = new JXTaskPaneContainer();
        JPanel panelTop = new JPanel();
        panelTop.setLayout(new BorderLayout());
        panelTop.add((Component)tpcTop, "North");
        JPanel panelOther = new JPanel();
        panelOther.setLayout(new GridLayout(0, 2, 5, 10));
        panelOther.add((Component)tpcLeft);
        panelOther.add((Component)tpcRight);
        this.pContents.setLayout(new BorderLayout());
        this.pContents.add((Component)panelTop, "North");
        this.pContents.add((Component)panelOther, "Center");
        JXTaskPane tp1 = new JXTaskPane();
        tp1.setTitle(this.byPriority);
        tp1.add((Component)this.byPriorityPanel);
        tpcTop.add((Component)tp1);
        this.tpLeft = new JXTaskPane();
        this.setLeftTaskPaneTitle();
        this.tpLeft.add((Component)this.widgetSettingsPanelLeft);
        this.tpLeft.add((Component)this.byFieldPanelLeft);
        tpcLeft.add((Component)this.tpLeft);
        this.tpRight = new JXTaskPane();
        this.setRightTaskPaneTitle();
        this.tpRight.add((Component)this.widgetSettingsPanelRight);
        this.tpRight.add((Component)this.byFieldPanelRight);
        tpcRight.add((Component)this.tpRight);
        this.widgetSettingsPanelLeft.getbUpdate().addActionListener(e -> {
            if (this.displayOptions != null) {
                ExecutorService buttonExecutor = Executors.newSingleThreadExecutor();
                this.setLeftTaskPaneTitle();
                buttonExecutor.execute(new WidgetUpdateWorker(new ByFieldPanel.UpdateParams(this.search, this.displayOptions).setField(this.widgetSettingsPanelLeft.getSelectedField()).setSort(this.widgetSettingsPanelLeft.getSort()).setNoSources(this.widgetSettingsPanelLeft.getNoSources()), String.format("%s ( %s )", this.drawingWidget, this.tpLeft.getTitle()), this.byFieldPanelLeft, this.displayOptions));
                buttonExecutor.shutdown();
            }
        });
        this.widgetSettingsPanelRight.getbUpdate().addActionListener(e -> {
            if (this.displayOptions != null) {
                ExecutorService buttonExecutor = Executors.newSingleThreadExecutor();
                this.setRightTaskPaneTitle();
                buttonExecutor.execute(new WidgetUpdateWorker(new ByFieldPanel.UpdateParams(this.search, this.displayOptions).setField(this.widgetSettingsPanelRight.getSelectedField()).setSort(this.widgetSettingsPanelRight.getSort()).setNoSources(this.widgetSettingsPanelRight.getNoSources()), String.format(" %s ( %s )", this.drawingWidget, this.tpRight.getTitle()), this.byFieldPanelRight, this.displayOptions));
                buttonExecutor.shutdown();
            }
        });
    }

    public void setMappingsInWidgetSettigsPanels(Set<String> fields) {
        if (!fields.isEmpty()) {
            String sfLeft = this.widgetSettingsPanelLeft.getSelectedField();
            String sfRight = this.widgetSettingsPanelRight.getSelectedField();
            this.widgetSettingsPanelLeft.getCbFields().removeAllItems();
            this.widgetSettingsPanelRight.getCbFields().removeAllItems();
            fields.forEach(f -> {
                this.widgetSettingsPanelLeft.getCbFields().addItem((String)f);
                this.widgetSettingsPanelRight.getCbFields().addItem((String)f);
            });
            this.widgetSettingsPanelLeft.getCbFields().setSelectedItem(sfLeft);
            this.widgetSettingsPanelRight.getCbFields().setSelectedItem(sfRight);
        }
    }

    private void setRightTaskPaneTitle() {
        this.tpRight.setTitle(String.format("%s %d events by %s", this.widgetSettingsPanelRight.getSortText(), this.widgetSettingsPanelRight.getNoSources(), this.widgetSettingsPanelRight.getSelectedField()));
    }

    private void setLeftTaskPaneTitle() {
        this.tpLeft.setTitle(String.format("%s %d events by %s", this.widgetSettingsPanelLeft.getSortText(), this.widgetSettingsPanelLeft.getNoSources(), this.widgetSettingsPanelLeft.getSelectedField()));
    }

    public ByPriorityPanel getByPriorityPanel() {
        return this.byPriorityPanel;
    }

    public void update(String search, DisplayOptions displayOptions) {
        this.search = search;
        this.displayOptions = displayOptions;
        String progresText = "%s ( %s )";
        this.executor = Executors.newFixedThreadPool(displayOptions.getWidgetThreads());
        if (this.executor.isShutdown()) {
            this.executor = Executors.newFixedThreadPool(displayOptions.getWidgetThreads());
        } else {
            this.executor.shutdownNow();
            this.executor = Executors.newFixedThreadPool(displayOptions.getWidgetThreads());
        }
        for (Widget widget : this.widgets) {
            widget.setQueuePanel();
            if (widget instanceof ByPriorityPanel) {
                this.executor.execute(new WidgetUpdateWorker(new ByPriorityPanel.UpdateParams(search, displayOptions), String.format(progresText, this.drawingWidget, this.byPriority), widget, displayOptions));
                continue;
            }
            if (!(widget instanceof ByFieldPanel)) continue;
            if (widget.equals(this.byFieldPanelLeft)) {
                this.setLeftTaskPaneTitle();
                this.executor.execute(new WidgetUpdateWorker(new ByFieldPanel.UpdateParams(search, displayOptions).setField(this.widgetSettingsPanelLeft.getSelectedField()).setSort(this.widgetSettingsPanelLeft.getSort()).setNoSources(this.widgetSettingsPanelLeft.getNoSources()), String.format(progresText, this.drawingWidget, this.tpLeft.getTitle()), widget, displayOptions));
                continue;
            }
            if (!widget.equals(this.byFieldPanelRight)) continue;
            this.setRightTaskPaneTitle();
            this.executor.execute(new WidgetUpdateWorker(new ByFieldPanel.UpdateParams(search, displayOptions).setField(this.widgetSettingsPanelRight.getSelectedField()).setSort(this.widgetSettingsPanelRight.getSort()).setNoSources(this.widgetSettingsPanelRight.getNoSources()), String.format(progresText, this.drawingWidget, this.tpRight.getTitle()), widget, displayOptions));
        }
        this.executor.shutdown();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.pContents = new JPanel();
        this.pContents.setLayout(new GridLayout(1, 2));
        this.jScrollPane1.setViewportView(this.pContents);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 711, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 441, Short.MAX_VALUE).addContainerGap()));
    }
}

