/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.centralized.api.manager.account;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.openide.util.NbBundle;
import rs.co.ast.aspen.api.service.ApiAccount;

public class AccountsTableModel
extends AbstractTableModel {
    private List<ApiAccount> accounts;
    private List<ApiAccount> allAccounts;

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return ApiAccount.class;
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public String getColumnName(int column) {
        return NbBundle.getMessage(AccountsTableModel.class, (String)"CentralizedApiAccountManagerTopComponent.tAccounts.col0.title");
    }

    public void setData(List<ApiAccount> accounts) {
        this.accounts = accounts;
        this.allAccounts = accounts;
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.accounts != null ? this.accounts.size() : 0;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex >= 0 && rowIndex < this.accounts.size()) {
            return this.accounts.get(rowIndex);
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public ApiAccount getAccountByRow(int row) {
        ApiAccount account = null;
        if (row >= 0 && row < this.accounts.size()) {
            account = this.accounts.get(row);
        }
        return account;
    }

    public int getRowByAccountName(String accountName) {
        int ret = -1;
        for (int i = 0; i < this.accounts.size(); ++i) {
            if (!this.accounts.get(i).getName().equalsIgnoreCase(accountName)) continue;
            ret = i;
        }
        return ret;
    }

    public List<ApiAccount> getAllAccounts() {
        return this.accounts;
    }

    public void removeAccount(int selectedRow) {
        this.accounts.remove(selectedRow);
        this.fireTableDataChanged();
    }

    public void filterScripts(String keyword, boolean caseSensitive) {
        if (!keyword.isEmpty() && keyword.length() >= 2) {
            String[] keywords = keyword.split(";");
            ArrayList<ApiAccount> filteredScriptsByKeyword = new ArrayList<ApiAccount>();
            if (keywords.length != 0) {
                for (ApiAccount acc : this.accounts) {
                    if (!this.stringContainsItemFromList(acc.getName(), keywords, caseSensitive) && !this.stringContainsItemFromList(acc.getApiKey(), keywords, caseSensitive)) continue;
                    filteredScriptsByKeyword.add(acc);
                }
                this.accounts = filteredScriptsByKeyword;
            }
        } else {
            this.accounts = this.allAccounts;
        }
        this.fireTableDataChanged();
    }

    private boolean stringContainsItemFromList(String inputStr, String[] items, boolean caseSensitive) {
        for (String item : items) {
            inputStr = caseSensitive ? inputStr : inputStr.toLowerCase();
            String string = item = caseSensitive ? item : item.toLowerCase();
            if (!inputStr.contains(item)) continue;
            return true;
        }
        return false;
    }

    public List<ApiAccount> sortAccountsByName(boolean abcSort) {
        if (abcSort) {
            Collections.sort(this.accounts, new AccountComparatorByName());
        } else {
            Collections.sort(this.accounts, new AccountComparatorByName());
            Collections.reverse(this.accounts);
        }
        this.fireTableDataChanged();
        return this.accounts;
    }

    private class AccountComparatorByName
    implements Comparator<ApiAccount> {
        private AccountComparatorByName() {
        }

        @Override
        public int compare(ApiAccount o1, ApiAccount o2) {
            return o1.getName().toLowerCase().compareTo(o2.getName().toLowerCase());
        }
    }
}

