/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.gui.module.login;

import java.awt.Color;
import java.awt.Component;
import java.nio.charset.StandardCharsets;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicComboBoxRenderer;

public class ComboBoxRenderer
extends BasicComboBoxRenderer {
    JPanel textPanel;
    JLabel text;
    Color[] colors = new Color[]{Color.BLUE, Color.CYAN, Color.GREEN, Color.MAGENTA, Color.ORANGE};

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        Component c = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        if (index > -1) {
            c.setForeground(this.getColor(value.toString()));
        }
        return c;
    }

    public Color getColorForIndex(int index, Object value) {
        if (index < 0) {
            return UIManager.getColor("JTextField.foreground");
        }
        if (index >= this.colors.length) {
            return UIManager.getColor("JTextField.foreground");
        }
        return this.getColor(value.toString());
    }

    private Color getColor(String value) {
        byte[] bytes = value.getBytes(StandardCharsets.US_ASCII);
        int sumOfBytes = 0;
        for (byte b : bytes) {
            sumOfBytes += b;
        }
        int y = ((sumOfBytes %= 150) % 2 * 9 + sumOfBytes) % 150;
        return new Color(y, sumOfBytes, y);
    }
}

