/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.debug.custom;

import com.jme3.animation.Bone;
import com.jme3.animation.Skeleton;
import com.jme3.bounding.BoundingBox;
import com.jme3.bounding.BoundingSphere;
import com.jme3.bounding.BoundingVolume;
import com.jme3.math.Quaternion;
import com.jme3.math.Vector3f;
import com.jme3.scene.Geometry;
import com.jme3.scene.Mesh;
import com.jme3.scene.Node;
import com.jme3.scene.VertexBuffer;
import com.jme3.scene.debug.custom.BoneShape;
import com.jme3.scene.shape.Sphere;
import com.jme3.util.BufferUtils;
import java.nio.FloatBuffer;
import java.util.HashMap;
import java.util.Map;

public class SkeletonBone
extends Node {
    private Skeleton skeleton;
    private Map<Bone, Node> boneNodes = new HashMap<Bone, Node>();
    private Map<Node, Bone> nodeBones = new HashMap<Node, Bone>();
    private Node selectedNode = null;
    private boolean guessBonesOrientation = false;

    public SkeletonBone(Skeleton skeleton, Map<Integer, Float> boneLengths, boolean guessBonesOrientation) {
        this.skeleton = skeleton;
        this.skeleton.reset();
        this.skeleton.updateWorldVectors();
        this.guessBonesOrientation = guessBonesOrientation;
        BoneShape boneShape = new BoneShape(5, 12, 0.02f, 0.07f, 1.0f, false, false);
        Sphere jointShape = new Sphere(10, 10, 0.1f);
        jointShape.setBuffer(VertexBuffer.Type.Color, 4, BufferUtils.createFloatBuffer(jointShape.getVertexCount() * 4));
        FloatBuffer cb = jointShape.getFloatBuffer(VertexBuffer.Type.Color);
        cb.rewind();
        for (int i = 0; i < jointShape.getVertexCount(); ++i) {
            cb.put(0.05f).put(0.05f).put(0.05f).put(1.0f);
        }
        for (Bone bone : skeleton.getRoots()) {
            this.createSkeletonGeoms(bone, boneShape, jointShape, boneLengths, skeleton, this, guessBonesOrientation);
        }
        this.updateModelBound();
        Sphere originShape = new Sphere(10, 10, 0.02f);
        originShape.setBuffer(VertexBuffer.Type.Color, 4, BufferUtils.createFloatBuffer(originShape.getVertexCount() * 4));
        cb = originShape.getFloatBuffer(VertexBuffer.Type.Color);
        cb.rewind();
        for (int i = 0; i < jointShape.getVertexCount(); ++i) {
            cb.put(0.4f).put(0.4f).put(0.05f).put(1.0f);
        }
        Geometry origin = new Geometry("origin", originShape);
        BoundingVolume bv = this.getWorldBound();
        float scale = 1.0f;
        if (bv.getType() == BoundingVolume.Type.AABB) {
            BoundingBox bb = (BoundingBox)bv;
            scale = (bb.getXExtent() + bb.getYExtent() + bb.getZExtent()) / 3.0f;
        } else if (bv.getType() == BoundingVolume.Type.Sphere) {
            BoundingSphere bs = (BoundingSphere)bv;
            scale = bs.getRadius();
        }
        origin.scale(scale);
        this.attachChild(origin);
    }

    protected final void createSkeletonGeoms(Bone bone, Mesh boneShape, Mesh jointShape, Map<Integer, Float> boneLengths, Skeleton skeleton, Node parent, boolean guessBonesOrientation) {
        if (guessBonesOrientation && bone.getName().equalsIgnoreCase("Site")) {
            return;
        }
        Node n = new Node(bone.getName() + "Node");
        Geometry bGeom = new Geometry(bone.getName(), boneShape);
        Geometry jGeom = new Geometry(bone.getName() + "Joint", jointShape);
        n.setLocalTranslation(bone.getLocalPosition());
        n.setLocalRotation(bone.getLocalRotation());
        float boneLength = boneLengths.get(skeleton.getBoneIndex(bone)).floatValue();
        n.setLocalScale(bone.getLocalScale());
        bGeom.setLocalRotation(new Quaternion().fromAngleAxis(-1.5707964f, Vector3f.UNIT_X).normalizeLocal());
        if (guessBonesOrientation) {
            if (bone.getChildren().size() == 1) {
                Vector3f v = bone.getChildren().get(0).getLocalPosition();
                Quaternion q = new Quaternion();
                q.lookAt(v, Vector3f.UNIT_Z);
                bGeom.setLocalRotation(q);
                boneLength = v.length();
            }
            if (bone.getChildren().isEmpty()) {
                if (parent.getChildren().size() > 0) {
                    bGeom.setLocalRotation(parent.getChild(0).getLocalRotation());
                } else {
                    bGeom.setLocalRotation(bone.getBindRotation());
                }
            }
        }
        bGeom.setLocalScale(boneLength);
        jGeom.setLocalScale(boneLength);
        n.attachChild(bGeom);
        n.attachChild(jGeom);
        if (bone.getChildren().size() != 1) {
            Geometry gt = jGeom.clone();
            gt.scale(0.8f);
            Vector3f v = new Vector3f(0.0f, boneLength, 0.0f);
            if (guessBonesOrientation) {
                if (bone.getChildren().isEmpty()) {
                    if (parent.getChildren().size() > 0) {
                        gt.setLocalTranslation(bGeom.getLocalRotation().mult(parent.getChild(0).getLocalRotation()).mult(v, v));
                    } else {
                        gt.setLocalTranslation(bGeom.getLocalRotation().mult(bone.getBindRotation()).mult(v, v));
                    }
                }
            } else {
                gt.setLocalTranslation(v);
            }
            n.attachChild(gt);
        }
        this.boneNodes.put(bone, n);
        this.nodeBones.put(n, bone);
        parent.attachChild(n);
        for (Bone childBone : bone.getChildren()) {
            this.createSkeletonGeoms(childBone, boneShape, jointShape, boneLengths, skeleton, n, guessBonesOrientation);
        }
    }

    protected Bone select(Geometry g) {
        Node parentNode = g.getParent();
        if (this.parent != null) {
            Bone b = this.nodeBones.get(parentNode);
            if (b != null) {
                this.selectedNode = parentNode;
            }
            return b;
        }
        return null;
    }

    protected Node getSelectedNode() {
        return this.selectedNode;
    }

    protected final void updateSkeletonGeoms(Bone bone) {
        if (this.guessBonesOrientation && bone.getName().equalsIgnoreCase("Site")) {
            return;
        }
        Node n = this.boneNodes.get(bone);
        n.setLocalTranslation(bone.getLocalPosition());
        n.setLocalRotation(bone.getLocalRotation());
        n.setLocalScale(bone.getLocalScale());
        for (Bone childBone : bone.getChildren()) {
            this.updateSkeletonGeoms(childBone);
        }
    }

    public void updateGeometry() {
        for (Bone bone : this.skeleton.getRoots()) {
            this.updateSkeletonGeoms(bone);
        }
    }
}

