/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.blender.textures.blending;

import com.jme3.scene.plugins.blender.BlenderContext;
import com.jme3.scene.plugins.blender.materials.MaterialHelper;
import com.jme3.scene.plugins.blender.textures.blending.TextureBlender;
import com.jme3.texture.Image;
import java.util.logging.Logger;
import jme3tools.converters.MipMapGenerator;

abstract class AbstractTextureBlender
implements TextureBlender {
    private static final Logger LOGGER = Logger.getLogger(AbstractTextureBlender.class.getName());
    protected int flag;
    protected boolean negateTexture;
    protected int blendType;
    protected float[] materialColor;
    protected float[] color;
    protected float blendFactor;

    public AbstractTextureBlender(int flag, boolean negateTexture, int blendType, float[] materialColor, float[] color, float blendFactor) {
        this.flag = flag;
        this.negateTexture = negateTexture;
        this.blendType = blendType;
        this.materialColor = materialColor;
        this.color = color;
        this.blendFactor = blendFactor;
    }

    protected void blendHSV(int type, float[] materialRGB, float fac, float[] pixelColor, BlenderContext blenderContext) {
        float oneMinusFactor = 1.0f - fac;
        MaterialHelper materialHelper = (MaterialHelper)blenderContext.getHelper(MaterialHelper.class);
        switch (type) {
            case 10: {
                float[] colorTransformResult = new float[3];
                materialHelper.rgbToHsv(pixelColor[0], pixelColor[1], pixelColor[2], colorTransformResult);
                if (colorTransformResult[0] == 0.0f) break;
                float colH = colorTransformResult[0];
                materialHelper.rgbToHsv(materialRGB[0], materialRGB[1], materialRGB[2], colorTransformResult);
                materialHelper.hsvToRgb(colH, colorTransformResult[1], colorTransformResult[2], colorTransformResult);
                materialRGB[0] = oneMinusFactor * materialRGB[0] + fac * colorTransformResult[0];
                materialRGB[1] = oneMinusFactor * materialRGB[1] + fac * colorTransformResult[1];
                materialRGB[2] = oneMinusFactor * materialRGB[2] + fac * colorTransformResult[2];
                break;
            }
            case 11: {
                float[] colorTransformResult = new float[3];
                materialHelper.rgbToHsv(materialRGB[0], materialRGB[1], materialRGB[2], colorTransformResult);
                float h = colorTransformResult[0];
                float s = colorTransformResult[1];
                float v = colorTransformResult[2];
                if (s == 0.0f) break;
                materialHelper.rgbToHsv(pixelColor[0], pixelColor[1], pixelColor[2], colorTransformResult);
                materialHelper.hsvToRgb(h, oneMinusFactor * s + fac * colorTransformResult[1], v, materialRGB);
                break;
            }
            case 12: {
                float[] rgbToHsv = new float[3];
                float[] colToHsv = new float[3];
                materialHelper.rgbToHsv(materialRGB[0], materialRGB[1], materialRGB[2], rgbToHsv);
                materialHelper.rgbToHsv(pixelColor[0], pixelColor[1], pixelColor[2], colToHsv);
                materialHelper.hsvToRgb(rgbToHsv[0], rgbToHsv[1], oneMinusFactor * rgbToHsv[2] + fac * colToHsv[2], materialRGB);
                break;
            }
            case 13: {
                float[] rgbToHsv = new float[3];
                float[] colToHsv = new float[3];
                materialHelper.rgbToHsv(pixelColor[0], pixelColor[1], pixelColor[2], colToHsv);
                if (colToHsv[2] == 0.0f) break;
                materialHelper.rgbToHsv(materialRGB[0], materialRGB[1], materialRGB[2], rgbToHsv);
                materialHelper.hsvToRgb(colToHsv[0], colToHsv[1], rgbToHsv[2], rgbToHsv);
                materialRGB[0] = oneMinusFactor * materialRGB[0] + fac * rgbToHsv[0];
                materialRGB[1] = oneMinusFactor * materialRGB[1] + fac * rgbToHsv[1];
                materialRGB[2] = oneMinusFactor * materialRGB[2] + fac * rgbToHsv[2];
                break;
            }
            default: {
                throw new IllegalStateException("Unknown ramp type: " + type);
            }
        }
    }

    @Override
    public void copyBlendingData(TextureBlender textureBlender) {
        if (textureBlender instanceof AbstractTextureBlender) {
            this.flag = ((AbstractTextureBlender)textureBlender).flag;
            this.negateTexture = ((AbstractTextureBlender)textureBlender).negateTexture;
            this.blendType = ((AbstractTextureBlender)textureBlender).blendType;
            this.materialColor = (float[])((AbstractTextureBlender)textureBlender).materialColor.clone();
            this.color = (float[])((AbstractTextureBlender)textureBlender).color.clone();
            this.blendFactor = ((AbstractTextureBlender)textureBlender).blendFactor;
        } else {
            LOGGER.warning("Cannot copy blending data from other types than " + this.getClass());
        }
    }

    protected void prepareImagesForBlending(Image target, Image source) {
        boolean sourceHasMipmaps;
        boolean targetHasMipmaps;
        LOGGER.fine("Generating mipmaps if needed!");
        boolean bl = target == null ? false : (targetHasMipmaps = target.getMipMapSizes() != null && target.getMipMapSizes().length > 0);
        boolean bl2 = source == null ? false : (sourceHasMipmaps = source.getMipMapSizes() != null && source.getMipMapSizes().length > 0);
        if (target != null && !targetHasMipmaps && sourceHasMipmaps) {
            MipMapGenerator.generateMipMaps((Image)target);
        } else if (source != null && !sourceHasMipmaps && targetHasMipmaps) {
            MipMapGenerator.generateMipMaps((Image)source);
        }
    }
}

