/*
 * Decompiled with CFR 0.152.
 */
package rs.co.ast.aspen.core.module.visengine.graph;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import rs.co.ast.aspen.core.module.visengine.graph.Edge;
import rs.co.ast.aspen.core.module.visengine.graph.Node;
import rs.co.ast.aspen.core.module.visengine.graph.NodeId;

public class Graph {
    private final List<Node> allNodes = new ArrayList<Node>();
    private final Map<String, Node> allNodesById = new HashMap<String, Node>();
    private final Map<String, Node> rootNodesById = new HashMap<String, Node>();

    public void clearAllNodes() {
        this.allNodes.clear();
        this.allNodesById.clear();
        this.rootNodesById.clear();
    }

    public void addRootNode(Map<String, String> attributes) {
        Node node = new Node(attributes);
        if (!this.rootNodesById.containsKey(node.id)) {
            this.rootNodesById.put(node.id, node);
            this.allNodesById.put(node.id, node);
            this.allNodes.add(node);
        }
    }

    public Iterator<Node> allNodes() {
        return this.allNodes.iterator();
    }

    public List<Node> allNodesList() {
        ArrayList<Node> list = new ArrayList<Node>();
        for (Node n : this.allNodes) {
            int ttl = Integer.valueOf(n.get("%ttl", "1"));
            boolean visible = Boolean.valueOf(n.get("%visible", "true"));
            if (ttl > 0 || visible) {
                list.add(n);
                continue;
            }
            this.allNodesById.remove(n.id);
        }
        this.allNodes.clear();
        this.allNodes.addAll(list);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeNodeId(Map<String, String> currentKeyAttrs, Map<String, String> newKeyAttrs) {
        Node n = this.findNodeByIndexKey(currentKeyAttrs, false);
        if (n != null) {
            this.allNodesById.remove(n.id);
            this.rootNodesById.remove(n.id);
            n.keyAttributes.clear();
            n.setAll(newKeyAttrs);
            n.id = new NodeId(newKeyAttrs).toString();
            this.allNodesById.put(n.id, n);
            this.rootNodesById.put(n.id, n);
            Object object = n.edgesLock;
            synchronized (object) {
                n.edges().forEachRemaining(e -> {
                    e.nodes.clear();
                    e.nodes.addAll(Edge.order(n, e.other(n)));
                });
            }
        }
    }

    public Node findNodeByIndexKey(Map<String, String> attrs, boolean create) {
        Node n = new Node(attrs);
        Node found = this.allNodesById.get(n.id);
        if (found == null && create) {
            this.allNodesById.put(n.id, n);
            this.allNodes.add(n);
            found = n;
        }
        return found;
    }

    public Node findNodeByAttributes(Map<String, String> attrs) {
        Node ret = null;
        for (Node n : this.allNodes) {
            if (!this.matchAttributes(n, attrs)) continue;
            ret = n;
            break;
        }
        return ret;
    }

    public Iterator<Node> rootNodes() {
        return this.rootNodesById.values().iterator();
    }

    private boolean matchAttributes(Node n, Map<String, String> attrs) {
        boolean ret = true;
        for (Map.Entry<String, String> e : attrs.entrySet()) {
            if (n == null || e.getValue() == null || e.getValue().equals(n.get(e.getKey()))) continue;
            ret = false;
            break;
        }
        return ret;
    }
}

