/*
 * Decompiled with CFR 0.152.
 */
package com.jme3.scene.plugins.gltf;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.jme3.asset.AssetLoadException;
import com.jme3.scene.plugins.gltf.ExtensionLoader;
import com.jme3.scene.plugins.gltf.ExtrasLoader;
import com.jme3.scene.plugins.gltf.GltfLoader;
import com.jme3.scene.plugins.gltf.GltfModelKey;
import com.jme3.scene.plugins.gltf.PBRSpecGlossExtensionLoader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CustomContentManager {
    private static final Logger logger = Logger.getLogger(CustomContentManager.class.getName());
    private GltfModelKey key;
    private GltfLoader gltfLoader;
    private static Map<String, ExtensionLoader> defaultExtensionLoaders = new HashMap<String, ExtensionLoader>();

    void init(GltfLoader gltfLoader) {
        JsonArray extensionRequired;
        JsonArray extensionUsed;
        this.gltfLoader = gltfLoader;
        if (gltfLoader.getInfo().getKey() instanceof GltfModelKey) {
            this.key = (GltfModelKey)gltfLoader.getInfo().getKey();
        }
        if ((extensionUsed = gltfLoader.getDocRoot().getAsJsonArray("extensionsUsed")) != null) {
            for (JsonElement extElem : extensionUsed) {
                String ext = extElem.getAsString();
                if (ext == null || defaultExtensionLoaders.get(ext) != null || this.key == null || this.key.getExtensionLoader(ext) != null) continue;
                logger.log(Level.WARNING, "Extension " + ext + " is not supported, please provide your own implementation in the GltfModelKey");
            }
        }
        if ((extensionRequired = gltfLoader.getDocRoot().getAsJsonArray("extensionsRequired")) != null) {
            for (JsonElement extElem : extensionRequired) {
                String ext = extElem.getAsString();
                if (ext == null || defaultExtensionLoaders.get(ext) != null || this.key == null || this.key.getExtensionLoader(ext) != null) continue;
                logger.log(Level.SEVERE, "Extension " + ext + " is mandatory for this file, the loaded scene result will be unexpected.");
            }
        }
    }

    public <T> T readExtensionAndExtras(String name, JsonElement el, T input) throws AssetLoadException, IOException {
        T output = this.readExtension(name, el, input);
        output = this.readExtras(name, el, output);
        return output;
    }

    private <T> T readExtension(String name, JsonElement el, T input) throws AssetLoadException, IOException {
        JsonObject extensions = el.getAsJsonObject().getAsJsonObject("extensions");
        if (extensions == null) {
            return input;
        }
        for (Map.Entry ext : extensions.getAsJsonObject().entrySet()) {
            ExtensionLoader loader = null;
            if (this.key != null) {
                loader = this.key.getExtensionLoader((String)ext.getKey());
            }
            if (loader == null) {
                loader = defaultExtensionLoaders.get(ext.getKey());
            }
            if (loader == null) {
                logger.log(Level.WARNING, "Could not find loader for extension " + (String)ext.getKey());
                continue;
            }
            try {
                return (T)loader.handleExtension(this.gltfLoader, name, el, (JsonElement)ext.getValue(), input);
            }
            catch (ClassCastException e) {
                throw new AssetLoadException("Extension loader " + loader.getClass().getName() + " for extension " + (String)ext.getKey() + " is incompatible with type " + input.getClass(), (Throwable)e);
            }
        }
        return input;
    }

    private <T> T readExtras(String name, JsonElement el, T input) throws AssetLoadException {
        if (this.key == null) {
            return input;
        }
        ExtrasLoader loader = this.key.getExtrasLoader();
        if (loader == null) {
            return input;
        }
        JsonObject extras = el.getAsJsonObject().getAsJsonObject("extras");
        if (extras == null) {
            return input;
        }
        try {
            return (T)loader.handleExtras(this.gltfLoader, name, el, (JsonElement)extras, input);
        }
        catch (ClassCastException e) {
            throw new AssetLoadException("Extra loader " + loader.getClass().getName() + " for " + name + " is incompatible with type " + input.getClass(), (Throwable)e);
        }
    }

    static {
        defaultExtensionLoaders.put("KHR_materials_pbrSpecularGlossiness", new PBRSpecGlossExtensionLoader());
    }
}

